<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SRESERVATIONDEPOSITINWITHFORECASTADDV ServiceType
 * @subpackage Services
 */
class SRESERVATIONDEPOSITINWITHFORECASTADDV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralPost deposit as total amount on the reservation. Packages on the reservation will be posted on the reservation account and settled. Deposit invoice will be created.For group reservations the packages are posted on every
     * reservation account. The payment will be posted on the master reservation account.Prerequisites: All following registry keys are set- Registry key: 1747;c=reservation,v=procFactLstOnCheckIn- Registry key: 1748;c=reservation,v=procLstTypesOnCheckIn-
     * Registry key: 846035;c=crossbow,v=allowPrepaymentInvoicing### Input- RESERVATION-CENTRALID: CentralID of the reservation. Optional, but one out of RESERVATION-CENTRALID or RESERVATION-OBJID needs to be sent to find the reservation.-
     * RESERVATION-OBJID: ObjID of the reservation. Optional, but one out of RESERVATION-CENTRALID or RESERVATION-OBJID needs to be sent to find the reservation.- transactionID. Mandatory. The transaction ID of the payment.- typeofpayment. Mandatory.
     * Payment type for the payment.- paymentAmount. Optional. Amount of the payment (local currency). Payment with amount = 0 is allowed in cases of changes on packages/services and in respect to that may also changes on vat amounts.- approvalNumber.
     * Mandatory. Approval number for the deposit in processing.- processingDate. Mandatory. Date of the deposit in processing.- serviceProvider. Optional. The service provider used for the payment.- paymentDescription. Optional. Field for further
     * description of the payment.- emailForDepositInvoice. Optional. Email address for deposit invoice.### Output- ACCOUNT-OBJID: ObjID of the RESERVATION-ACCOUNT on to the deposit was posted. For group reservations every reservation account is listed.-
     * DepositInvoice- INVOICE-OBJID: ObjID of the deposit invoice.- invoiceNo: Invoice no of the deposit invoice.- invoiceNoSet: Invoice set of the deposit invoice.- amount: Amount of the deposit invoice.- DepositCredit (appears from the second prepayment
     * -- is the cancellation of the previous prepayment invoice)- INVOICE-OBJID: ObjID of the deposit invoice.- invoiceNo: Invoice no of the deposit invoice.- invoiceNoSet: Invoice set of the deposit invoice.- amount: Amount of the deposit invoice.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001Request $body
     * @return \StructType\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001Response|bool
     */
    public function S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001(\StructType\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralPost deposit as total amount on the reservation. Packages on the reservation will be posted on the reservation account and settled. Deposit invoice will be created.For group reservations the packages are posted on every
     * reservation account. The payment will be posted on the master reservation account.Prerequisites: All following registry keys are set* Registry key: 1747;c=reservation,v=procFactLstOnCheckIn* Registry key: 1748;c=reservation,v=procLstTypesOnCheckIn*
     * Registry key: 846035;c=crossbow,v=allowPrepaymentInvoicing### Input- RESERVATION-CENTRALID: CentralID of the reservation. Optional, but one out of RESERVATION-CENTRALID or RESERVATION-OBJID needs to be sent to find the reservation.-
     * RESERVATION-OBJID: ObjID of the reservation. Optional, but one out of RESERVATION-CENTRALID or RESERVATION-OBJID needs to be sent to find the reservation.- transactionID. Mandatory. The transaction ID of the payment.- typeofpayment. Mandatory.
     * Payment type for the payment.- paymentAmount. Optional. Amount of the payment (local currency). Payment with amount = 0 is allowed in cases of changes on packages/services and in respect to that may also changes on vat amounts.- approvalNumber.
     * Mandatory. Approval number for the deposit in processing.- processingDate. Mandatory. Date of the deposit in processing.- serviceProvider. Optional. The service provider used for the payment.- paymentDescription. Optional. Field for further
     * description of the payment.- emailForDepositInvoice. Optional. Email address for deposit invoice.- paymentinstructions: The payment instruction to route the posting, combo box key ("VO"). Key = Value: 0 = own acount; 1 = group acount; 3 = oderer
     * acount### Output- ACCOUNT-OBJID: ObjID of the RESERVATION-ACCOUNT on to the deposit was posted. For group reservations every reservation account is listed.- DepositInvoice- INVOICE-OBJID: ObjID of the deposit invoice.- invoiceNo: Invoice no of the
     * deposit invoice.- invoiceNoSet: Invoice set of the deposit invoice.- amount: Amount of the deposit invoice.- DepositCredit (appears from the second prepayment -- is the cancellation of the previous prepayment invoice)- INVOICE-OBJID: ObjID of the
     * deposit invoice.- invoiceNo: Invoice no of the deposit invoice.- invoiceNoSet: Invoice set of the deposit invoice.- amount: Amount of the deposit invoice.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002Request $body
     * @return \StructType\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002Response|bool
     */
    public function S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002(\StructType\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001Response|\StructType\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
