<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SPERSONPRECHECKINV ServiceType
 * @subpackage Services
 */
class SPERSONPRECHECKINV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_PERSON_PRE_CHECK_IN_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service pre-checks-in a person.### Input- ROOMINGLIST-OBJID: ObjID of the person, which can be obtained from other defined services. Mandatory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_PERSON_PRE_CHECK_IN_V001Request $body
     * @return \StructType\S_PERSON_PRE_CHECK_IN_V001Response|bool
     */
    public function S_PERSON_PRE_CHECK_IN_V001(\StructType\S_PERSON_PRE_CHECK_IN_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_PERSON_PRE_CHECK_IN_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_PERSON_PRE_CHECK_IN_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
