<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SNOTIFICATIONREGISTRATIONSEARCHV ServiceType
 * @subpackage Services
 */
class SNOTIFICATIONREGISTRATIONSEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_NOTIFICATION_REGISTRATION_SEARCH_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns the notifications currently registered for a specific product.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_NOTIFICATION_REGISTRATION_SEARCH_V001Request $body
     * @return \StructType\S_NOTIFICATION_REGISTRATION_SEARCH_V001Response|bool
     */
    public function S_NOTIFICATION_REGISTRATION_SEARCH_V001(\StructType\S_NOTIFICATION_REGISTRATION_SEARCH_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_NOTIFICATION_REGISTRATION_SEARCH_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_NOTIFICATION_REGISTRATION_SEARCH_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
