<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SNOTIFICATIONREGISTERV ServiceType
 * @subpackage Services
 */
class SNOTIFICATIONREGISTERV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_NOTIFICATION_REGISTER_V001
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_NOTIFICATION_REGISTER_V002](../S_NOTIFICATION_REGISTER_V002) - Added input field which can be used to specify that the notification registration should be active for all
     * hotels (activeAllHotels)### GeneralThis service registers for a specific notification.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_NOTIFICATION_REGISTER_V001Request $body
     * @return \StructType\S_NOTIFICATION_REGISTER_V001Response|bool
     */
    public function S_NOTIFICATION_REGISTER_V001(\StructType\S_NOTIFICATION_REGISTER_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_NOTIFICATION_REGISTER_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_NOTIFICATION_REGISTER_V002
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service registers for a specific notification.### Input- product: ID of the product registering the notification (Mandatory)- notificationID: ID of the notification to be sent (Mandatory)- confirmationDisabled: Can be
     * used to disable the confirmation step after receiving and processing the notification. By default this is false, which means confirmation is enabled and required (Optional)- activeAllHotels: Can be used so that the notification being registered will
     * be active for all hotels. By default this is false, which means it would only apply to the current hotel (Optional)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_NOTIFICATION_REGISTER_V002Request $body
     * @return \StructType\S_NOTIFICATION_REGISTER_V002Response|bool
     */
    public function S_NOTIFICATION_REGISTER_V002(\StructType\S_NOTIFICATION_REGISTER_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_NOTIFICATION_REGISTER_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_NOTIFICATION_REGISTER_V001Response|\StructType\S_NOTIFICATION_REGISTER_V002Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
