<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SIMAGEADDV ServiceType
 * @subpackage Services
 */
class SIMAGEADDV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_IMAGE_ADD_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service adds images to a specific table and object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_IMAGE_ADD_V001Request $body
     * @return \StructType\S_IMAGE_ADD_V001Response|bool
     */
    public function S_IMAGE_ADD_V001(\StructType\S_IMAGE_ADD_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_IMAGE_ADD_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_IMAGE_ADD_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
