<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SHOTELSEARCHV ServiceType
 * @subpackage Services
 */
class SHOTELSEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_HOTEL_SEARCH_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns all hotels in the system.The field DUMMY_INTERNAL is only for internal use and must be set to 0.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_HOTEL_SEARCH_V001Request $body
     * @return \StructType\S_HOTEL_SEARCH_V001Response|bool
     */
    public function S_HOTEL_SEARCH_V001(\StructType\S_HOTEL_SEARCH_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_HOTEL_SEARCH_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_HOTEL_SEARCH_V01
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_HOTEL_SEARCH_V001](../S_HOTEL_SEARCH_V001) - Replaced due to naming convention### GeneralThis service returns every hotel in the system.The field DUMMY_INTERNAL is only for
     * internal use and must be set to 0.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_HOTEL_SEARCH_V01Request $body
     * @return \StructType\S_HOTEL_SEARCH_V01Response|bool
     */
    public function S_HOTEL_SEARCH_V01(\StructType\S_HOTEL_SEARCH_V01Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_HOTEL_SEARCH_V01($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_HOTEL_SEARCH_V001Response|\StructType\S_HOTEL_SEARCH_V01Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
