<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGUESTTRAILNODEGETV ServiceType
 * @subpackage Services
 */
class SGUESTTRAILNODEGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GUEST_TRAIL_NODE_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns all trails stored for a guest profile.### Input- GUEST-OBJID: ObjID of the guest profile### Output- Node1Type: The first node from trail structure. values only 4 characters long numbers -> e.g. 0000.-
     * Node2Type: Increasing number below the NodeType (0000, 0001, 0002 and so on...)- description: description of the trail- status: combo box("ts") key value (can be defined in SIHOT)- beginDate: format: yyyy-mm-DD- beginTime: format: hh:mm- endDate:
     * format: yyyy-mm-DD- endTime: format: hh:mm- user: sihot userID- comment: string comment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_TRAIL_NODE_GET_V001Request $body
     * @return \StructType\S_GUEST_TRAIL_NODE_GET_V001Response|bool
     */
    public function S_GUEST_TRAIL_NODE_GET_V001(\StructType\S_GUEST_TRAIL_NODE_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_TRAIL_NODE_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GUEST_TRAIL_NODE_GET_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
