<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGUESTCRITERIASEARCHV ServiceType
 * @subpackage Services
 */
class SGUESTCRITERIASEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GUEST_CRITERIA_SEARCH_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralReturns guests by guest criteria.### Input- SearchCriteria: Mandatory -TYPE: Type of the guest criteria to search for. Mandatory -SUBTYPE: SubType of the guest criteria to search for- SearchCriteria1: Optional - TYPE: Type
     * of the guest criteria to search for - SUBTYPE: SubType of the guest criteria to search for- SearchCriteria2: Optional - TYPE: Type of the guest criteria to search for - SUBTYPE: SubType of the guest criteria to search for### OutputList of guests.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_CRITERIA_SEARCH_V001Request $body
     * @return \StructType\S_GUEST_CRITERIA_SEARCH_V001Response|bool
     */
    public function S_GUEST_CRITERIA_SEARCH_V001(\StructType\S_GUEST_CRITERIA_SEARCH_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_CRITERIA_SEARCH_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GUEST_CRITERIA_SEARCH_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
