<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGUESTCONTACTPERSONREMOVEV ServiceType
 * @subpackage Services
 */
class SGUESTCONTACTPERSONREMOVEV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GUEST_CONTACT_PERSON_REMOVE_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service removes a contact person from a legal entity (company, tour operator or agency).### Input- GUEST-OBJID: ObjID of the guest, which can be obtained from other defined services. Mandatory- CONTACT-PERSON-OBJID:
     * ObjID of the contact person to be removed, which can be obtained from other defined services. Mandatory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_CONTACT_PERSON_REMOVE_V001Request $body
     * @return \StructType\S_GUEST_CONTACT_PERSON_REMOVE_V001Response|bool
     */
    public function S_GUEST_CONTACT_PERSON_REMOVE_V001(\StructType\S_GUEST_CONTACT_PERSON_REMOVE_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_CONTACT_PERSON_REMOVE_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GUEST_CONTACT_PERSON_REMOVE_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
