<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGUESTCONTACTPERSONADDV ServiceType
 * @subpackage Services
 */
class SGUESTCONTACTPERSONADDV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GUEST_CONTACT_PERSON_ADD_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service adds a contact person to a legal entity (company, tour operator or agency).### Input- GUEST-OBJID: ObjID of the guest, which can be obtained from other defined services. Mandatory- CONTACT-PERSON-OBJID: ObjID
     * of the contact person to be added, which can be obtained from other defined services. Mandatory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_CONTACT_PERSON_ADD_V001Request $body
     * @return \StructType\S_GUEST_CONTACT_PERSON_ADD_V001Response|bool
     */
    public function S_GUEST_CONTACT_PERSON_ADD_V001(\StructType\S_GUEST_CONTACT_PERSON_ADD_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_CONTACT_PERSON_ADD_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GUEST_CONTACT_PERSON_ADD_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
