<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGIFTVOUCHERSELLV ServiceType
 * @subpackage Services
 */
class SGIFTVOUCHERSELLV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GIFTVOUCHER_SELL_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service performs a gift voucher sale.### Input- guestObjID: unique id of a guest- serviceCode: service code- amount: amount of the gift voucher- typeOfPayment: type of payment### Output- objid: unique id- status: - 1
     * = valid - 2 = not valid - 3 = redeemed - 4 = invoiced - 5 = suspended - 6 = incomplete - 7 = unavailable- number, externalReference- amount- sellDate, hotelSell, expiryDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GIFTVOUCHER_SELL_V001Request $body
     * @return \StructType\S_GIFTVOUCHER_SELL_V001Response|bool
     */
    public function S_GIFTVOUCHER_SELL_V001(\StructType\S_GIFTVOUCHER_SELL_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GIFTVOUCHER_SELL_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_GIFT_VOUCHER_SELL_V001
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_GIFTVOUCHER_SELL_V001](../S_GIFTVOUCHER_SELL_V001) - Replaced due to naming convention### GeneralThis service performs a gift voucher sale.### Input- guestObjID: unique id
     * of a guest- serviceCode: service code- amount: amount of the gift voucher- typeOfPayment: type of payment### Output- objid: unique id- status: - 1 = valid - 2 = not valid - 3 = redeemed - 4 = invoiced - 5 = suspended - 6 = incomplete - 7 =
     * unavailable- number, externalReference- amount- sellDate, hotelSell, expiryDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GIFT_VOUCHER_SELL_V001Request $body
     * @return \StructType\S_GIFT_VOUCHER_SELL_V001Response|bool
     */
    public function S_GIFT_VOUCHER_SELL_V001(\StructType\S_GIFT_VOUCHER_SELL_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GIFT_VOUCHER_SELL_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GIFTVOUCHER_SELL_V001Response|\StructType\S_GIFT_VOUCHER_SELL_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
