<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGIFTVOUCHERSEARCHV ServiceType
 * @subpackage Services
 */
class SGIFTVOUCHERSEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GIFTVOUCHER_SEARCH_V002
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service searches for gift vouchers.### INPUT- sellDate (compulsory)- sellTo: Period of sell date - giftVoucherNoFrom- giftVoucherNoTo: gift voucher number- externalReference- blocked, all, open: gift voucher state;
     * only one field may be set with 1- holderName- redemptionDate- redemptionDateTo: gift voucher redemption date- hotelSell### OutputList of gift vouchers:- objid: unique id- status: - 1 = valid - 2 = not valid - 3 = redeemed - 4 = invoiced - 5 =
     * suspended - 6 = incomplete - 7 = unavailable- number, externalReference- amount- sellDate, hotelSell, expiryDate- gift voucher holder:- GiftvoucherHolder: - objid - lastName - matchcode - guestHotel - guestNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GIFTVOUCHER_SEARCH_V002Request $body
     * @return \StructType\S_GIFTVOUCHER_SEARCH_V002Response|bool
     */
    public function S_GIFTVOUCHER_SEARCH_V002(\StructType\S_GIFTVOUCHER_SEARCH_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GIFTVOUCHER_SEARCH_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_GIFT_VOUCHER_SEARCH_V002
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_GIFTVOUCHER_SEARCH_V002](../S_GIFTVOUCHER_SEARCH_V002) - Replaced due to naming convention### GeneralThis service searches for gift vouchers.### Input- sellDate
     * (compulsory)- sellTo: Period of sell date - giftVoucherNoFrom- giftVoucherNoTo: gift voucher number- externalReference- blocked, all, open: gift voucher state; only one field may be set with 1- holderName- redemptionDate- redemptionDateTo: gift
     * voucher redemption date- hotelSell### Output- List of gift vouchers - objid: unique id - status: - 1 = valid- 2 = not valid - 3 = redeemed - 4 = invoiced - 5 = suspended - 6 = incomplete - 7 = unavailable - number, externalReference - amount -
     * sellDate, hotelSell, expiryDate - gift voucher holder: - objid - lastName - matchcode - guestHotel - guestNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GIFT_VOUCHER_SEARCH_V002Request $body
     * @return \StructType\S_GIFT_VOUCHER_SEARCH_V002Response|bool
     */
    public function S_GIFT_VOUCHER_SEARCH_V002(\StructType\S_GIFT_VOUCHER_SEARCH_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GIFT_VOUCHER_SEARCH_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GIFTVOUCHER_SEARCH_V002Response|\StructType\S_GIFT_VOUCHER_SEARCH_V002Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
