<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SEVENTRESERVATIONTRANSFERV ServiceType
 * @subpackage Services
 */
class SEVENTRESERVATIONTRANSFERV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_EVENT_RESERVATION_TRANSFER_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service transfers an event reservation to another begin.### Input- EVENT-RESERVATION-OBJID: of the event reservation requested to transfer.- transferreservations: - 0 -> FO reserations with the same begin as the event
     * were transfered - 1 -> all FO reservations (no further condition check) were transfered - 2 -> no FO reservations were transfered### OutputThe service returns the new dateFrom and dateTo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_EVENT_RESERVATION_TRANSFER_V001Request $body
     * @return \StructType\S_EVENT_RESERVATION_TRANSFER_V001Response|bool
     */
    public function S_EVENT_RESERVATION_TRANSFER_V001(\StructType\S_EVENT_RESERVATION_TRANSFER_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_EVENT_RESERVATION_TRANSFER_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_EVENT_RESERVATION_TRANSFER_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
