<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SDISCOUNTMODIFYV ServiceType
 * @subpackage Services
 */
class SDISCOUNTMODIFYV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_DISCOUNT_MODIFY_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service modifies an existing discount.### Input- DISCOUNT-OBJID: ObjID of the discount to be modified, which can be obtained from other defined services. Mandatory- All discount data to be changed
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_DISCOUNT_MODIFY_V001Request $body
     * @return \StructType\S_DISCOUNT_MODIFY_V001Response|bool
     */
    public function S_DISCOUNT_MODIFY_V001(\StructType\S_DISCOUNT_MODIFY_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_DISCOUNT_MODIFY_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_DISCOUNT_MODIFY_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
