<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SDISCOUNTGETV ServiceType
 * @subpackage Services
 */
class SDISCOUNTGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_DISCOUNT_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns a specific discount.### Input- DISCOUNT-OBJID: ObjID of the discount, which can be obtained from other defined services. Mandatory### OutputDiscount data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_DISCOUNT_GET_V001Request $body
     * @return \StructType\S_DISCOUNT_GET_V001Response|bool
     */
    public function S_DISCOUNT_GET_V001(\StructType\S_DISCOUNT_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_DISCOUNT_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_DISCOUNT_GET_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
