<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SDISCOUNTCREATEV ServiceType
 * @subpackage Services
 */
class SDISCOUNTCREATEV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_DISCOUNT_CREATE_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service creates a new individual discount.### Input- dateFrom: (Mandatory)- dateTo: (Mandatory)- rateFilter: (Mandatory)- Discount data### Output- DISCOUNT-OBJID: ObjID of the created discount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_DISCOUNT_CREATE_V001Request $body
     * @return \StructType\S_DISCOUNT_CREATE_V001Response|bool
     */
    public function S_DISCOUNT_CREATE_V001(\StructType\S_DISCOUNT_CREATE_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_DISCOUNT_CREATE_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_DISCOUNT_CREATE_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
