<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SCRITERIAGETV ServiceType
 * @subpackage Services
 */
class SCRITERIAGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_CRITERIA_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralReturns criteria by area and refObjID.### Input -AREA: Area of the criteria to be searched for. Mandatory -REFOBJID: ObjID of the referenced object (e.g. the ObjID of a guest, hotel, ...). Mandatory ### Output
     * -DESCRIPTION: Description of the criteria -TYPE: Type of the criteria -SUBTYPE: SubType of the criteria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_CRITERIA_GET_V001Request $body
     * @return \StructType\S_CRITERIA_GET_V001Response|bool
     */
    public function S_CRITERIA_GET_V001(\StructType\S_CRITERIA_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_CRITERIA_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_CRITERIA_GET_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
