<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SCITYLEDGERSEARCHV ServiceType
 * @subpackage Services
 */
class SCITYLEDGERSEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_CITY_LEDGER_SEARCH_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service searches for city ledgers based on invoice number and invoice number set.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_CITY_LEDGER_SEARCH_V001Request $body
     * @return \StructType\S_CITY_LEDGER_SEARCH_V001Response|bool
     */
    public function S_CITY_LEDGER_SEARCH_V001(\StructType\S_CITY_LEDGER_SEARCH_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_CITY_LEDGER_SEARCH_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_CITY_LEDGER_SEARCH_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
