<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SCATEGORYMASTERFILESEARCHV ServiceType
 * @subpackage Services
 */
class SCATEGORYMASTERFILESEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_CATEGORY_MASTER_FILE_SEARCH_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service searches for categories and returns its information. ### Input- category: Category code. Optional.### OutputList of categories containing their basic information plus overbooking data, internet availability
     * and descriptions/comments by language.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_CATEGORY_MASTER_FILE_SEARCH_V001Request $body
     * @return \StructType\S_CATEGORY_MASTER_FILE_SEARCH_V001Response|bool
     */
    public function S_CATEGORY_MASTER_FILE_SEARCH_V001(\StructType\S_CATEGORY_MASTER_FILE_SEARCH_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_CATEGORY_MASTER_FILE_SEARCH_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_CATEGORY_MASTER_FILE_SEARCH_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
