<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SARRIVALSEARCHV ServiceType
 * @subpackage Services
 */
class SARRIVALSEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_ARRIVAL_SEARCH_V001
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_ARRIVAL_SEARCH_V002](../S_ARRIVAL_SEARCH_V002) - Fixed incorrect naming (from guestType to personType)### GeneralThis service searches for arrivals of a specific day.###
     * Input- arrival: The date of arrival to search for arrivals on the given day- lastnamefirstname: Lastname, firstname of the traveling guest- orderer: Name of the orderer- marketsegment: The market segment of the reservation- arrived: Flag to search
     * arrived or not arrived reservation. Possible values are: - 0 = not arrived yet - 1 = already arrived- resno: Search for certain reservation number (without reservation sub number)- gdsresnumber: Search for certain GDS number### OutputThe arrivals
     * grouped by room and arriving Persons
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ARRIVAL_SEARCH_V001Request $body
     * @return \StructType\S_ARRIVAL_SEARCH_V001Response|bool
     */
    public function S_ARRIVAL_SEARCH_V001(\StructType\S_ARRIVAL_SEARCH_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ARRIVAL_SEARCH_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_ARRIVAL_SEARCH_V002
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service searches for arrivals of a specific day.### Input- arrival: The date of arrival to search for arrivals on the given day- lastnamefirstname: Lastname, firstname of the traveling guest- orderer: Name of the
     * orderer- marketsegment: The market segment of the reservation- arrived: Flag to search arrived or not arrived reservation. Possible values are: - 0 = not arrived yet - 1 = already arrived- resno: Search for certain reservation number (without
     * reservation sub number)- gdsresnumber: Search for certain GDS number### OutputThe arrivals grouped by room and arriving Persons
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ARRIVAL_SEARCH_V002Request $body
     * @return \StructType\S_ARRIVAL_SEARCH_V002Response|bool
     */
    public function S_ARRIVAL_SEARCH_V002(\StructType\S_ARRIVAL_SEARCH_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ARRIVAL_SEARCH_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ARRIVAL_SEARCH_V001Response|\StructType\S_ARRIVAL_SEARCH_V002Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
