<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SALLOTMENTGETV ServiceType
 * @subpackage Services
 */
class SALLOTMENTGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_ALLOTMENT_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns a specific allotment. The term "Allotment" in SIHOT is used for:- Allotments- Groups Blocks### Input- ALLOTMENT-OBJID: ObjID of the allotment, which can be obtained from other defined services.
     * Mandatory### OutputAllotment data### References- [S_ALLOTMENT_DETAILS_GET_V001](../S_ALLOTMENT_DETAILS_GET_V001) - Obtain the list of allotment details of a specific allotment- [S_ALLOTMENT_PACKAGES_GET_V001](../S_ALLOTMENT_PACKAGES_GET_V001) -
     * Obtain the list of rates of a specific allotment- [S_ALLOTMENT_EXTERNALIDS_GET_V001](../S_ALLOTMENT_EXTERNALIDS_GET_V001) - Obtain the list of external IDs of a specific allotment-
     * [S_ALLOTMENT_RESTRICTIONS_GET_V001](../S_ALLOTMENT_RESTRICTIONS_GET_V001) - Obtain the list of restrictions of a specific allotment- [S_RATE_SEARCH_V001](../S_RATE_SEARCH_V001) - Check rate information for an allotment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ALLOTMENT_GET_V001Request $body
     * @return \StructType\S_ALLOTMENT_GET_V001Response|bool
     */
    public function S_ALLOTMENT_GET_V001(\StructType\S_ALLOTMENT_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ALLOTMENT_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ALLOTMENT_GET_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
