<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SALLOTMENTDETAILSGETV ServiceType
 * @subpackage Services
 */
class SALLOTMENTDETAILSGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_ALLOTMENT_DETAILS_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns the allotment details (contract information) of a specific allotment.### Input- ALLOTMENT-OBJID: ObjID of the allotment, which can be obtained from other defined services. Mandatory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ALLOTMENT_DETAILS_GET_V001Request $body
     * @return \StructType\S_ALLOTMENT_DETAILS_GET_V001Response|bool
     */
    public function S_ALLOTMENT_DETAILS_GET_V001(\StructType\S_ALLOTMENT_DETAILS_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ALLOTMENT_DETAILS_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ALLOTMENT_DETAILS_GET_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
