<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SACTIVITYGETV ServiceType
 * @subpackage Services
 */
class SACTIVITYGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_ACTIVITY_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service shows all data of the requested activity.### Input- ACTIVITY-OBJID: ObjID of the activity### Output- description: description of the trail- status: combo box("ts") key value (can be defined in SIHOT)-
     * beginDate: format: yyyy-mm-DD- beginTime: format: hh:mm- endDate: format: yyyy-mm-DD- endTime: format: hh:mm- user: sihot userID- comment: string comment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ACTIVITY_GET_V001Request $body
     * @return \StructType\S_ACTIVITY_GET_V001Response|bool
     */
    public function S_ACTIVITY_GET_V001(\StructType\S_ACTIVITY_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ACTIVITY_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_ACTIVITY_GET_V002
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service shows all data of the requested activity.### Input- ACTIVITY-OBJID: ObjID of the activity### Output- description: description of the trail- status: combo box("ts") key value (can be defined in SIHOT)-
     * beginDate: format: yyyy-mm-DD- beginTime: format: hh:mm- endDate: format: yyyy-mm-DD- endTime: format: hh:mm- user: sihot userID- comment: string comment- refTreeObjId: objID refTree- type: string type of the trail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ACTIVITY_GET_V002Request $body
     * @return \StructType\S_ACTIVITY_GET_V002Response|bool
     */
    public function S_ACTIVITY_GET_V002(\StructType\S_ACTIVITY_GET_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ACTIVITY_GET_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ACTIVITY_GET_V001Response|\StructType\S_ACTIVITY_GET_V002Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
