<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SACCOUNTV ServiceType
 * @subpackage Services
 */
class SACCOUNTV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_ACCOUNT_V001
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_ACCOUNT_GET_V001](../S_ACCOUNT_GET_V001) - Replaced due to naming convention### GeneralThis service returns a specific account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ACCOUNT_V001Request $body
     * @return \StructType\S_ACCOUNT_V001Response|bool
     */
    public function S_ACCOUNT_V001(\StructType\S_ACCOUNT_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ACCOUNT_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ACCOUNT_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
