<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SACCOUNTPAYMENTADDV ServiceType
 * @subpackage Services
 */
class SACCOUNTPAYMENTADDV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_ACCOUNT_PAYMENT_ADD_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service adds a payment posting to an existing account.### Input- ACCOUNT-OBJID: objID of the folio on which the payment should be posted- accountType: - x for guest - y for orderer- externalIFPartner: allowed external
     * interface partner. Could be defined in "Methods of Payment" dialog- typeofpayment: Type of payment key (e.g. "CA" for cash). Only types which are defined for the external interface partner are allowed!- amount: Amount. "." is used as decimal
     * separator- currency: see combo box configuration for combo box type "49"- DESCRIPTION: description text for the posting### Output- PAYMENT-OBJID: objectID of the posting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ACCOUNT_PAYMENT_ADD_V001Request $body
     * @return \StructType\S_ACCOUNT_PAYMENT_ADD_V001Response|bool
     */
    public function S_ACCOUNT_PAYMENT_ADD_V001(\StructType\S_ACCOUNT_PAYMENT_ADD_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ACCOUNT_PAYMENT_ADD_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_ACCOUNT_PAYMENT_ADD_V002
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service adds a payment posting to an existing account.### Input- ACCOUNT-OBJID: objID of the folio on which the payment should be posted- accountType: - x for guest - y for orderer- externalIFPartner: allowed external
     * interface partner. Could be defined in "Methods of Payment" dialog- typeofpayment: Type of payment key (e.g. "CA" for cash). Only types which are defined for the external interface partner are allowed!- amount: Amount. "." is used as decimal
     * separator- currency: see combo box configuration for combo box type "49"- DESCRIPTION: description text for the posting- isFromZPOS: Identification that this is a ZPOS### Output- PAYMENT-OBJID: objectID of the posting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ACCOUNT_PAYMENT_ADD_V002Request $body
     * @return \StructType\S_ACCOUNT_PAYMENT_ADD_V002Response|bool
     */
    public function S_ACCOUNT_PAYMENT_ADD_V002(\StructType\S_ACCOUNT_PAYMENT_ADD_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ACCOUNT_PAYMENT_ADD_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_ACCOUNT_PAYMENT_ADD_V003
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service adds a payment posting to an existing account.### Input- ACCOUNT-OBJID: objID of the folio on which the payment should be posted- accountType: - x for guest - y for orderer- externalIFPartner: allowed external
     * interface partner. Could be defined in "Methods of Payment" dialog- typeofpayment: Type of payment key (e.g. "CA" for cash). Only types which are defined for the external interface partner are allowed!- amount: Amount. "." is used as decimal
     * separator- currency: see combo box configuration for combo box type "49"- DESCRIPTION: description text for the posting- isFromZPOS: Identification that this is a ZPOS- approvalNumber: External identifier of the payment provider for credit card
     * payment- processingDate: External actual date when the credit card payment has performed### Output- PAYMENT-OBJID: objectID of the posting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ACCOUNT_PAYMENT_ADD_V003Request $body
     * @return \StructType\S_ACCOUNT_PAYMENT_ADD_V003Response|bool
     */
    public function S_ACCOUNT_PAYMENT_ADD_V003(\StructType\S_ACCOUNT_PAYMENT_ADD_V003Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ACCOUNT_PAYMENT_ADD_V003($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ACCOUNT_PAYMENT_ADD_V001Response|\StructType\S_ACCOUNT_PAYMENT_ADD_V002Response|\StructType\S_ACCOUNT_PAYMENT_ADD_V003Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
