<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'MSG-PARAM' => '\\StructType\\MSG_PARAM',
            'MSG-ENTRY' => '\\StructType\\MSG_ENTRY',
            'MSG-ENTRY-PARAM-LIST' => '\\StructType\\MSG_ENTRY_PARAM_LIST',
            'Authentication' => '\\StructType\\Authentication',
            'Result' => '\\StructType\\Result',
            'MSG-LIST' => '\\StructType\\MSG_LIST',
            'AuthenticateRequest' => '\\StructType\\AuthenticateRequest',
            'AuthenticationInfos' => '\\StructType\\AuthenticationInfos',
            'AuthenticateResponse' => '\\StructType\\AuthenticateResponse',
            'GIFT_VOUCHER_REDEEM_V01Request' => '\\StructType\\GIFT_VOUCHER_REDEEM_V01Request',
            'GiftVoucherRedeem' => '\\StructType\\GiftVoucherRedeem',
            'GIFT_VOUCHER_REDEEM_V01Response' => '\\StructType\\GIFT_VOUCHER_REDEEM_V01Response',
            'RedeemedGiftvoucher' => '\\StructType\\RedeemedGiftvoucher',
            'GIFT_VOUCHER_SEARCH_V01Request' => '\\StructType\\GIFT_VOUCHER_SEARCH_V01Request',
            'GiftvoucherSearch' => '\\StructType\\GiftvoucherSearch',
            'GIFT_VOUCHER_SEARCH_V01Response' => '\\StructType\\GIFT_VOUCHER_SEARCH_V01Response',
            'Giftvoucher' => '\\StructType\\Giftvoucher',
            'GiftvoucherHolder' => '\\StructType\\GiftvoucherHolder',
            'GIFT_VOUCHER_SELL_V01Request' => '\\StructType\\GIFT_VOUCHER_SELL_V01Request',
            'GiftVoucherSell' => '\\StructType\\GiftVoucherSell',
            'GIFT_VOUCHER_SELL_V01Response' => '\\StructType\\GIFT_VOUCHER_SELL_V01Response',
            'NewGiftvoucher' => '\\StructType\\NewGiftvoucher',
            'GetCategoryMappingRequest' => '\\StructType\\GetCategoryMappingRequest',
            'CategorySearch' => '\\StructType\\CategorySearch',
            'GetCategoryMappingResponse' => '\\StructType\\GetCategoryMappingResponse',
            'CategorySearchEntry' => '\\StructType\\CategorySearchEntry',
            'Mapping' => '\\StructType\\Mapping',
            'GetPackageMappingRequest' => '\\StructType\\GetPackageMappingRequest',
            'PackageSearch' => '\\StructType\\PackageSearch',
            'GetPackageMappingResponse' => '\\StructType\\GetPackageMappingResponse',
            'PackageSearchEntry' => '\\StructType\\PackageSearchEntry',
            'MappingEntry' => '\\StructType\\MappingEntry',
            'GetServiceMappingRequest' => '\\StructType\\GetServiceMappingRequest',
            'ServiceSearch' => '\\StructType\\ServiceSearch',
            'GetServiceMappingResponse' => '\\StructType\\GetServiceMappingResponse',
            'ServiceSearchEntry' => '\\StructType\\ServiceSearchEntry',
            'S_ACCOUNT_ADD_SERVICE_V001Request' => '\\StructType\\S_ACCOUNT_ADD_SERVICE_V001Request',
            'PMSAccount' => '\\StructType\\PMSAccount',
            'PostFOService' => '\\StructType\\PostFOService',
            'S_ACCOUNT_ADD_SERVICE_V001Response' => '\\StructType\\S_ACCOUNT_ADD_SERVICE_V001Response',
            'S_ACCOUNT_ADD_SERVICE_V002Request' => '\\StructType\\S_ACCOUNT_ADD_SERVICE_V002Request',
            'S_ACCOUNT_ADD_SERVICE_V002Response' => '\\StructType\\S_ACCOUNT_ADD_SERVICE_V002Response',
            'PostFOServiceForOutput' => '\\StructType\\PostFOServiceForOutput',
            'PostedServicesForOutput' => '\\StructType\\PostedServicesForOutput',
            'S_ACCOUNT_ADD_SERVICE_V003Request' => '\\StructType\\S_ACCOUNT_ADD_SERVICE_V003Request',
            'S_ACCOUNT_ADD_SERVICE_V003Response' => '\\StructType\\S_ACCOUNT_ADD_SERVICE_V003Response',
            'S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V001Request' => '\\StructType\\S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V001Request',
            'S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V001Response' => '\\StructType\\S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V001Response',
            'S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Request' => '\\StructType\\S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Request',
            'S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Response' => '\\StructType\\S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Response',
            'S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V003Request' => '\\StructType\\S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V003Request',
            'S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V003Response' => '\\StructType\\S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V003Response',
            'S_ACCOUNT_CANCEL_SERVICE_V001Request' => '\\StructType\\S_ACCOUNT_CANCEL_SERVICE_V001Request',
            'FOServicePosting' => '\\StructType\\FOServicePosting',
            'S_ACCOUNT_CANCEL_SERVICE_V001Response' => '\\StructType\\S_ACCOUNT_CANCEL_SERVICE_V001Response',
            'S_ACCOUNT_GET_V001Request' => '\\StructType\\S_ACCOUNT_GET_V001Request',
            'PMSAccountMain' => '\\StructType\\PMSAccountMain',
            'S_ACCOUNT_GET_V001Response' => '\\StructType\\S_ACCOUNT_GET_V001Response',
            'MainAccount' => '\\StructType\\MainAccount',
            'Postings' => '\\StructType\\Postings',
            'Posting' => '\\StructType\\Posting',
            'InvoicedPostings' => '\\StructType\\InvoicedPostings',
            'InvoicedPosting' => '\\StructType\\InvoicedPosting',
            'Payments' => '\\StructType\\Payments',
            'Payment' => '\\StructType\\Payment',
            'InvoicedPayments' => '\\StructType\\InvoicedPayments',
            'InvoicedPayment' => '\\StructType\\InvoicedPayment',
            'Comments' => '\\StructType\\Comments',
            'S_ACCOUNT_GET_V002Request' => '\\StructType\\S_ACCOUNT_GET_V002Request',
            'S_ACCOUNT_GET_V002Response' => '\\StructType\\S_ACCOUNT_GET_V002Response',
            'S_ACCOUNT_INACTIVATE_V001Request' => '\\StructType\\S_ACCOUNT_INACTIVATE_V001Request',
            'ACCOUNT' => '\\StructType\\ACCOUNT',
            'S_ACCOUNT_INACTIVATE_V001Response' => '\\StructType\\S_ACCOUNT_INACTIVATE_V001Response',
            'S_ACCOUNT_PAYMENT_ADD_V001Request' => '\\StructType\\S_ACCOUNT_PAYMENT_ADD_V001Request',
            'PostFOPayment' => '\\StructType\\PostFOPayment',
            'S_ACCOUNT_PAYMENT_ADD_V001Response' => '\\StructType\\S_ACCOUNT_PAYMENT_ADD_V001Response',
            'Answer' => '\\StructType\\Answer',
            'S_ACCOUNT_PAYMENT_ADD_V002Request' => '\\StructType\\S_ACCOUNT_PAYMENT_ADD_V002Request',
            'S_ACCOUNT_PAYMENT_ADD_V002Response' => '\\StructType\\S_ACCOUNT_PAYMENT_ADD_V002Response',
            'S_ACCOUNT_PAYMENT_ADD_V003Request' => '\\StructType\\S_ACCOUNT_PAYMENT_ADD_V003Request',
            'S_ACCOUNT_PAYMENT_ADD_V003Response' => '\\StructType\\S_ACCOUNT_PAYMENT_ADD_V003Response',
            'S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Request' => '\\StructType\\S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Request',
            'S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Response' => '\\StructType\\S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Response',
            'PAYMENT-INSTRUCTIONS' => '\\StructType\\PAYMENT_INSTRUCTIONS',
            'GUEST-ACCOUNT' => '\\StructType\\GUEST_ACCOUNT',
            'INVOICE-HOLDER' => '\\StructType\\INVOICE_HOLDER',
            'DELIVERY-ADDRESS' => '\\StructType\\DELIVERY_ADDRESS',
            'CLIENT-ACCOUNT' => '\\StructType\\CLIENT_ACCOUNT',
            'GROUP-ACCOUNT' => '\\StructType\\GROUP_ACCOUNT',
            'S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request' => '\\StructType\\S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request',
            'S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Response' => '\\StructType\\S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Response',
            'S_ACCOUNT_POST_PACKAGE_IN_ADVANCE_V001Request' => '\\StructType\\S_ACCOUNT_POST_PACKAGE_IN_ADVANCE_V001Request',
            'S_ACCOUNT_POST_PACKAGE_IN_ADVANCE_V001Response' => '\\StructType\\S_ACCOUNT_POST_PACKAGE_IN_ADVANCE_V001Response',
            'S_ACCOUNT_SEARCH_V001Request' => '\\StructType\\S_ACCOUNT_SEARCH_V001Request',
            'AccountSearch' => '\\StructType\\AccountSearch',
            'S_ACCOUNT_SEARCH_V001Response' => '\\StructType\\S_ACCOUNT_SEARCH_V001Response',
            'Account' => '\\StructType\\Account_1',
            'Owner' => '\\StructType\\Owner',
            'Room' => '\\StructType\\Room',
            'S_ACCOUNT_SEARCH_V002Request' => '\\StructType\\S_ACCOUNT_SEARCH_V002Request',
            'S_ACCOUNT_SEARCH_V002Response' => '\\StructType\\S_ACCOUNT_SEARCH_V002Response',
            'S_ACCOUNT_SEARCH_V003Request' => '\\StructType\\S_ACCOUNT_SEARCH_V003Request',
            'S_ACCOUNT_SEARCH_V003Response' => '\\StructType\\S_ACCOUNT_SEARCH_V003Response',
            'S_ACCOUNT_SERVICE_ADD_V001Request' => '\\StructType\\S_ACCOUNT_SERVICE_ADD_V001Request',
            'S_ACCOUNT_SERVICE_ADD_V001Response' => '\\StructType\\S_ACCOUNT_SERVICE_ADD_V001Response',
            'S_ACCOUNT_SERVICE_ADD_V002Request' => '\\StructType\\S_ACCOUNT_SERVICE_ADD_V002Request',
            'S_ACCOUNT_SERVICE_ADD_V002Response' => '\\StructType\\S_ACCOUNT_SERVICE_ADD_V002Response',
            'S_ACCOUNT_SERVICE_ADD_V003Request' => '\\StructType\\S_ACCOUNT_SERVICE_ADD_V003Request',
            'S_ACCOUNT_SERVICE_ADD_V003Response' => '\\StructType\\S_ACCOUNT_SERVICE_ADD_V003Response',
            'S_ACCOUNT_SERVICE_CANCEL_V001Request' => '\\StructType\\S_ACCOUNT_SERVICE_CANCEL_V001Request',
            'S_ACCOUNT_SERVICE_CANCEL_V001Response' => '\\StructType\\S_ACCOUNT_SERVICE_CANCEL_V001Response',
            'S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V001Request' => '\\StructType\\S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V001Request',
            'S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V001Response' => '\\StructType\\S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V001Response',
            'S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V002Request' => '\\StructType\\S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V002Request',
            'S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V002Response' => '\\StructType\\S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V002Response',
            'S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V003Request' => '\\StructType\\S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V003Request',
            'S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V003Response' => '\\StructType\\S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V003Response',
            'S_ACCOUNT_SETTLE_V001Request' => '\\StructType\\S_ACCOUNT_SETTLE_V001Request',
            'S_ACCOUNT_SETTLE_V001Response' => '\\StructType\\S_ACCOUNT_SETTLE_V001Response',
            'INVOICE' => '\\StructType\\INVOICE',
            'S_ACCOUNT_V001Request' => '\\StructType\\S_ACCOUNT_V001Request',
            'S_ACCOUNT_V001Response' => '\\StructType\\S_ACCOUNT_V001Response',
            'S_ACL_INFO_GET_V001Request' => '\\StructType\\S_ACL_INFO_GET_V001Request',
            'SearchCriteria' => '\\StructType\\SearchCriteria',
            'S_ACL_INFO_GET_V001Response' => '\\StructType\\S_ACL_INFO_GET_V001Response',
            'ACLInfo' => '\\StructType\\ACLInfo',
            'S_ACTIVITY_ADD_V001Request' => '\\StructType\\S_ACTIVITY_ADD_V001Request',
            'TrailAdd' => '\\StructType\\TrailAdd',
            'Activity' => '\\StructType\\Activity',
            'ExternalID_Act' => '\\StructType\\ExternalID_Act',
            'S_ACTIVITY_ADD_V001Response' => '\\StructType\\S_ACTIVITY_ADD_V001Response',
            'S_ACTIVITY_GET_V001Request' => '\\StructType\\S_ACTIVITY_GET_V001Request',
            'S_ACTIVITY_GET_V001Response' => '\\StructType\\S_ACTIVITY_GET_V001Response',
            'FollowUps' => '\\StructType\\FollowUps',
            'FollowUp' => '\\StructType\\FollowUp',
            'ExternalFile' => '\\StructType\\ExternalFile',
            'ExternalFileData' => '\\StructType\\ExternalFileData',
            'S_ACTIVITY_GET_V002Request' => '\\StructType\\S_ACTIVITY_GET_V002Request',
            'S_ACTIVITY_GET_V002Response' => '\\StructType\\S_ACTIVITY_GET_V002Response',
            'S_ACTIVITY_MODIFY_STATUS_V001Request' => '\\StructType\\S_ACTIVITY_MODIFY_STATUS_V001Request',
            'S_ACTIVITY_MODIFY_STATUS_V001Response' => '\\StructType\\S_ACTIVITY_MODIFY_STATUS_V001Response',
            'S_ACTIVITY_MODIFY_V001Request' => '\\StructType\\S_ACTIVITY_MODIFY_V001Request',
            'S_ACTIVITY_MODIFY_V001Response' => '\\StructType\\S_ACTIVITY_MODIFY_V001Response',
            'S_ACTIVITY_REMOVE_V001Request' => '\\StructType\\S_ACTIVITY_REMOVE_V001Request',
            'RemoveActivity' => '\\StructType\\RemoveActivity',
            'S_ACTIVITY_REMOVE_V001Response' => '\\StructType\\S_ACTIVITY_REMOVE_V001Response',
            'S_ACTIVITY_SEARCH_V001Request' => '\\StructType\\S_ACTIVITY_SEARCH_V001Request',
            'ActivitySearch' => '\\StructType\\ActivitySearch',
            'S_ACTIVITY_SEARCH_V001Response' => '\\StructType\\S_ACTIVITY_SEARCH_V001Response',
            'S_ACTIVITY_SEARCH_V002Request' => '\\StructType\\S_ACTIVITY_SEARCH_V002Request',
            'S_ACTIVITY_SEARCH_V002Response' => '\\StructType\\S_ACTIVITY_SEARCH_V002Response',
            'S_ACTIVITY_STATUS_MODIFY_V001Request' => '\\StructType\\S_ACTIVITY_STATUS_MODIFY_V001Request',
            'S_ACTIVITY_STATUS_MODIFY_V001Response' => '\\StructType\\S_ACTIVITY_STATUS_MODIFY_V001Response',
            'S_ACTIVIY_GET_V001Request' => '\\StructType\\S_ACTIVIY_GET_V001Request',
            'S_ACTIVIY_GET_V001Response' => '\\StructType\\S_ACTIVIY_GET_V001Response',
            'S_ACTIVIY_GET_V002Request' => '\\StructType\\S_ACTIVIY_GET_V002Request',
            'S_ACTIVIY_GET_V002Response' => '\\StructType\\S_ACTIVIY_GET_V002Response',
            'S_ACTIVIY_MODIFY_STATUS_V001Request' => '\\StructType\\S_ACTIVIY_MODIFY_STATUS_V001Request',
            'S_ACTIVIY_MODIFY_STATUS_V001Response' => '\\StructType\\S_ACTIVIY_MODIFY_STATUS_V001Response',
            'S_ACTIVIY_MODIFY_V001Request' => '\\StructType\\S_ACTIVIY_MODIFY_V001Request',
            'S_ACTIVIY_MODIFY_V001Response' => '\\StructType\\S_ACTIVIY_MODIFY_V001Response',
            'S_ADD_SETTLEMENT_PROFILE_V001Request' => '\\StructType\\S_ADD_SETTLEMENT_PROFILE_V001Request',
            'Guest' => '\\StructType\\Guest_1',
            'SettlementProfile' => '\\StructType\\SettlementProfile',
            'S_ADD_SETTLEMENT_PROFILE_V001Response' => '\\StructType\\S_ADD_SETTLEMENT_PROFILE_V001Response',
            'S_ALLOTMENT_CONTRACTFORECAST_GET_V001Request' => '\\StructType\\S_ALLOTMENT_CONTRACTFORECAST_GET_V001Request',
            'ALLOTMENT' => '\\StructType\\ALLOTMENT',
            'S_ALLOTMENT_CONTRACTFORECAST_GET_V001Response' => '\\StructType\\S_ALLOTMENT_CONTRACTFORECAST_GET_V001Response',
            'ALLOTMENTFORECAST' => '\\StructType\\ALLOTMENTFORECAST',
            'ALLOTMENTFORECASTENTRY' => '\\StructType\\ALLOTMENTFORECASTENTRY',
            'S_ALLOTMENT_DETAILS_GET_V001Request' => '\\StructType\\S_ALLOTMENT_DETAILS_GET_V001Request',
            'S_ALLOTMENT_DETAILS_GET_V001Response' => '\\StructType\\S_ALLOTMENT_DETAILS_GET_V001Response',
            'ALLOTMENTDETAILS' => '\\StructType\\ALLOTMENTDETAILS',
            'ALLOTMENTDETAIL' => '\\StructType\\ALLOTMENTDETAIL',
            'S_ALLOTMENT_EXTERNALIDS_GET_V001Request' => '\\StructType\\S_ALLOTMENT_EXTERNALIDS_GET_V001Request',
            'S_ALLOTMENT_EXTERNALIDS_GET_V001Response' => '\\StructType\\S_ALLOTMENT_EXTERNALIDS_GET_V001Response',
            'ALLOTMENTEXTERNALIDS' => '\\StructType\\ALLOTMENTEXTERNALIDS',
            'ALLOTMENTEXTERNALID' => '\\StructType\\ALLOTMENTEXTERNALID',
            'S_ALLOTMENT_FORECAST_GET_V001Request' => '\\StructType\\S_ALLOTMENT_FORECAST_GET_V001Request',
            'S_ALLOTMENT_FORECAST_GET_V001Response' => '\\StructType\\S_ALLOTMENT_FORECAST_GET_V001Response',
            'S_ALLOTMENT_GET_V001Request' => '\\StructType\\S_ALLOTMENT_GET_V001Request',
            'S_ALLOTMENT_GET_V001Response' => '\\StructType\\S_ALLOTMENT_GET_V001Response',
            'HOLDER' => '\\StructType\\HOLDER',
            'TRAVELAGENCY' => '\\StructType\\TRAVELAGENCY',
            'TRAVELPOINT' => '\\StructType\\TRAVELPOINT',
            'S_ALLOTMENT_PACKAGES_GET_V001Request' => '\\StructType\\S_ALLOTMENT_PACKAGES_GET_V001Request',
            'S_ALLOTMENT_PACKAGES_GET_V001Response' => '\\StructType\\S_ALLOTMENT_PACKAGES_GET_V001Response',
            'ALLOTMENTPACKAGES' => '\\StructType\\ALLOTMENTPACKAGES',
            'ALLOTMENTPACKAGE' => '\\StructType\\ALLOTMENTPACKAGE',
            'S_ALLOTMENT_RESTRICTIONS_GET_V001Request' => '\\StructType\\S_ALLOTMENT_RESTRICTIONS_GET_V001Request',
            'S_ALLOTMENT_RESTRICTIONS_GET_V001Response' => '\\StructType\\S_ALLOTMENT_RESTRICTIONS_GET_V001Response',
            'ALLOTMENTRESTRICTIONS' => '\\StructType\\ALLOTMENTRESTRICTIONS',
            'ALLOTMENTRESTRICTION' => '\\StructType\\ALLOTMENTRESTRICTION',
            'NOARRIVALS' => '\\StructType\\NOARRIVALS',
            'NODEPARTURES' => '\\StructType\\NODEPARTURES',
            'S_ALLOTMENT_RESTRICTIONS_GET_V002Request' => '\\StructType\\S_ALLOTMENT_RESTRICTIONS_GET_V002Request',
            'S_ALLOTMENT_RESTRICTIONS_GET_V002Response' => '\\StructType\\S_ALLOTMENT_RESTRICTIONS_GET_V002Response',
            'S_ALLOTMENT_RESTRICTION_SEARCH_V001Request' => '\\StructType\\S_ALLOTMENT_RESTRICTION_SEARCH_V001Request',
            'ALLOTMENTRESTRICTION-SEARCH' => '\\StructType\\ALLOTMENTRESTRICTION_SEARCH',
            'S_ALLOTMENT_RESTRICTION_SEARCH_V001Response' => '\\StructType\\S_ALLOTMENT_RESTRICTION_SEARCH_V001Response',
            'S_ALLOTMENT_RESTRICTION_SEARCH_V002Request' => '\\StructType\\S_ALLOTMENT_RESTRICTION_SEARCH_V002Request',
            'S_ALLOTMENT_RESTRICTION_SEARCH_V002Response' => '\\StructType\\S_ALLOTMENT_RESTRICTION_SEARCH_V002Response',
            'S_ALLOTMENT_SEARCH_V001Request' => '\\StructType\\S_ALLOTMENT_SEARCH_V001Request',
            'ALLOTMENTSEARCH' => '\\StructType\\ALLOTMENTSEARCH',
            'S_ALLOTMENT_SEARCH_V001Response' => '\\StructType\\S_ALLOTMENT_SEARCH_V001Response',
            'ALLOTMENTS' => '\\StructType\\ALLOTMENTS',
            'S_ARRIVAL_SEARCH_V001Request' => '\\StructType\\S_ARRIVAL_SEARCH_V001Request',
            'ArrivalSearch' => '\\StructType\\ArrivalSearch',
            'S_ARRIVAL_SEARCH_V001Response' => '\\StructType\\S_ARRIVAL_SEARCH_V001Response',
            'room' => '\\StructType\\Room_1',
            'person' => '\\StructType\\Person_1',
            'S_ARRIVAL_SEARCH_V002Request' => '\\StructType\\S_ARRIVAL_SEARCH_V002Request',
            'S_ARRIVAL_SEARCH_V002Response' => '\\StructType\\S_ARRIVAL_SEARCH_V002Response',
            'S_AUTHENTICATE_HOTEL_V001Request' => '\\StructType\\S_AUTHENTICATE_HOTEL_V001Request',
            'AUTHENTICATE-HOTEL' => '\\StructType\\AUTHENTICATE_HOTEL',
            'S_AUTHENTICATE_HOTEL_V001Response' => '\\StructType\\S_AUTHENTICATE_HOTEL_V001Response',
            'AUTHENTICATION' => '\\StructType\\AUTHENTICATION_1',
            'S_AUTHENTICATE_V001Request' => '\\StructType\\S_AUTHENTICATE_V001Request',
            'S_AUTHENTICATE_V001Response' => '\\StructType\\S_AUTHENTICATE_V001Response',
            'S_AUTHENTICATE_V002Request' => '\\StructType\\S_AUTHENTICATE_V002Request',
            'S_AUTHENTICATE_V002Response' => '\\StructType\\S_AUTHENTICATE_V002Response',
            'S_AUTHORISATION_COMMIT_V001Request' => '\\StructType\\S_AUTHORISATION_COMMIT_V001Request',
            'AuthCommit' => '\\StructType\\AuthCommit',
            'S_AUTHORISATION_COMMIT_V001Response' => '\\StructType\\S_AUTHORISATION_COMMIT_V001Response',
            'S_AUTOTASK_CONFIRMATION_V001Request' => '\\StructType\\S_AUTOTASK_CONFIRMATION_V001Request',
            'AutoTaskConfirm' => '\\StructType\\AutoTaskConfirm',
            'S_AUTOTASK_CONFIRMATION_V001Response' => '\\StructType\\S_AUTOTASK_CONFIRMATION_V001Response',
            'S_AUTOTASK_ERROR_SET_V001Request' => '\\StructType\\S_AUTOTASK_ERROR_SET_V001Request',
            'AutoTaskSetError' => '\\StructType\\AutoTaskSetError',
            'S_AUTOTASK_ERROR_SET_V001Response' => '\\StructType\\S_AUTOTASK_ERROR_SET_V001Response',
            'S_AUTOTASK_SETERROR_V001Request' => '\\StructType\\S_AUTOTASK_SETERROR_V001Request',
            'S_AUTOTASK_SETERROR_V001Response' => '\\StructType\\S_AUTOTASK_SETERROR_V001Response',
            'S_BED_CATEGORY_MASTER_FILE_COMMENT_GET_V001Request' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_COMMENT_GET_V001Request',
            'CATEGORY' => '\\StructType\\CATEGORY',
            'S_BED_CATEGORY_MASTER_FILE_COMMENT_GET_V001Response' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_COMMENT_GET_V001Response',
            'LANGUAGE-COMMENTS' => '\\StructType\\LANGUAGE_COMMENTS',
            'LANGUAGE-COMMENT' => '\\StructType\\LANGUAGE_COMMENT',
            'S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Request' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Request',
            'S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Response' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Response',
            'S_BED_CATEGORY_MASTER_FILE_GET_V001Request' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_GET_V001Request',
            'S_BED_CATEGORY_MASTER_FILE_GET_V001Response' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_GET_V001Response',
            'S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001Request' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001Request',
            'S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001Response' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001Response',
            'INTERNET-AVAILABILITY' => '\\StructType\\INTERNET_AVAILABILITY',
            'INTERNET' => '\\StructType\\INTERNET',
            'S_BED_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Request' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Request',
            'S_BED_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Response' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Response',
            'S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Request' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Request',
            'S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Response' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Response',
            'OVERBOOKING-DATA' => '\\StructType\\OVERBOOKING_DATA',
            'OVERBOOKING' => '\\StructType\\OVERBOOKING',
            'S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Request' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Request',
            'S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Response' => '\\StructType\\S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Response',
            'S_BENCHMARK_V001Request' => '\\StructType\\S_BENCHMARK_V001Request',
            'S_BENCHMARK_V001Response' => '\\StructType\\S_BENCHMARK_V001Response',
            'ProfileInfo' => '\\StructType\\ProfileInfo',
            'S_CATEGORY_MAPPING_GET_V001Request' => '\\StructType\\S_CATEGORY_MAPPING_GET_V001Request',
            'S_CATEGORY_MAPPING_GET_V001Response' => '\\StructType\\S_CATEGORY_MAPPING_GET_V001Response',
            'S_CATEGORY_MASTER_FILE_SEARCH_V001Request' => '\\StructType\\S_CATEGORY_MASTER_FILE_SEARCH_V001Request',
            'CATEGORY-SEARCH' => '\\StructType\\CATEGORY_SEARCH',
            'S_CATEGORY_MASTER_FILE_SEARCH_V001Response' => '\\StructType\\S_CATEGORY_MASTER_FILE_SEARCH_V001Response',
            'CATEGORIES' => '\\StructType\\CATEGORIES',
            'S_CATEGORY_RESTRICTION_SEARCH_V001Request' => '\\StructType\\S_CATEGORY_RESTRICTION_SEARCH_V001Request',
            'CATEGORYRESTRICTION-SEARCH' => '\\StructType\\CATEGORYRESTRICTION_SEARCH',
            'S_CATEGORY_RESTRICTION_SEARCH_V001Response' => '\\StructType\\S_CATEGORY_RESTRICTION_SEARCH_V001Response',
            'CATEGORYRESTRICTIONS' => '\\StructType\\CATEGORYRESTRICTIONS',
            'CATEGORYRESTRICTION' => '\\StructType\\CATEGORYRESTRICTION',
            'S_CATEGORY_RESTRICTION_SEARCH_V002Request' => '\\StructType\\S_CATEGORY_RESTRICTION_SEARCH_V002Request',
            'S_CATEGORY_RESTRICTION_SEARCH_V002Response' => '\\StructType\\S_CATEGORY_RESTRICTION_SEARCH_V002Response',
            'S_CITY_LEDGER_ACCOUNT_GET_V001Request' => '\\StructType\\S_CITY_LEDGER_ACCOUNT_GET_V001Request',
            'CITYLEDGER-ACCOUNT' => '\\StructType\\CITYLEDGER_ACCOUNT',
            'S_CITY_LEDGER_ACCOUNT_GET_V001Response' => '\\StructType\\S_CITY_LEDGER_ACCOUNT_GET_V001Response',
            'GUEST' => '\\StructType\\GUEST',
            'CITYLEDGERS' => '\\StructType\\CITYLEDGERS',
            'CITYLEDGER' => '\\StructType\\CITYLEDGER',
            'RESERVATION' => '\\StructType\\RESERVATION',
            'S_CITY_LEDGER_ACCOUNT_SEARCH_V001Request' => '\\StructType\\S_CITY_LEDGER_ACCOUNT_SEARCH_V001Request',
            'CITYLEDGER-ACCOUNT-SEARCH' => '\\StructType\\CITYLEDGER_ACCOUNT_SEARCH',
            'S_CITY_LEDGER_ACCOUNT_SEARCH_V001Response' => '\\StructType\\S_CITY_LEDGER_ACCOUNT_SEARCH_V001Response',
            'CITYLEDGER-ACCOUNTS' => '\\StructType\\CITYLEDGER_ACCOUNTS',
            'S_CITY_LEDGER_PAYMENT_APPLY_V001Request' => '\\StructType\\S_CITY_LEDGER_PAYMENT_APPLY_V001Request',
            'CITYLEDGER-APPLY' => '\\StructType\\CITYLEDGER_APPLY',
            'PAYMENT' => '\\StructType\\PAYMENT_1',
            'S_CITY_LEDGER_PAYMENT_APPLY_V001Response' => '\\StructType\\S_CITY_LEDGER_PAYMENT_APPLY_V001Response',
            'S_CITY_LEDGER_SEARCH_V001Request' => '\\StructType\\S_CITY_LEDGER_SEARCH_V001Request',
            'CITYLEDGER-SEARCH' => '\\StructType\\CITYLEDGER_SEARCH',
            'S_CITY_LEDGER_SEARCH_V001Response' => '\\StructType\\S_CITY_LEDGER_SEARCH_V001Response',
            'S_COMBOBOX_SEARCH_V001Request' => '\\StructType\\S_COMBOBOX_SEARCH_V001Request',
            'Search' => '\\StructType\\Search',
            'S_COMBOBOX_SEARCH_V001Response' => '\\StructType\\S_COMBOBOX_SEARCH_V001Response',
            'ComboBox' => '\\StructType\\ComboBox',
            'Entries' => '\\StructType\\Entries',
            'Entry' => '\\StructType\\Entry',
            'S_COMBOBOX_SEARCH_V002Request' => '\\StructType\\S_COMBOBOX_SEARCH_V002Request',
            'S_COMBOBOX_SEARCH_V002Response' => '\\StructType\\S_COMBOBOX_SEARCH_V002Response',
            'S_COMBOBOX_SEARCH_V01Request' => '\\StructType\\S_COMBOBOX_SEARCH_V01Request',
            'S_COMBOBOX_SEARCH_V01Response' => '\\StructType\\S_COMBOBOX_SEARCH_V01Response',
            'S_COMBOBOX_SEARCH_V02Request' => '\\StructType\\S_COMBOBOX_SEARCH_V02Request',
            'S_COMBOBOX_SEARCH_V02Response' => '\\StructType\\S_COMBOBOX_SEARCH_V02Response',
            'S_CRITERIA_GET_V001Request' => '\\StructType\\S_CRITERIA_GET_V001Request',
            'S_CRITERIA_GET_V001Response' => '\\StructType\\S_CRITERIA_GET_V001Response',
            'TrailCriteria' => '\\StructType\\TrailCriteria',
            'S_DISCOUNT_CREATE_V001Request' => '\\StructType\\S_DISCOUNT_CREATE_V001Request',
            'DISCOUNT' => '\\StructType\\DISCOUNT',
            'S_DISCOUNT_CREATE_V001Response' => '\\StructType\\S_DISCOUNT_CREATE_V001Response',
            'S_DISCOUNT_GET_V001Request' => '\\StructType\\S_DISCOUNT_GET_V001Request',
            'S_DISCOUNT_GET_V001Response' => '\\StructType\\S_DISCOUNT_GET_V001Response',
            'S_DISCOUNT_MODIFY_V001Request' => '\\StructType\\S_DISCOUNT_MODIFY_V001Request',
            'S_DISCOUNT_MODIFY_V001Response' => '\\StructType\\S_DISCOUNT_MODIFY_V001Response',
            'S_DISCOUNT_SEARCH_V001Request' => '\\StructType\\S_DISCOUNT_SEARCH_V001Request',
            'DISCOUNT-SEARCH' => '\\StructType\\DISCOUNT_SEARCH',
            'S_DISCOUNT_SEARCH_V001Response' => '\\StructType\\S_DISCOUNT_SEARCH_V001Response',
            'DISCOUNTS' => '\\StructType\\DISCOUNTS',
            'S_EVENT_CB_MODULE_DESCRIPTION_COMMENT_GET_V001Request' => '\\StructType\\S_EVENT_CB_MODULE_DESCRIPTION_COMMENT_GET_V001Request',
            'CBModuleMasterFileSearch' => '\\StructType\\CBModuleMasterFileSearch',
            'S_EVENT_CB_MODULE_DESCRIPTION_COMMENT_GET_V001Response' => '\\StructType\\S_EVENT_CB_MODULE_DESCRIPTION_COMMENT_GET_V001Response',
            'CBModuleMasterFiles' => '\\StructType\\CBModuleMasterFiles',
            'CBModuleMasterFile' => '\\StructType\\CBModuleMasterFile',
            'MultiLangDescriptions' => '\\StructType\\MultiLangDescriptions',
            'MultiLangDescription' => '\\StructType\\MultiLangDescription',
            'MultiLangComments' => '\\StructType\\MultiLangComments',
            'MultiLangComment' => '\\StructType\\MultiLangComment',
            'S_EVENT_CB_MODULE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request' => '\\StructType\\S_EVENT_CB_MODULE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request',
            'S_EVENT_CB_MODULE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response' => '\\StructType\\S_EVENT_CB_MODULE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response',
            'S_EVENT_EQUIPMENT_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request' => '\\StructType\\S_EVENT_EQUIPMENT_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request',
            'EventEquipmentMasterFileSearch' => '\\StructType\\EventEquipmentMasterFileSearch',
            'S_EVENT_EQUIPMENT_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response' => '\\StructType\\S_EVENT_EQUIPMENT_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response',
            'EventEquipmentMasterFiles' => '\\StructType\\EventEquipmentMasterFiles',
            'EventEquipmentMasterFile' => '\\StructType\\EventEquipmentMasterFile',
            'S_EVENT_RESERVATION_CREATE_V001Request' => '\\StructType\\S_EVENT_RESERVATION_CREATE_V001Request',
            'EVENT-RESERVATION' => '\\StructType\\EVENT_RESERVATION',
            'ORDERER' => '\\StructType\\ORDERER',
            'ORDERER-CONTACT' => '\\StructType\\ORDERER_CONTACT',
            'EXTERNALID' => '\\StructType\\EXTERNALID',
            'S_EVENT_RESERVATION_CREATE_V001Response' => '\\StructType\\S_EVENT_RESERVATION_CREATE_V001Response',
            'EventRes' => '\\StructType\\EventRes',
            'S_EVENT_RESERVATION_GET_V001Request' => '\\StructType\\S_EVENT_RESERVATION_GET_V001Request',
            'S_EVENT_RESERVATION_GET_V001Response' => '\\StructType\\S_EVENT_RESERVATION_GET_V001Response',
            'EXTERNALIDS' => '\\StructType\\EXTERNALIDS',
            'RESERVATIONS' => '\\StructType\\RESERVATIONS',
            'EVENT-ROOMS' => '\\StructType\\EVENT_ROOMS',
            'EVENT-ROOM' => '\\StructType\\EVENT_ROOM',
            'S_EVENT_RESERVATION_MODIFY_V001Request' => '\\StructType\\S_EVENT_RESERVATION_MODIFY_V001Request',
            'S_EVENT_RESERVATION_MODIFY_V001Response' => '\\StructType\\S_EVENT_RESERVATION_MODIFY_V001Response',
            'S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Request' => '\\StructType\\S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Request',
            'EventReservation' => '\\StructType\\EventReservation',
            'S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Response' => '\\StructType\\S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Response',
            'ServiceReservations' => '\\StructType\\ServiceReservations',
            'ServiceReservation' => '\\StructType\\ServiceReservation',
            'PackageReservations' => '\\StructType\\PackageReservations',
            'PackageReservation' => '\\StructType\\PackageReservation',
            'RoomReservations' => '\\StructType\\RoomReservations',
            'RoomReservation' => '\\StructType\\RoomReservation',
            'EquipmentReservation' => '\\StructType\\EquipmentReservation',
            'ModuleReservations' => '\\StructType\\ModuleReservations',
            'ModuleReservation' => '\\StructType\\ModuleReservation',
            'S_EVENT_RESERVATION_ROOM_GET_V001Request' => '\\StructType\\S_EVENT_RESERVATION_ROOM_GET_V001Request',
            'S_EVENT_RESERVATION_ROOM_GET_V001Response' => '\\StructType\\S_EVENT_RESERVATION_ROOM_GET_V001Response',
            'S_EVENT_RESERVATION_SEARCH_V001Request' => '\\StructType\\S_EVENT_RESERVATION_SEARCH_V001Request',
            'EVENT-RESERVATION-SEARCH' => '\\StructType\\EVENT_RESERVATION_SEARCH',
            'S_EVENT_RESERVATION_SEARCH_V001Response' => '\\StructType\\S_EVENT_RESERVATION_SEARCH_V001Response',
            'EVENT-RESERVATIONS' => '\\StructType\\EVENT_RESERVATIONS',
            'S_EVENT_RESERVATION_SERVICE_ADD_V001Request' => '\\StructType\\S_EVENT_RESERVATION_SERVICE_ADD_V001Request',
            'Service' => '\\StructType\\Service',
            'S_EVENT_RESERVATION_SERVICE_ADD_V001Response' => '\\StructType\\S_EVENT_RESERVATION_SERVICE_ADD_V001Response',
            'EventServiceRes' => '\\StructType\\EventServiceRes',
            'RoomRes' => '\\StructType\\RoomRes',
            'RoomServiceRes' => '\\StructType\\RoomServiceRes',
            'ModuleRes' => '\\StructType\\ModuleRes',
            'ModuleServiceRes' => '\\StructType\\ModuleServiceRes',
            'ModuleRoomRes' => '\\StructType\\ModuleRoomRes',
            'ModuleRoomServiceRes' => '\\StructType\\ModuleRoomServiceRes',
            'S_EVENT_RESERVATION_SERVICE_MODIFY_V001Request' => '\\StructType\\S_EVENT_RESERVATION_SERVICE_MODIFY_V001Request',
            'S_EVENT_RESERVATION_SERVICE_MODIFY_V001Response' => '\\StructType\\S_EVENT_RESERVATION_SERVICE_MODIFY_V001Response',
            'S_EVENT_RESERVATION_SERVICE_REMOVE_V001Request' => '\\StructType\\S_EVENT_RESERVATION_SERVICE_REMOVE_V001Request',
            'S_EVENT_RESERVATION_SERVICE_REMOVE_V001Response' => '\\StructType\\S_EVENT_RESERVATION_SERVICE_REMOVE_V001Response',
            'S_EVENT_RESERVATION_TOKEN_ADD_V001Request' => '\\StructType\\S_EVENT_RESERVATION_TOKEN_ADD_V001Request',
            'CARD' => '\\StructType\\CARD',
            'S_EVENT_RESERVATION_TOKEN_ADD_V001Response' => '\\StructType\\S_EVENT_RESERVATION_TOKEN_ADD_V001Response',
            'S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request' => '\\StructType\\S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request',
            'S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Response' => '\\StructType\\S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Response',
            'Trails' => '\\StructType\\Trails',
            'Trail' => '\\StructType\\Trail',
            'TrailNode1' => '\\StructType\\TrailNode1',
            'TrailData' => '\\StructType\\TrailData',
            'SubTrails' => '\\StructType\\SubTrails',
            'SubTrail' => '\\StructType\\SubTrail',
            'SubTrailData' => '\\StructType\\SubTrailData',
            'S_EVENT_RESERVATION_TRANSFER_V001Request' => '\\StructType\\S_EVENT_RESERVATION_TRANSFER_V001Request',
            'S_EVENT_RESERVATION_TRANSFER_V001Response' => '\\StructType\\S_EVENT_RESERVATION_TRANSFER_V001Response',
            'S_EVENT_ROOM_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request' => '\\StructType\\S_EVENT_ROOM_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request',
            'EventRoomMasterFileSearch' => '\\StructType\\EventRoomMasterFileSearch',
            'S_EVENT_ROOM_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response' => '\\StructType\\S_EVENT_ROOM_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response',
            'EventRoomMasterFiles' => '\\StructType\\EventRoomMasterFiles',
            'EventRoomMasterFile' => '\\StructType\\EventRoomMasterFile',
            'S_FREE_ROOM_SEARCH_V001Request' => '\\StructType\\S_FREE_ROOM_SEARCH_V001Request',
            'FreeRoomSearch' => '\\StructType\\FreeRoomSearch',
            'S_FREE_ROOM_SEARCH_V001Response' => '\\StructType\\S_FREE_ROOM_SEARCH_V001Response',
            'S_GET_GUEST_HIERARCHY_V001Request' => '\\StructType\\S_GET_GUEST_HIERARCHY_V001Request',
            'S_GET_GUEST_HIERARCHY_V001Response' => '\\StructType\\S_GET_GUEST_HIERARCHY_V001Response',
            'GuestHierarchyLevel0' => '\\StructType\\GuestHierarchyLevel0',
            'GuestHierarchyLevel1' => '\\StructType\\GuestHierarchyLevel1',
            'GuestHierarchyLevel2' => '\\StructType\\GuestHierarchyLevel2',
            'GuestHierarchyLevel3' => '\\StructType\\GuestHierarchyLevel3',
            'GuestHierarchyLevel4' => '\\StructType\\GuestHierarchyLevel4',
            'GuestHierarchyLevel5' => '\\StructType\\GuestHierarchyLevel5',
            'GuestHierarchyLevel6' => '\\StructType\\GuestHierarchyLevel6',
            'GuestHierarchyLevel7' => '\\StructType\\GuestHierarchyLevel7',
            'S_GET_SETTLEMENT_PROFILE_V001Request' => '\\StructType\\S_GET_SETTLEMENT_PROFILE_V001Request',
            'S_GET_SETTLEMENT_PROFILE_V001Response' => '\\StructType\\S_GET_SETTLEMENT_PROFILE_V001Response',
            'SETTLEMENT-PROFILES' => '\\StructType\\SETTLEMENT_PROFILES',
            'SETTLEMENT-PROFILE' => '\\StructType\\SETTLEMENT_PROFILE',
            'S_GET_USER_INFO_V001Request' => '\\StructType\\S_GET_USER_INFO_V001Request',
            'S_GET_USER_INFO_V001Response' => '\\StructType\\S_GET_USER_INFO_V001Response',
            'UserInfo' => '\\StructType\\UserInfo',
            'S_GIFTVOUCHER_REDEEM_V001Request' => '\\StructType\\S_GIFTVOUCHER_REDEEM_V001Request',
            'S_GIFTVOUCHER_REDEEM_V001Response' => '\\StructType\\S_GIFTVOUCHER_REDEEM_V001Response',
            'S_GIFTVOUCHER_SEARCH_V002Request' => '\\StructType\\S_GIFTVOUCHER_SEARCH_V002Request',
            'S_GIFTVOUCHER_SEARCH_V002Response' => '\\StructType\\S_GIFTVOUCHER_SEARCH_V002Response',
            'S_GIFTVOUCHER_SELL_V001Request' => '\\StructType\\S_GIFTVOUCHER_SELL_V001Request',
            'S_GIFTVOUCHER_SELL_V001Response' => '\\StructType\\S_GIFTVOUCHER_SELL_V001Response',
            'S_GIFT_VOUCHER_REDEEM_V001Request' => '\\StructType\\S_GIFT_VOUCHER_REDEEM_V001Request',
            'S_GIFT_VOUCHER_REDEEM_V001Response' => '\\StructType\\S_GIFT_VOUCHER_REDEEM_V001Response',
            'S_GIFT_VOUCHER_SEARCH_V002Request' => '\\StructType\\S_GIFT_VOUCHER_SEARCH_V002Request',
            'S_GIFT_VOUCHER_SEARCH_V002Response' => '\\StructType\\S_GIFT_VOUCHER_SEARCH_V002Response',
            'S_GIFT_VOUCHER_SELL_V001Request' => '\\StructType\\S_GIFT_VOUCHER_SELL_V001Request',
            'S_GIFT_VOUCHER_SELL_V001Response' => '\\StructType\\S_GIFT_VOUCHER_SELL_V001Response',
            'S_GO_ACCOUNT_V001Request' => '\\StructType\\S_GO_ACCOUNT_V001Request',
            'S_GO_ACCOUNT_V001Response' => '\\StructType\\S_GO_ACCOUNT_V001Response',
            'InvoiceHolder' => '\\StructType\\InvoiceHolder',
            'S_GO_COMBOBOX_SEARCH_V001Request' => '\\StructType\\S_GO_COMBOBOX_SEARCH_V001Request',
            'S_GO_COMBOBOX_SEARCH_V001Response' => '\\StructType\\S_GO_COMBOBOX_SEARCH_V001Response',
            'S_GO_CONFIG_V001Request' => '\\StructType\\S_GO_CONFIG_V001Request',
            'InstallConfig' => '\\StructType\\InstallConfig',
            'S_GO_CONFIG_V001Response' => '\\StructType\\S_GO_CONFIG_V001Response',
            'Leaf' => '\\StructType\\Leaf',
            'S_GO_CONFIG_V002Request' => '\\StructType\\S_GO_CONFIG_V002Request',
            'S_GO_CONFIG_V002Response' => '\\StructType\\S_GO_CONFIG_V002Response',
            'S_GO_GST_EXTERNALID_ADD_V001Request' => '\\StructType\\S_GO_GST_EXTERNALID_ADD_V001Request',
            'Gst' => '\\StructType\\Gst',
            'GstExternalID' => '\\StructType\\GstExternalID',
            'S_GO_GST_EXTERNALID_ADD_V001Response' => '\\StructType\\S_GO_GST_EXTERNALID_ADD_V001Response',
            'S_GO_GST_EXTERNALID_DELETE_V001Request' => '\\StructType\\S_GO_GST_EXTERNALID_DELETE_V001Request',
            'S_GO_GST_EXTERNALID_DELETE_V001Response' => '\\StructType\\S_GO_GST_EXTERNALID_DELETE_V001Response',
            'S_GO_HOTEL_SEARCH_V001Request' => '\\StructType\\S_GO_HOTEL_SEARCH_V001Request',
            'HotelSearch' => '\\StructType\\HotelSearch',
            'S_GO_HOTEL_SEARCH_V001Response' => '\\StructType\\S_GO_HOTEL_SEARCH_V001Response',
            'Hotel' => '\\StructType\\Hotel',
            'S_GO_HOTEL_V001Request' => '\\StructType\\S_GO_HOTEL_V001Request',
            'S_GO_HOTEL_V001Response' => '\\StructType\\S_GO_HOTEL_V001Response',
            'Images' => '\\StructType\\Images',
            'Logo' => '\\StructType\\Logo',
            'Image' => '\\StructType\\Image',
            'S_GO_PERSON_EXTERNALID_ADD_V001Request' => '\\StructType\\S_GO_PERSON_EXTERNALID_ADD_V001Request',
            'Person' => '\\StructType\\Person',
            'PersonExternalID' => '\\StructType\\PersonExternalID',
            'S_GO_PERSON_EXTERNALID_ADD_V001Response' => '\\StructType\\S_GO_PERSON_EXTERNALID_ADD_V001Response',
            'S_GO_PERSON_EXTERNALID_DELETE_V001Request' => '\\StructType\\S_GO_PERSON_EXTERNALID_DELETE_V001Request',
            'S_GO_PERSON_EXTERNALID_DELETE_V001Response' => '\\StructType\\S_GO_PERSON_EXTERNALID_DELETE_V001Response',
            'S_GO_PERSON_FEEDBACK_ADD_V001Request' => '\\StructType\\S_GO_PERSON_FEEDBACK_ADD_V001Request',
            'PersonSearch' => '\\StructType\\PersonSearch',
            'Feedback' => '\\StructType\\Feedback',
            'FeedbackEntry' => '\\StructType\\FeedbackEntry',
            'S_GO_PERSON_FEEDBACK_ADD_V001Response' => '\\StructType\\S_GO_PERSON_FEEDBACK_ADD_V001Response',
            'S_GO_PERSON_FEEDBACK_V001Request' => '\\StructType\\S_GO_PERSON_FEEDBACK_V001Request',
            'S_GO_PERSON_FEEDBACK_V001Response' => '\\StructType\\S_GO_PERSON_FEEDBACK_V001Response',
            'S_GO_PERSON_LOAD_V001Request' => '\\StructType\\S_GO_PERSON_LOAD_V001Request',
            'S_GO_PERSON_LOAD_V001Response' => '\\StructType\\S_GO_PERSON_LOAD_V001Response',
            'GuestInfo' => '\\StructType\\GuestInfo',
            'GUESTACCOUNT' => '\\StructType\\GUESTACCOUNT',
            'CategoryUpselling' => '\\StructType\\CategoryUpselling',
            'UpsellingAddServices' => '\\StructType\\UpsellingAddServices',
            'UpsellingService' => '\\StructType\\UpsellingService',
            'Package' => '\\StructType\\Package',
            'S_GO_PERSON_LOAD_V002Request' => '\\StructType\\S_GO_PERSON_LOAD_V002Request',
            'S_GO_PERSON_LOAD_V002Response' => '\\StructType\\S_GO_PERSON_LOAD_V002Response',
            'S_GO_PERSON_MODIFY_V001Request' => '\\StructType\\S_GO_PERSON_MODIFY_V001Request',
            'S_GO_PERSON_MODIFY_V001Response' => '\\StructType\\S_GO_PERSON_MODIFY_V001Response',
            'S_GO_PERSON_SEARCH_V001Request' => '\\StructType\\S_GO_PERSON_SEARCH_V001Request',
            'GuestInHouseSearch' => '\\StructType\\GuestInHouseSearch',
            'S_GO_PERSON_SEARCH_V001Response' => '\\StructType\\S_GO_PERSON_SEARCH_V001Response',
            'S_GO_PERSON_SEARCH_V002Request' => '\\StructType\\S_GO_PERSON_SEARCH_V002Request',
            'S_GO_PERSON_SEARCH_V002Response' => '\\StructType\\S_GO_PERSON_SEARCH_V002Response',
            'S_GO_POSTPREPAYMENT_V001Request' => '\\StructType\\S_GO_POSTPREPAYMENT_V001Request',
            'Reservation' => '\\StructType\\Reservation_1',
            'S_GO_POSTPREPAYMENT_V001Response' => '\\StructType\\S_GO_POSTPREPAYMENT_V001Response',
            'PostPrePayment' => '\\StructType\\PostPrePayment',
            'S_GO_PREPAYMENT_POST_V001Request' => '\\StructType\\S_GO_PREPAYMENT_POST_V001Request',
            'S_GO_PREPAYMENT_POST_V001Response' => '\\StructType\\S_GO_PREPAYMENT_POST_V001Response',
            'S_GO_RESERVATION_SEARCH_V001Request' => '\\StructType\\S_GO_RESERVATION_SEARCH_V001Request',
            'ReservationSearch' => '\\StructType\\ReservationSearch',
            'S_GO_RESERVATION_SEARCH_V001Response' => '\\StructType\\S_GO_RESERVATION_SEARCH_V001Response',
            'ReservationSearchEntry' => '\\StructType\\ReservationSearchEntry',
            'Orderer' => '\\StructType\\Orderer_1',
            'S_GO_RESERVATION_V001Request' => '\\StructType\\S_GO_RESERVATION_V001Request',
            'S_GO_RESERVATION_V001Response' => '\\StructType\\S_GO_RESERVATION_V001Response',
            'Rooms' => '\\StructType\\Rooms_1',
            'GUEST-IDS' => '\\StructType\\GUEST_IDS',
            'LOYALTY-CARDS' => '\\StructType\\LOYALTY_CARDS',
            'RegistrationCard' => '\\StructType\\RegistrationCard',
            'S_GO_RESERVATION_V002Request' => '\\StructType\\S_GO_RESERVATION_V002Request',
            'S_GO_RESERVATION_V002Response' => '\\StructType\\S_GO_RESERVATION_V002Response',
            'S_GO_UPSELLCATEGORY_ASSIGN_V001Request' => '\\StructType\\S_GO_UPSELLCATEGORY_ASSIGN_V001Request',
            'RoomCategory' => '\\StructType\\RoomCategory',
            'S_GO_UPSELLCATEGORY_ASSIGN_V001Response' => '\\StructType\\S_GO_UPSELLCATEGORY_ASSIGN_V001Response',
            'S_GO_UPSELLCATEGORY_POSSIBLE_V001Request' => '\\StructType\\S_GO_UPSELLCATEGORY_POSSIBLE_V001Request',
            'Languages' => '\\StructType\\Languages',
            'S_GO_UPSELLCATEGORY_POSSIBLE_V001Response' => '\\StructType\\S_GO_UPSELLCATEGORY_POSSIBLE_V001Response',
            'CategoryMasterFile' => '\\StructType\\CategoryMasterFile',
            'S_GO_UPSELLSERVICES_POSSIBLE_V001Request' => '\\StructType\\S_GO_UPSELLSERVICES_POSSIBLE_V001Request',
            'S_GO_UPSELLSERVICES_POSSIBLE_V001Response' => '\\StructType\\S_GO_UPSELLSERVICES_POSSIBLE_V001Response',
            'S_GO_UPSELLSERVICE_ADD_V001Request' => '\\StructType\\S_GO_UPSELLSERVICE_ADD_V001Request',
            'S_GO_UPSELLSERVICE_ADD_V001Response' => '\\StructType\\S_GO_UPSELLSERVICE_ADD_V001Response',
            'S_GO_UPSELLSERVICE_REMOVE_V001Request' => '\\StructType\\S_GO_UPSELLSERVICE_REMOVE_V001Request',
            'S_GO_UPSELLSERVICE_REMOVE_V001Response' => '\\StructType\\S_GO_UPSELLSERVICE_REMOVE_V001Response',
            'S_GUEST_ANONYMISE_V001Request' => '\\StructType\\S_GUEST_ANONYMISE_V001Request',
            'S_GUEST_ANONYMISE_V001Response' => '\\StructType\\S_GUEST_ANONYMISE_V001Response',
            'S_GUEST_COMMENT_GET_V001Request' => '\\StructType\\S_GUEST_COMMENT_GET_V001Request',
            'S_GUEST_COMMENT_GET_V001Response' => '\\StructType\\S_GUEST_COMMENT_GET_V001Response',
            'COMMENTS' => '\\StructType\\COMMENTS_1',
            'S_GUEST_COMMENT_MODIFY_V001Request' => '\\StructType\\S_GUEST_COMMENT_MODIFY_V001Request',
            'S_GUEST_COMMENT_MODIFY_V001Response' => '\\StructType\\S_GUEST_COMMENT_MODIFY_V001Response',
            'S_GUEST_CONTACT_PERSONS_GET_V001Request' => '\\StructType\\S_GUEST_CONTACT_PERSONS_GET_V001Request',
            'S_GUEST_CONTACT_PERSONS_GET_V001Response' => '\\StructType\\S_GUEST_CONTACT_PERSONS_GET_V001Response',
            'CONTACT-PERSONS' => '\\StructType\\CONTACT_PERSONS',
            'CONTACT-PERSON' => '\\StructType\\CONTACT_PERSON',
            'S_GUEST_CONTACT_PERSON_ADD_V001Request' => '\\StructType\\S_GUEST_CONTACT_PERSON_ADD_V001Request',
            'COMPANY' => '\\StructType\\COMPANY',
            'S_GUEST_CONTACT_PERSON_ADD_V001Response' => '\\StructType\\S_GUEST_CONTACT_PERSON_ADD_V001Response',
            'S_GUEST_CONTACT_PERSON_REMOVE_V001Request' => '\\StructType\\S_GUEST_CONTACT_PERSON_REMOVE_V001Request',
            'S_GUEST_CONTACT_PERSON_REMOVE_V001Response' => '\\StructType\\S_GUEST_CONTACT_PERSON_REMOVE_V001Response',
            'S_GUEST_CREATE_V001Request' => '\\StructType\\S_GUEST_CREATE_V001Request',
            'S_GUEST_CREATE_V001Response' => '\\StructType\\S_GUEST_CREATE_V001Response',
            'S_GUEST_CREATE_V002Request' => '\\StructType\\S_GUEST_CREATE_V002Request',
            'GuestIdentifcation' => '\\StructType\\GuestIdentifcation',
            'GuestAdditional' => '\\StructType\\GuestAdditional',
            'S_GUEST_CREATE_V002Response' => '\\StructType\\S_GUEST_CREATE_V002Response',
            'S_GUEST_CREATE_V003Request' => '\\StructType\\S_GUEST_CREATE_V003Request',
            'S_GUEST_CREATE_V003Response' => '\\StructType\\S_GUEST_CREATE_V003Response',
            'S_GUEST_CREATE_V004Request' => '\\StructType\\S_GUEST_CREATE_V004Request',
            'GuestIdentification' => '\\StructType\\GuestIdentification',
            'EXTRA-INFORMATION' => '\\StructType\\EXTRA_INFORMATION',
            'S_GUEST_CREATE_V004Response' => '\\StructType\\S_GUEST_CREATE_V004Response',
            'S_GUEST_CREATE_V005Request' => '\\StructType\\S_GUEST_CREATE_V005Request',
            'S_GUEST_CREATE_V005Response' => '\\StructType\\S_GUEST_CREATE_V005Response',
            'S_GUEST_CREATE_V006Request' => '\\StructType\\S_GUEST_CREATE_V006Request',
            'S_GUEST_CREATE_V006Response' => '\\StructType\\S_GUEST_CREATE_V006Response',
            'S_GUEST_CREATE_V007Request' => '\\StructType\\S_GUEST_CREATE_V007Request',
            'S_GUEST_CREATE_V007Response' => '\\StructType\\S_GUEST_CREATE_V007Response',
            'S_GUEST_CREATE_V008Request' => '\\StructType\\S_GUEST_CREATE_V008Request',
            'GUEST-IDENTIFICATION' => '\\StructType\\GUEST_IDENTIFICATION',
            'S_GUEST_CREATE_V008Response' => '\\StructType\\S_GUEST_CREATE_V008Response',
            'S_GUEST_CRITERIA_GET_V001Request' => '\\StructType\\S_GUEST_CRITERIA_GET_V001Request',
            'S_GUEST_CRITERIA_GET_V001Response' => '\\StructType\\S_GUEST_CRITERIA_GET_V001Response',
            'GUESTCRITERIA' => '\\StructType\\GUESTCRITERIA',
            'CRITERIA' => '\\StructType\\CRITERIA',
            'CRITERION' => '\\StructType\\CRITERION',
            'S_GUEST_CRITERIA_MODIFY_V001Request' => '\\StructType\\S_GUEST_CRITERIA_MODIFY_V001Request',
            'S_GUEST_CRITERIA_MODIFY_V001Response' => '\\StructType\\S_GUEST_CRITERIA_MODIFY_V001Response',
            'S_GUEST_CRITERIA_SEARCH_V001Request' => '\\StructType\\S_GUEST_CRITERIA_SEARCH_V001Request',
            'SearchCriteria1' => '\\StructType\\SearchCriteria1',
            'SearchCriteria2' => '\\StructType\\SearchCriteria2',
            'S_GUEST_CRITERIA_SEARCH_V001Response' => '\\StructType\\S_GUEST_CRITERIA_SEARCH_V001Response',
            'Guests' => '\\StructType\\Guests',
            'S_GUEST_GET_V001Request' => '\\StructType\\S_GUEST_GET_V001Request',
            'S_GUEST_GET_V001Response' => '\\StructType\\S_GUEST_GET_V001Response',
            'S_GUEST_GET_V002Request' => '\\StructType\\S_GUEST_GET_V002Request',
            'S_GUEST_GET_V002Response' => '\\StructType\\S_GUEST_GET_V002Response',
            'S_GUEST_GET_V003Request' => '\\StructType\\S_GUEST_GET_V003Request',
            'S_GUEST_GET_V003Response' => '\\StructType\\S_GUEST_GET_V003Response',
            'NEWSLETTER-SUBSCRIPTION' => '\\StructType\\NEWSLETTER_SUBSCRIPTION',
            'EXTRA-INFORMATIONS' => '\\StructType\\EXTRA_INFORMATIONS',
            'S_GUEST_GET_V004Request' => '\\StructType\\S_GUEST_GET_V004Request',
            'S_GUEST_GET_V004Response' => '\\StructType\\S_GUEST_GET_V004Response',
            'LOYALTY' => '\\StructType\\LOYALTY',
            'LOYALTY-CARD' => '\\StructType\\LOYALTY_CARD',
            'S_GUEST_GET_V005Request' => '\\StructType\\S_GUEST_GET_V005Request',
            'S_GUEST_GET_V005Response' => '\\StructType\\S_GUEST_GET_V005Response',
            'S_GUEST_GET_V006Request' => '\\StructType\\S_GUEST_GET_V006Request',
            'S_GUEST_GET_V006Response' => '\\StructType\\S_GUEST_GET_V006Response',
            'S_GUEST_GET_V007Request' => '\\StructType\\S_GUEST_GET_V007Request',
            'S_GUEST_GET_V007Response' => '\\StructType\\S_GUEST_GET_V007Response',
            'MOTHER-COMPANY' => '\\StructType\\MOTHER_COMPANY',
            'S_GUEST_GET_V008Request' => '\\StructType\\S_GUEST_GET_V008Request',
            'S_GUEST_GET_V008Response' => '\\StructType\\S_GUEST_GET_V008Response',
            'GUEST-IDENTIFICATIONS' => '\\StructType\\GUEST_IDENTIFICATIONS',
            'S_GUEST_HIERARCHY_GET_V001Request' => '\\StructType\\S_GUEST_HIERARCHY_GET_V001Request',
            'S_GUEST_HIERARCHY_GET_V001Response' => '\\StructType\\S_GUEST_HIERARCHY_GET_V001Response',
            'S_GUEST_IN_HOUSE_SEARCH_V001Request' => '\\StructType\\S_GUEST_IN_HOUSE_SEARCH_V001Request',
            'S_GUEST_IN_HOUSE_SEARCH_V001Response' => '\\StructType\\S_GUEST_IN_HOUSE_SEARCH_V001Response',
            'roomState' => '\\StructType\\RoomState',
            'S_GUEST_IN_HOUSE_SEARCH_V002Request' => '\\StructType\\S_GUEST_IN_HOUSE_SEARCH_V002Request',
            'S_GUEST_IN_HOUSE_SEARCH_V002Response' => '\\StructType\\S_GUEST_IN_HOUSE_SEARCH_V002Response',
            'NamelistGroup' => '\\StructType\\NamelistGroup',
            'S_GUEST_LOYALTY_CARDS_ADD_V001Request' => '\\StructType\\S_GUEST_LOYALTY_CARDS_ADD_V001Request',
            'S_GUEST_LOYALTY_CARDS_ADD_V001Response' => '\\StructType\\S_GUEST_LOYALTY_CARDS_ADD_V001Response',
            'S_GUEST_LOYALTY_CARDS_DELETE_V001Request' => '\\StructType\\S_GUEST_LOYALTY_CARDS_DELETE_V001Request',
            'S_GUEST_LOYALTY_CARDS_DELETE_V001Response' => '\\StructType\\S_GUEST_LOYALTY_CARDS_DELETE_V001Response',
            'S_GUEST_LOYALTY_CARDS_GET_V001Request' => '\\StructType\\S_GUEST_LOYALTY_CARDS_GET_V001Request',
            'S_GUEST_LOYALTY_CARDS_GET_V001Response' => '\\StructType\\S_GUEST_LOYALTY_CARDS_GET_V001Response',
            'S_GUEST_LOYALTY_CARDS_MODIFY_V001Request' => '\\StructType\\S_GUEST_LOYALTY_CARDS_MODIFY_V001Request',
            'S_GUEST_LOYALTY_CARDS_MODIFY_V001Response' => '\\StructType\\S_GUEST_LOYALTY_CARDS_MODIFY_V001Response',
            'S_GUEST_MERGE_V001Request' => '\\StructType\\S_GUEST_MERGE_V001Request',
            'GUEST-MERGE' => '\\StructType\\GUEST_MERGE',
            'TARGET-GUEST' => '\\StructType\\TARGET_GUEST',
            'SOURCE-GUEST' => '\\StructType\\SOURCE_GUEST',
            'S_GUEST_MERGE_V001Response' => '\\StructType\\S_GUEST_MERGE_V001Response',
            'S_GUEST_MODIFY_V001Request' => '\\StructType\\S_GUEST_MODIFY_V001Request',
            'GuestSearchAndModify' => '\\StructType\\GuestSearchAndModify',
            'GuestModifyData' => '\\StructType\\GuestModifyData',
            'S_GUEST_MODIFY_V001Response' => '\\StructType\\S_GUEST_MODIFY_V001Response',
            'S_GUEST_MODIFY_V002Request' => '\\StructType\\S_GUEST_MODIFY_V002Request',
            'S_GUEST_MODIFY_V002Response' => '\\StructType\\S_GUEST_MODIFY_V002Response',
            'S_GUEST_MODIFY_V003Request' => '\\StructType\\S_GUEST_MODIFY_V003Request',
            'S_GUEST_MODIFY_V003Response' => '\\StructType\\S_GUEST_MODIFY_V003Response',
            'S_GUEST_MODIFY_V004Request' => '\\StructType\\S_GUEST_MODIFY_V004Request',
            'S_GUEST_MODIFY_V004Response' => '\\StructType\\S_GUEST_MODIFY_V004Response',
            'S_GUEST_MODIFY_V005Request' => '\\StructType\\S_GUEST_MODIFY_V005Request',
            'S_GUEST_MODIFY_V005Response' => '\\StructType\\S_GUEST_MODIFY_V005Response',
            'S_GUEST_MODIFY_V006Request' => '\\StructType\\S_GUEST_MODIFY_V006Request',
            'S_GUEST_MODIFY_V006Response' => '\\StructType\\S_GUEST_MODIFY_V006Response',
            'S_GUEST_MODIFY_V007Request' => '\\StructType\\S_GUEST_MODIFY_V007Request',
            'S_GUEST_MODIFY_V007Response' => '\\StructType\\S_GUEST_MODIFY_V007Response',
            'S_GUEST_MODIFY_V008Request' => '\\StructType\\S_GUEST_MODIFY_V008Request',
            'S_GUEST_MODIFY_V008Response' => '\\StructType\\S_GUEST_MODIFY_V008Response',
            'S_GUEST_MODIFY_V009Request' => '\\StructType\\S_GUEST_MODIFY_V009Request',
            'S_GUEST_MODIFY_V009Response' => '\\StructType\\S_GUEST_MODIFY_V009Response',
            'S_GUEST_PAYMENT_INSTRUCTIONS_GET_V001Request' => '\\StructType\\S_GUEST_PAYMENT_INSTRUCTIONS_GET_V001Request',
            'S_GUEST_PAYMENT_INSTRUCTIONS_GET_V001Response' => '\\StructType\\S_GUEST_PAYMENT_INSTRUCTIONS_GET_V001Response',
            'S_GUEST_PAYMENT_INSTRUCTIONS_SET_V001Request' => '\\StructType\\S_GUEST_PAYMENT_INSTRUCTIONS_SET_V001Request',
            'S_GUEST_PAYMENT_INSTRUCTIONS_SET_V001Response' => '\\StructType\\S_GUEST_PAYMENT_INSTRUCTIONS_SET_V001Response',
            'S_GUEST_SEARCH_V002Request' => '\\StructType\\S_GUEST_SEARCH_V002Request',
            'GuestSearch' => '\\StructType\\GuestSearch',
            'S_GUEST_SEARCH_V002Response' => '\\StructType\\S_GUEST_SEARCH_V002Response',
            'S_GUEST_SEARCH_V003Request' => '\\StructType\\S_GUEST_SEARCH_V003Request',
            'S_GUEST_SEARCH_V003Response' => '\\StructType\\S_GUEST_SEARCH_V003Response',
            'S_GUEST_SEARCH_V004Request' => '\\StructType\\S_GUEST_SEARCH_V004Request',
            'GUESTSEARCH' => '\\StructType\\GUESTSEARCH_1',
            'S_GUEST_SEARCH_V004Response' => '\\StructType\\S_GUEST_SEARCH_V004Response',
            'GUESTS' => '\\StructType\\GUESTS_1',
            'S_GUEST_SEARCH_V005Request' => '\\StructType\\S_GUEST_SEARCH_V005Request',
            'S_GUEST_SEARCH_V005Response' => '\\StructType\\S_GUEST_SEARCH_V005Response',
            'S_GUEST_SEARCH_V006Request' => '\\StructType\\S_GUEST_SEARCH_V006Request',
            'S_GUEST_SEARCH_V006Response' => '\\StructType\\S_GUEST_SEARCH_V006Response',
            'S_GUEST_SEARCH_V007Request' => '\\StructType\\S_GUEST_SEARCH_V007Request',
            'S_GUEST_SEARCH_V007Response' => '\\StructType\\S_GUEST_SEARCH_V007Response',
            'S_GUEST_SEARCH_V008Request' => '\\StructType\\S_GUEST_SEARCH_V008Request',
            'S_GUEST_SEARCH_V008Response' => '\\StructType\\S_GUEST_SEARCH_V008Response',
            'S_GUEST_SETTLEMENT_PROFILE_ADD_V001Request' => '\\StructType\\S_GUEST_SETTLEMENT_PROFILE_ADD_V001Request',
            'S_GUEST_SETTLEMENT_PROFILE_ADD_V001Response' => '\\StructType\\S_GUEST_SETTLEMENT_PROFILE_ADD_V001Response',
            'S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request' => '\\StructType\\S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request',
            'SettlementProfileData' => '\\StructType\\SettlementProfileData',
            'S_GUEST_SETTLEMENT_PROFILE_ADD_V002Response' => '\\StructType\\S_GUEST_SETTLEMENT_PROFILE_ADD_V002Response',
            'S_GUEST_SETTLEMENT_PROFILE_GET_V001Request' => '\\StructType\\S_GUEST_SETTLEMENT_PROFILE_GET_V001Request',
            'S_GUEST_SETTLEMENT_PROFILE_GET_V001Response' => '\\StructType\\S_GUEST_SETTLEMENT_PROFILE_GET_V001Response',
            'S_GUEST_SETTLEMENT_PROFILE_GET_V002Request' => '\\StructType\\S_GUEST_SETTLEMENT_PROFILE_GET_V002Request',
            'S_GUEST_SETTLEMENT_PROFILE_GET_V002Response' => '\\StructType\\S_GUEST_SETTLEMENT_PROFILE_GET_V002Response',
            'SettlementProfiles' => '\\StructType\\SettlementProfiles',
            'S_GUEST_SETTLEMENT_PROFILE_MODIFY_V001Request' => '\\StructType\\S_GUEST_SETTLEMENT_PROFILE_MODIFY_V001Request',
            'S_GUEST_SETTLEMENT_PROFILE_MODIFY_V001Response' => '\\StructType\\S_GUEST_SETTLEMENT_PROFILE_MODIFY_V001Response',
            'S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001Request' => '\\StructType\\S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001Request',
            'S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001Response' => '\\StructType\\S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001Response',
            'S_GUEST_TOKEN_ADD_V001Request' => '\\StructType\\S_GUEST_TOKEN_ADD_V001Request',
            'S_GUEST_TOKEN_ADD_V001Response' => '\\StructType\\S_GUEST_TOKEN_ADD_V001Response',
            'S_GUEST_TRAIL_NODE_GET_V001Request' => '\\StructType\\S_GUEST_TRAIL_NODE_GET_V001Request',
            'S_GUEST_TRAIL_NODE_GET_V001Response' => '\\StructType\\S_GUEST_TRAIL_NODE_GET_V001Response',
            'followUps' => '\\StructType\\FollowUps_1',
            'followUp' => '\\StructType\\FollowUp_1',
            'ExternalFileDatas' => '\\StructType\\ExternalFileDatas',
            'S_HOTEL_GET_V001Request' => '\\StructType\\S_HOTEL_GET_V001Request',
            'S_HOTEL_GET_V001Response' => '\\StructType\\S_HOTEL_GET_V001Response',
            'S_HOTEL_RESTRICTION_SEARCH_V001Request' => '\\StructType\\S_HOTEL_RESTRICTION_SEARCH_V001Request',
            'HOTELRESTRICTION-SEARCH' => '\\StructType\\HOTELRESTRICTION_SEARCH',
            'S_HOTEL_RESTRICTION_SEARCH_V001Response' => '\\StructType\\S_HOTEL_RESTRICTION_SEARCH_V001Response',
            'HOTELRESTRICTIONS' => '\\StructType\\HOTELRESTRICTIONS',
            'HOTELRESTRICTION' => '\\StructType\\HOTELRESTRICTION',
            'S_HOTEL_RESTRICTION_SEARCH_V002Request' => '\\StructType\\S_HOTEL_RESTRICTION_SEARCH_V002Request',
            'S_HOTEL_RESTRICTION_SEARCH_V002Response' => '\\StructType\\S_HOTEL_RESTRICTION_SEARCH_V002Response',
            'S_HOTEL_SEARCH_V001Request' => '\\StructType\\S_HOTEL_SEARCH_V001Request',
            'S_HOTEL_SEARCH_V001Response' => '\\StructType\\S_HOTEL_SEARCH_V001Response',
            'S_HOTEL_SEARCH_V01Request' => '\\StructType\\S_HOTEL_SEARCH_V01Request',
            'S_HOTEL_SEARCH_V01Response' => '\\StructType\\S_HOTEL_SEARCH_V01Response',
            'S_HOTEL_V001Request' => '\\StructType\\S_HOTEL_V001Request',
            'S_HOTEL_V001Response' => '\\StructType\\S_HOTEL_V001Response',
            'S_IMAGES_ADD_V001Request' => '\\StructType\\S_IMAGES_ADD_V001Request',
            'ImageManager' => '\\StructType\\ImageManager',
            'S_IMAGES_ADD_V001Response' => '\\StructType\\S_IMAGES_ADD_V001Response',
            'S_IMAGE_ADD_V001Request' => '\\StructType\\S_IMAGE_ADD_V001Request',
            'S_IMAGE_ADD_V001Response' => '\\StructType\\S_IMAGE_ADD_V001Response',
            'S_INVOICE_EMAIL_SET_V001Request' => '\\StructType\\S_INVOICE_EMAIL_SET_V001Request',
            'S_INVOICE_EMAIL_SET_V001Response' => '\\StructType\\S_INVOICE_EMAIL_SET_V001Response',
            'S_INVOICE_EMAIL_TRIGGER_V001Request' => '\\StructType\\S_INVOICE_EMAIL_TRIGGER_V001Request',
            'S_INVOICE_EMAIL_TRIGGER_V001Response' => '\\StructType\\S_INVOICE_EMAIL_TRIGGER_V001Response',
            'S_INVOICE_GET_V001Request' => '\\StructType\\S_INVOICE_GET_V001Request',
            'S_INVOICE_GET_V001Response' => '\\StructType\\S_INVOICE_GET_V001Response',
            'INVOICEHOLDER' => '\\StructType\\INVOICEHOLDER_1',
            'MAINACCOUNT' => '\\StructType\\MAINACCOUNT_1',
            'VATS' => '\\StructType\\VATS',
            'VAT' => '\\StructType\\VAT',
            'TAXS' => '\\StructType\\TAXS',
            'TAX' => '\\StructType\\TAX',
            'SERVICES' => '\\StructType\\SERVICES',
            'SERVICE' => '\\StructType\\SERVICE_1',
            'PARTLIST' => '\\StructType\\PARTLIST',
            'COMPONENT' => '\\StructType\\COMPONENT',
            'PAYMENTS' => '\\StructType\\PAYMENTS_1',
            'S_INVOICE_GET_V002Request' => '\\StructType\\S_INVOICE_GET_V002Request',
            'S_INVOICE_GET_V002Response' => '\\StructType\\S_INVOICE_GET_V002Response',
            'PRINTDOCUMENT' => '\\StructType\\PRINTDOCUMENT',
            'S_INVOICE_SEARCH_V001Request' => '\\StructType\\S_INVOICE_SEARCH_V001Request',
            'INVOICESEARCH' => '\\StructType\\INVOICESEARCH',
            'S_INVOICE_SEARCH_V001Response' => '\\StructType\\S_INVOICE_SEARCH_V001Response',
            'INVOICES' => '\\StructType\\INVOICES',
            'S_MOBILE_GUEST_IN_HOUSE_SEARCH_V001Request' => '\\StructType\\S_MOBILE_GUEST_IN_HOUSE_SEARCH_V001Request',
            'S_MOBILE_GUEST_IN_HOUSE_SEARCH_V001Response' => '\\StructType\\S_MOBILE_GUEST_IN_HOUSE_SEARCH_V001Response',
            'S_MOBILE_HOTEL_GET_V001Request' => '\\StructType\\S_MOBILE_HOTEL_GET_V001Request',
            'S_MOBILE_HOTEL_GET_V001Response' => '\\StructType\\S_MOBILE_HOTEL_GET_V001Response',
            'S_MOBILE_HOTEL_SEARCH_V001Request' => '\\StructType\\S_MOBILE_HOTEL_SEARCH_V001Request',
            'S_MOBILE_HOTEL_SEARCH_V001Response' => '\\StructType\\S_MOBILE_HOTEL_SEARCH_V001Response',
            'S_MOBILE_IMAGE_ADD_V001Request' => '\\StructType\\S_MOBILE_IMAGE_ADD_V001Request',
            'S_MOBILE_IMAGE_ADD_V001Response' => '\\StructType\\S_MOBILE_IMAGE_ADD_V001Response',
            'S_MOBILE_IMAGE_DELETE_V001Request' => '\\StructType\\S_MOBILE_IMAGE_DELETE_V001Request',
            'IMAGES' => '\\StructType\\IMAGES_1',
            'IMAGE' => '\\StructType\\IMAGE_1',
            'S_MOBILE_IMAGE_DELETE_V001Response' => '\\StructType\\S_MOBILE_IMAGE_DELETE_V001Response',
            'S_MOBILE_IMAGE_MODIFY_V001Request' => '\\StructType\\S_MOBILE_IMAGE_MODIFY_V001Request',
            'S_MOBILE_IMAGE_MODIFY_V001Response' => '\\StructType\\S_MOBILE_IMAGE_MODIFY_V001Response',
            'S_MOBILE_LOST_AND_FOUND_ADD_V001Request' => '\\StructType\\S_MOBILE_LOST_AND_FOUND_ADD_V001Request',
            'LOST-AND-FOUND' => '\\StructType\\LOST_AND_FOUND',
            'S_MOBILE_LOST_AND_FOUND_ADD_V001Response' => '\\StructType\\S_MOBILE_LOST_AND_FOUND_ADD_V001Response',
            'S_MOBILE_LOST_AND_FOUND_DELETE_V001Request' => '\\StructType\\S_MOBILE_LOST_AND_FOUND_DELETE_V001Request',
            'S_MOBILE_LOST_AND_FOUND_DELETE_V001Response' => '\\StructType\\S_MOBILE_LOST_AND_FOUND_DELETE_V001Response',
            'S_MOBILE_LOST_AND_FOUND_GET_V001Request' => '\\StructType\\S_MOBILE_LOST_AND_FOUND_GET_V001Request',
            'S_MOBILE_LOST_AND_FOUND_GET_V001Response' => '\\StructType\\S_MOBILE_LOST_AND_FOUND_GET_V001Response',
            'S_MOBILE_LOST_AND_FOUND_IMAGE_GET_V001Request' => '\\StructType\\S_MOBILE_LOST_AND_FOUND_IMAGE_GET_V001Request',
            'S_MOBILE_LOST_AND_FOUND_IMAGE_GET_V001Response' => '\\StructType\\S_MOBILE_LOST_AND_FOUND_IMAGE_GET_V001Response',
            'S_MOBILE_LOST_AND_FOUND_MODIFY_V001Request' => '\\StructType\\S_MOBILE_LOST_AND_FOUND_MODIFY_V001Request',
            'S_MOBILE_LOST_AND_FOUND_MODIFY_V001Response' => '\\StructType\\S_MOBILE_LOST_AND_FOUND_MODIFY_V001Response',
            'S_MOBILE_LOST_AND_FOUND_SEARCH_V001Request' => '\\StructType\\S_MOBILE_LOST_AND_FOUND_SEARCH_V001Request',
            'LOST-AND-FOUND-SEARCH' => '\\StructType\\LOST_AND_FOUND_SEARCH',
            'S_MOBILE_LOST_AND_FOUND_SEARCH_V001Response' => '\\StructType\\S_MOBILE_LOST_AND_FOUND_SEARCH_V001Response',
            'LOST-AND-FOUND-LIST' => '\\StructType\\LOST_AND_FOUND_LIST',
            'S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_GET_V001Request' => '\\StructType\\S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_GET_V001Request',
            'ROOMTOCLEAN' => '\\StructType\\ROOMTOCLEAN',
            'S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_GET_V001Response' => '\\StructType\\S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_GET_V001Response',
            'ROOM' => '\\StructType\\ROOM_2',
            'ARRIVAL' => '\\StructType\\ARRIVAL',
            'STAY' => '\\StructType\\STAY',
            'DEPARTURE' => '\\StructType\\DEPARTURE',
            'S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_MODIFY_V001Request' => '\\StructType\\S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_MODIFY_V001Request',
            'S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_MODIFY_V001Response' => '\\StructType\\S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_MODIFY_V001Response',
            'S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_SEARCH_V001Request' => '\\StructType\\S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_SEARCH_V001Request',
            'SEARCH' => '\\StructType\\SEARCH_1',
            'S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_SEARCH_V001Response' => '\\StructType\\S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_SEARCH_V001Response',
            'ROOMSTOCLEAN' => '\\StructType\\ROOMSTOCLEAN',
            'S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001Request' => '\\StructType\\S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001Request',
            'MaintenanceRequestSearch' => '\\StructType\\MaintenanceRequestSearch',
            'S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001Response' => '\\StructType\\S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001Response',
            'MaintenanceRequest' => '\\StructType\\MaintenanceRequest',
            'S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Request' => '\\StructType\\S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Request',
            'S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Response' => '\\StructType\\S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Response',
            'S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001Request' => '\\StructType\\S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001Request',
            'RoomSearchAndModify' => '\\StructType\\RoomSearchAndModify',
            'RoomSateModifyData' => '\\StructType\\RoomSateModifyData',
            'S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001Response' => '\\StructType\\S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001Response',
            'S_MOBILE_ROOM_MAINTENANCE_STATE_RESET_V001Request' => '\\StructType\\S_MOBILE_ROOM_MAINTENANCE_STATE_RESET_V001Request',
            'MaintenanceState' => '\\StructType\\MaintenanceState',
            'S_MOBILE_ROOM_MAINTENANCE_STATE_RESET_V001Response' => '\\StructType\\S_MOBILE_ROOM_MAINTENANCE_STATE_RESET_V001Response',
            'S_MOBILE_ROOM_STATE_CHANGE_V001Request' => '\\StructType\\S_MOBILE_ROOM_STATE_CHANGE_V001Request',
            'RoomStateSearchAndModify' => '\\StructType\\RoomStateSearchAndModify',
            'S_MOBILE_ROOM_STATE_CHANGE_V001Response' => '\\StructType\\S_MOBILE_ROOM_STATE_CHANGE_V001Response',
            'S_MOBILE_ROOM_STATE_SEARCH_V001Request' => '\\StructType\\S_MOBILE_ROOM_STATE_SEARCH_V001Request',
            'RoomSearch' => '\\StructType\\RoomSearch',
            'S_MOBILE_ROOM_STATE_SEARCH_V001Response' => '\\StructType\\S_MOBILE_ROOM_STATE_SEARCH_V001Response',
            'bookingdata' => '\\StructType\\Bookingdata',
            'S_NOTIFICATION_CONFIRM_V001Request' => '\\StructType\\S_NOTIFICATION_CONFIRM_V001Request',
            'NOTIFICATION-CONFIRM' => '\\StructType\\NOTIFICATION_CONFIRM',
            'S_NOTIFICATION_CONFIRM_V001Response' => '\\StructType\\S_NOTIFICATION_CONFIRM_V001Response',
            'S_NOTIFICATION_ERROR_SET_V001Request' => '\\StructType\\S_NOTIFICATION_ERROR_SET_V001Request',
            'NOTIFICATION-ERROR' => '\\StructType\\NOTIFICATION_ERROR',
            'S_NOTIFICATION_ERROR_SET_V001Response' => '\\StructType\\S_NOTIFICATION_ERROR_SET_V001Response',
            'S_NOTIFICATION_REGISTER_V001Request' => '\\StructType\\S_NOTIFICATION_REGISTER_V001Request',
            'NOTIFICATION-REGISTER' => '\\StructType\\NOTIFICATION_REGISTER',
            'TRIGGER' => '\\StructType\\TRIGGER',
            'CONSTRAINT' => '\\StructType\\CONSTRAINT',
            'S_NOTIFICATION_REGISTER_V001Response' => '\\StructType\\S_NOTIFICATION_REGISTER_V001Response',
            'NOTIFICATION-REGISTRATION' => '\\StructType\\NOTIFICATION_REGISTRATION',
            'S_NOTIFICATION_REGISTER_V002Request' => '\\StructType\\S_NOTIFICATION_REGISTER_V002Request',
            'S_NOTIFICATION_REGISTER_V002Response' => '\\StructType\\S_NOTIFICATION_REGISTER_V002Response',
            'S_NOTIFICATION_REGISTRATION_SEARCH_V001Request' => '\\StructType\\S_NOTIFICATION_REGISTRATION_SEARCH_V001Request',
            'NOTIFICATION-REGISTRATION-SEARCH' => '\\StructType\\NOTIFICATION_REGISTRATION_SEARCH',
            'S_NOTIFICATION_REGISTRATION_SEARCH_V001Response' => '\\StructType\\S_NOTIFICATION_REGISTRATION_SEARCH_V001Response',
            'NOTIFICATION-REGISTRATIONS' => '\\StructType\\NOTIFICATION_REGISTRATIONS',
            'S_NOTIFICATION_SEARCH_V001Request' => '\\StructType\\S_NOTIFICATION_SEARCH_V001Request',
            'S_NOTIFICATION_SEARCH_V001Response' => '\\StructType\\S_NOTIFICATION_SEARCH_V001Response',
            'NOTIFICATIONS' => '\\StructType\\NOTIFICATIONS',
            'NOTIFICATION' => '\\StructType\\NOTIFICATION',
            'TRIGGER-OPTIONS' => '\\StructType\\TRIGGER_OPTIONS',
            'CONSTRAINT-OPTIONS' => '\\StructType\\CONSTRAINT_OPTIONS',
            'S_NOTIFICATION_UNREGISTER_V001Request' => '\\StructType\\S_NOTIFICATION_UNREGISTER_V001Request',
            'NOTIFICATION-UNREGISTER' => '\\StructType\\NOTIFICATION_UNREGISTER',
            'S_NOTIFICATION_UNREGISTER_V001Response' => '\\StructType\\S_NOTIFICATION_UNREGISTER_V001Response',
            'S_PACKAGES_SEARCH_V001Request' => '\\StructType\\S_PACKAGES_SEARCH_V001Request',
            'S_PACKAGES_SEARCH_V001Response' => '\\StructType\\S_PACKAGES_SEARCH_V001Response',
            'SearchEntry' => '\\StructType\\SearchEntry',
            'MultiLanguageDescription' => '\\StructType\\MultiLanguageDescription',
            'LanguageDescription' => '\\StructType\\LanguageDescription',
            'S_PACKAGES_SEARCH_V002Request' => '\\StructType\\S_PACKAGES_SEARCH_V002Request',
            'S_PACKAGES_SEARCH_V002Response' => '\\StructType\\S_PACKAGES_SEARCH_V002Response',
            'Rates' => '\\StructType\\Rates',
            'StandardRateByCategory' => '\\StructType\\StandardRateByCategory',
            'StandardRateEntry' => '\\StructType\\StandardRateEntry',
            'SeasonalRate' => '\\StructType\\SeasonalRate',
            'SeasonalRateCat' => '\\StructType\\SeasonalRateCat',
            'SeasonalRateEntry' => '\\StructType\\SeasonalRateEntry',
            'S_PACKAGE_MAPPING_GET_V001Request' => '\\StructType\\S_PACKAGE_MAPPING_GET_V001Request',
            'S_PACKAGE_MAPPING_GET_V001Response' => '\\StructType\\S_PACKAGE_MAPPING_GET_V001Response',
            'S_PACKAGE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request' => '\\StructType\\S_PACKAGE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request',
            'PackageMasterFileSearch' => '\\StructType\\PackageMasterFileSearch',
            'S_PACKAGE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response' => '\\StructType\\S_PACKAGE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response',
            'PackageMasterFiles' => '\\StructType\\PackageMasterFiles',
            'PackageMasterFile' => '\\StructType\\PackageMasterFile',
            'S_PACKAGE_SEARCH_V001Request' => '\\StructType\\S_PACKAGE_SEARCH_V001Request',
            'S_PACKAGE_SEARCH_V001Response' => '\\StructType\\S_PACKAGE_SEARCH_V001Response',
            'S_PACKAGE_SEARCH_V002Request' => '\\StructType\\S_PACKAGE_SEARCH_V002Request',
            'S_PACKAGE_SEARCH_V002Response' => '\\StructType\\S_PACKAGE_SEARCH_V002Response',
            'S_PAYMENT_ABORT_V001Request' => '\\StructType\\S_PAYMENT_ABORT_V001Request',
            'PaymentAbort' => '\\StructType\\PaymentAbort',
            'S_PAYMENT_ABORT_V001Response' => '\\StructType\\S_PAYMENT_ABORT_V001Response',
            'S_PAYMENT_COMMIT_V001Request' => '\\StructType\\S_PAYMENT_COMMIT_V001Request',
            'PaymentCommit' => '\\StructType\\PaymentCommit',
            'S_PAYMENT_COMMIT_V001Response' => '\\StructType\\S_PAYMENT_COMMIT_V001Response',
            'S_PAYMENT_POSTING_SEARCH_V001Request' => '\\StructType\\S_PAYMENT_POSTING_SEARCH_V001Request',
            'PAYMENT-POSTING-SEARCH' => '\\StructType\\PAYMENT_POSTING_SEARCH',
            'S_PAYMENT_POSTING_SEARCH_V001Response' => '\\StructType\\S_PAYMENT_POSTING_SEARCH_V001Response',
            'PAYMENT-POSTINGS' => '\\StructType\\PAYMENT_POSTINGS',
            'PAYMENT-POSTING' => '\\StructType\\PAYMENT_POSTING',
            'S_PERSON_ADD_SERVICE_MANUAL_RATE_V001Request' => '\\StructType\\S_PERSON_ADD_SERVICE_MANUAL_RATE_V001Request',
            'ServiceData' => '\\StructType\\ServiceData',
            'S_PERSON_ADD_SERVICE_MANUAL_RATE_V001Response' => '\\StructType\\S_PERSON_ADD_SERVICE_MANUAL_RATE_V001Response',
            'S_PERSON_ADD_SERVICE_V001Request' => '\\StructType\\S_PERSON_ADD_SERVICE_V001Request',
            'S_PERSON_ADD_SERVICE_V001Response' => '\\StructType\\S_PERSON_ADD_SERVICE_V001Response',
            'S_PERSON_ASSSIGN_GUEST_V001Request' => '\\StructType\\S_PERSON_ASSSIGN_GUEST_V001Request',
            'S_PERSON_ASSSIGN_GUEST_V001Response' => '\\StructType\\S_PERSON_ASSSIGN_GUEST_V001Response',
            'S_PERSON_GET_SERVICES_V01Request' => '\\StructType\\S_PERSON_GET_SERVICES_V01Request',
            'S_PERSON_GET_SERVICES_V01Response' => '\\StructType\\S_PERSON_GET_SERVICES_V01Response',
            'S_PERSON_GUEST_ASSIGN_V001Request' => '\\StructType\\S_PERSON_GUEST_ASSIGN_V001Request',
            'S_PERSON_GUEST_ASSIGN_V001Response' => '\\StructType\\S_PERSON_GUEST_ASSIGN_V001Response',
            'S_PERSON_GUEST_UNASSIGN_V001Request' => '\\StructType\\S_PERSON_GUEST_UNASSIGN_V001Request',
            'PERSON' => '\\StructType\\PERSON_2',
            'S_PERSON_GUEST_UNASSIGN_V001Response' => '\\StructType\\S_PERSON_GUEST_UNASSIGN_V001Response',
            'S_PERSON_MODIFY_V001Request' => '\\StructType\\S_PERSON_MODIFY_V001Request',
            'S_PERSON_MODIFY_V001Response' => '\\StructType\\S_PERSON_MODIFY_V001Response',
            'S_PERSON_MODIFY_V002Request' => '\\StructType\\S_PERSON_MODIFY_V002Request',
            'S_PERSON_MODIFY_V002Response' => '\\StructType\\S_PERSON_MODIFY_V002Response',
            'S_PERSON_MODIFY_V003Request' => '\\StructType\\S_PERSON_MODIFY_V003Request',
            'S_PERSON_MODIFY_V003Response' => '\\StructType\\S_PERSON_MODIFY_V003Response',
            'S_PERSON_PRE_CHECK_IN_V001Request' => '\\StructType\\S_PERSON_PRE_CHECK_IN_V001Request',
            'S_PERSON_PRE_CHECK_IN_V001Response' => '\\StructType\\S_PERSON_PRE_CHECK_IN_V001Response',
            'S_PERSON_PRE_CHECK_OUT_V001Request' => '\\StructType\\S_PERSON_PRE_CHECK_OUT_V001Request',
            'S_PERSON_PRE_CHECK_OUT_V001Response' => '\\StructType\\S_PERSON_PRE_CHECK_OUT_V001Response',
            'S_PERSON_REMOVE_SERVICE_V001Request' => '\\StructType\\S_PERSON_REMOVE_SERVICE_V001Request',
            'ServiceToRemove' => '\\StructType\\ServiceToRemove',
            'S_PERSON_REMOVE_SERVICE_V001Response' => '\\StructType\\S_PERSON_REMOVE_SERVICE_V001Response',
            'S_PERSON_REMOVE_V001Request' => '\\StructType\\S_PERSON_REMOVE_V001Request',
            'S_PERSON_REMOVE_V001Response' => '\\StructType\\S_PERSON_REMOVE_V001Response',
            'S_PERSON_ROOM_HOLDER_ASSIGN_V001Request' => '\\StructType\\S_PERSON_ROOM_HOLDER_ASSIGN_V001Request',
            'S_PERSON_ROOM_HOLDER_ASSIGN_V001Response' => '\\StructType\\S_PERSON_ROOM_HOLDER_ASSIGN_V001Response',
            'S_PERSON_SERVICE_ADD_V001Request' => '\\StructType\\S_PERSON_SERVICE_ADD_V001Request',
            'S_PERSON_SERVICE_ADD_V001Response' => '\\StructType\\S_PERSON_SERVICE_ADD_V001Response',
            'S_PERSON_SERVICE_FORCE_MODIFY_V001Request' => '\\StructType\\S_PERSON_SERVICE_FORCE_MODIFY_V001Request',
            'PERSON-SERVICE' => '\\StructType\\PERSON_SERVICE',
            'SERVICE-DATA' => '\\StructType\\SERVICE_DATA',
            'S_PERSON_SERVICE_FORCE_MODIFY_V001Response' => '\\StructType\\S_PERSON_SERVICE_FORCE_MODIFY_V001Response',
            'S_PERSON_SERVICE_GET_V001Request' => '\\StructType\\S_PERSON_SERVICE_GET_V001Request',
            'S_PERSON_SERVICE_GET_V001Response' => '\\StructType\\S_PERSON_SERVICE_GET_V001Response',
            'S_PERSON_SERVICE_GET_V002Request' => '\\StructType\\S_PERSON_SERVICE_GET_V002Request',
            'S_PERSON_SERVICE_GET_V002Response' => '\\StructType\\S_PERSON_SERVICE_GET_V002Response',
            'S_PERSON_SERVICE_MANUAL_RATE_ADD_V001Request' => '\\StructType\\S_PERSON_SERVICE_MANUAL_RATE_ADD_V001Request',
            'S_PERSON_SERVICE_MANUAL_RATE_ADD_V001Response' => '\\StructType\\S_PERSON_SERVICE_MANUAL_RATE_ADD_V001Response',
            'S_PERSON_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Request' => '\\StructType\\S_PERSON_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Request',
            'S_PERSON_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Response' => '\\StructType\\S_PERSON_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Response',
            'S_PERSON_SERVICE_MANUAL_RATE_MODIFY_V001Request' => '\\StructType\\S_PERSON_SERVICE_MANUAL_RATE_MODIFY_V001Request',
            'S_PERSON_SERVICE_MANUAL_RATE_MODIFY_V001Response' => '\\StructType\\S_PERSON_SERVICE_MANUAL_RATE_MODIFY_V001Response',
            'S_PERSON_SERVICE_MODIFY_V001Request' => '\\StructType\\S_PERSON_SERVICE_MODIFY_V001Request',
            'S_PERSON_SERVICE_MODIFY_V001Response' => '\\StructType\\S_PERSON_SERVICE_MODIFY_V001Response',
            'S_PERSON_SERVICE_MODIFY_V002Request' => '\\StructType\\S_PERSON_SERVICE_MODIFY_V002Request',
            'S_PERSON_SERVICE_MODIFY_V002Response' => '\\StructType\\S_PERSON_SERVICE_MODIFY_V002Response',
            'S_PERSON_SERVICE_REMOVE_V001Request' => '\\StructType\\S_PERSON_SERVICE_REMOVE_V001Request',
            'S_PERSON_SERVICE_REMOVE_V001Response' => '\\StructType\\S_PERSON_SERVICE_REMOVE_V001Response',
            'S_PERSON_TOKEN_ADD_V001Request' => '\\StructType\\S_PERSON_TOKEN_ADD_V001Request',
            'S_PERSON_TOKEN_ADD_V001Response' => '\\StructType\\S_PERSON_TOKEN_ADD_V001Response',
            'S_POLICELIST_ADD_V001Request' => '\\StructType\\S_POLICELIST_ADD_V001Request',
            'PoliceList' => '\\StructType\\PoliceList',
            'S_POLICELIST_ADD_V001Response' => '\\StructType\\S_POLICELIST_ADD_V001Response',
            'S_POLICELIST_MODIFY_V001Request' => '\\StructType\\S_POLICELIST_MODIFY_V001Request',
            'PoliceListSearch' => '\\StructType\\PoliceListSearch',
            'S_POLICELIST_MODIFY_V001Response' => '\\StructType\\S_POLICELIST_MODIFY_V001Response',
            'S_PRODUCT_FEATURES_GET_V001Request' => '\\StructType\\S_PRODUCT_FEATURES_GET_V001Request',
            'PRODUCT-FEATURES' => '\\StructType\\PRODUCT_FEATURES',
            'S_PRODUCT_FEATURES_GET_V001Response' => '\\StructType\\S_PRODUCT_FEATURES_GET_V001Response',
            'FEATURES' => '\\StructType\\FEATURES',
            'FEATURE' => '\\StructType\\FEATURE',
            'S_RATE_SEARCH_V001Request' => '\\StructType\\S_RATE_SEARCH_V001Request',
            'RATEREQUESTSEARCH' => '\\StructType\\RATEREQUESTSEARCH',
            'PERSONTYPE' => '\\StructType\\PERSONTYPE',
            'S_RATE_SEARCH_V001Response' => '\\StructType\\S_RATE_SEARCH_V001Response',
            'RATERESULT' => '\\StructType\\RATERESULT',
            'DAILYRATERESULT' => '\\StructType\\DAILYRATERESULT',
            'S_RATE_SEGMENT_RESTRICTION_SEARCH_V001Request' => '\\StructType\\S_RATE_SEGMENT_RESTRICTION_SEARCH_V001Request',
            'RATESEGMENTRESTRICTION-SEARCH' => '\\StructType\\RATESEGMENTRESTRICTION_SEARCH',
            'S_RATE_SEGMENT_RESTRICTION_SEARCH_V001Response' => '\\StructType\\S_RATE_SEGMENT_RESTRICTION_SEARCH_V001Response',
            'RATESEGMENTRESTRICTIONS' => '\\StructType\\RATESEGMENTRESTRICTIONS',
            'RATESEGMENTRESTRICTION' => '\\StructType\\RATESEGMENTRESTRICTION',
            'S_RATE_SEGMENT_RESTRICTION_SEARCH_V002Request' => '\\StructType\\S_RATE_SEGMENT_RESTRICTION_SEARCH_V002Request',
            'S_RATE_SEGMENT_RESTRICTION_SEARCH_V002Response' => '\\StructType\\S_RATE_SEGMENT_RESTRICTION_SEARCH_V002Response',
            'S_REGISTRATIONCARD_GET_V001Request' => '\\StructType\\S_REGISTRATIONCARD_GET_V001Request',
            'S_REGISTRATIONCARD_GET_V001Response' => '\\StructType\\S_REGISTRATIONCARD_GET_V001Response',
            'PersonList' => '\\StructType\\PersonList',
            'PINamelistGroup' => '\\StructType\\PINamelistGroup',
            'PIGuest' => '\\StructType\\PIGuest',
            'GuestFolio' => '\\StructType\\GuestFolio',
            'PIOrderer' => '\\StructType\\PIOrderer',
            'OrdererFolio' => '\\StructType\\OrdererFolio',
            'Namelist' => '\\StructType\\Namelist',
            'PoliceListEntry' => '\\StructType\\PoliceListEntry',
            'S_REGISTRATIONCARD_GET_V002Request' => '\\StructType\\S_REGISTRATIONCARD_GET_V002Request',
            'S_REGISTRATIONCARD_GET_V002Response' => '\\StructType\\S_REGISTRATIONCARD_GET_V002Response',
            'S_REGISTRATIONCARD_MODIFY_V001Request' => '\\StructType\\S_REGISTRATIONCARD_MODIFY_V001Request',
            'RegistrationCardSearch' => '\\StructType\\RegistrationCardSearch',
            'S_REGISTRATIONCARD_MODIFY_V001Response' => '\\StructType\\S_REGISTRATIONCARD_MODIFY_V001Response',
            'S_REGISTRY_SPEED_TEST_V001Request' => '\\StructType\\S_REGISTRY_SPEED_TEST_V001Request',
            'REGISTRY-SPEEDTEST' => '\\StructType\\REGISTRY_SPEEDTEST',
            'S_REGISTRY_SPEED_TEST_V001Response' => '\\StructType\\S_REGISTRY_SPEED_TEST_V001Response',
            'RESULTSET' => '\\StructType\\RESULTSET',
            'S_REMOVE_SETTLEMENT_PROFILE_V001Request' => '\\StructType\\S_REMOVE_SETTLEMENT_PROFILE_V001Request',
            'S_REMOVE_SETTLEMENT_PROFILE_V001Response' => '\\StructType\\S_REMOVE_SETTLEMENT_PROFILE_V001Response',
            'S_RESERVATION_ADD_ROOM_V001Request' => '\\StructType\\S_RESERVATION_ADD_ROOM_V001Request',
            'RoomAdd' => '\\StructType\\RoomAdd',
            'S_RESERVATION_ADD_ROOM_V001Response' => '\\StructType\\S_RESERVATION_ADD_ROOM_V001Response',
            'S_RESERVATION_ADD_SERVICE_MANUAL_RATE_V001Request' => '\\StructType\\S_RESERVATION_ADD_SERVICE_MANUAL_RATE_V001Request',
            'S_RESERVATION_ADD_SERVICE_MANUAL_RATE_V001Response' => '\\StructType\\S_RESERVATION_ADD_SERVICE_MANUAL_RATE_V001Response',
            'S_RESERVATION_ADD_SERVICE_V001Request' => '\\StructType\\S_RESERVATION_ADD_SERVICE_V001Request',
            'S_RESERVATION_ADD_SERVICE_V001Response' => '\\StructType\\S_RESERVATION_ADD_SERVICE_V001Response',
            'S_RESERVATION_AUTO_ASSIGN_ROOM_V001Request' => '\\StructType\\S_RESERVATION_AUTO_ASSIGN_ROOM_V001Request',
            'S_RESERVATION_AUTO_ASSIGN_ROOM_V001Response' => '\\StructType\\S_RESERVATION_AUTO_ASSIGN_ROOM_V001Response',
            'S_RESERVATION_CHANGE_PREVIEW_V001Request' => '\\StructType\\S_RESERVATION_CHANGE_PREVIEW_V001Request',
            'ResForecast' => '\\StructType\\ResForecast',
            'ReservationPackage' => '\\StructType\\ReservationPackage',
            'PersonPackage' => '\\StructType\\PersonPackage',
            'S_RESERVATION_CHANGE_PREVIEW_V001Response' => '\\StructType\\S_RESERVATION_CHANGE_PREVIEW_V001Response',
            'DEPOSIT' => '\\StructType\\DEPOSIT',
            'SUMMARY' => '\\StructType\\SUMMARY',
            'FORECAST' => '\\StructType\\FORECAST',
            'S_RESERVATION_CHECK_IN_V001Request' => '\\StructType\\S_RESERVATION_CHECK_IN_V001Request',
            'S_RESERVATION_CHECK_IN_V001Response' => '\\StructType\\S_RESERVATION_CHECK_IN_V001Response',
            'S_RESERVATION_CHECK_IN_V002Request' => '\\StructType\\S_RESERVATION_CHECK_IN_V002Request',
            'S_RESERVATION_CHECK_IN_V002Response' => '\\StructType\\S_RESERVATION_CHECK_IN_V002Response',
            'ROOMS' => '\\StructType\\ROOMS',
            'S_RESERVATION_CREATE_V001Request' => '\\StructType\\S_RESERVATION_CREATE_V001Request',
            'ORDERERCONTACTPERSON' => '\\StructType\\ORDERERCONTACTPERSON',
            'TRAVELAGENCYCONTACTPERSON' => '\\StructType\\TRAVELAGENCYCONTACTPERSON',
            'TRAVELPOINTCONTACTPERSON' => '\\StructType\\TRAVELPOINTCONTACTPERSON',
            'S_RESERVATION_CREATE_V001Response' => '\\StructType\\S_RESERVATION_CREATE_V001Response',
            'S_RESERVATION_CREATE_V002Request' => '\\StructType\\S_RESERVATION_CREATE_V002Request',
            'S_RESERVATION_CREATE_V002Response' => '\\StructType\\S_RESERVATION_CREATE_V002Response',
            'S_RESERVATION_CREATE_V003Request' => '\\StructType\\S_RESERVATION_CREATE_V003Request',
            'S_RESERVATION_CREATE_V003Response' => '\\StructType\\S_RESERVATION_CREATE_V003Response',
            'S_RESERVATION_CREATE_V004Request' => '\\StructType\\S_RESERVATION_CREATE_V004Request',
            'S_RESERVATION_CREATE_V004Response' => '\\StructType\\S_RESERVATION_CREATE_V004Response',
            'S_RESERVATION_CREATE_V005Request' => '\\StructType\\S_RESERVATION_CREATE_V005Request',
            'S_RESERVATION_CREATE_V005Response' => '\\StructType\\S_RESERVATION_CREATE_V005Response',
            'S_RESERVATION_CREATE_V006Request' => '\\StructType\\S_RESERVATION_CREATE_V006Request',
            'S_RESERVATION_CREATE_V006Response' => '\\StructType\\S_RESERVATION_CREATE_V006Response',
            'S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V001Request' => '\\StructType\\S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V001Request',
            'DepositInCreditWithForecast' => '\\StructType\\DepositInCreditWithForecast',
            'S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V001Response' => '\\StructType\\S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V001Response',
            'Output' => '\\StructType\\Output',
            'Deposit' => '\\StructType\\Deposit_1',
            'ResAccounts' => '\\StructType\\ResAccounts',
            'DepositAccount' => '\\StructType\\DepositAccount',
            'DepositInvoice' => '\\StructType\\DepositInvoice',
            'DepositCredit' => '\\StructType\\DepositCredit',
            'S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V002Request' => '\\StructType\\S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V002Request',
            'S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V002Response' => '\\StructType\\S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V002Response',
            'S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001Request' => '\\StructType\\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001Request',
            'DepositInWithForecast' => '\\StructType\\DepositInWithForecast',
            'S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001Response' => '\\StructType\\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001Response',
            'S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002Request' => '\\StructType\\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002Request',
            'S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002Response' => '\\StructType\\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002Response',
            'S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001Request' => '\\StructType\\S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001Request',
            'DepositInWithPayment' => '\\StructType\\DepositInWithPayment',
            'S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001Response' => '\\StructType\\S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001Response',
            'S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001Request' => '\\StructType\\S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001Request',
            'DepositInWithService' => '\\StructType\\DepositInWithService',
            'DepositInEntry' => '\\StructType\\DepositInEntry',
            'S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001Response' => '\\StructType\\S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001Response',
            'S_RESERVATION_DEPOSIT_AGREEMENT_GET_V001Request' => '\\StructType\\S_RESERVATION_DEPOSIT_AGREEMENT_GET_V001Request',
            'S_RESERVATION_DEPOSIT_AGREEMENT_GET_V001Response' => '\\StructType\\S_RESERVATION_DEPOSIT_AGREEMENT_GET_V001Response',
            'AGREEMENT1' => '\\StructType\\AGREEMENT1',
            'AGREEMENT2' => '\\StructType\\AGREEMENT2',
            'AGREEMENT3' => '\\StructType\\AGREEMENT3',
            'S_RESERVATION_DEPOSIT_AGREEMENT_SET_V001Request' => '\\StructType\\S_RESERVATION_DEPOSIT_AGREEMENT_SET_V001Request',
            'S_RESERVATION_DEPOSIT_AGREEMENT_SET_V001Response' => '\\StructType\\S_RESERVATION_DEPOSIT_AGREEMENT_SET_V001Response',
            'S_RESERVATION_FROZEN_RATE_DISCOUNT_V001Request' => '\\StructType\\S_RESERVATION_FROZEN_RATE_DISCOUNT_V001Request',
            'S_RESERVATION_FROZEN_RATE_DISCOUNT_V001Response' => '\\StructType\\S_RESERVATION_FROZEN_RATE_DISCOUNT_V001Response',
            'S_RESERVATION_GET_SERVICES_V01Request' => '\\StructType\\S_RESERVATION_GET_SERVICES_V01Request',
            'S_RESERVATION_GET_SERVICES_V01Response' => '\\StructType\\S_RESERVATION_GET_SERVICES_V01Response',
            'S_RESERVATION_GET_V001Request' => '\\StructType\\S_RESERVATION_GET_V001Request',
            'S_RESERVATION_GET_V001Response' => '\\StructType\\S_RESERVATION_GET_V001Response',
            'RESERVATIONPACKAGES' => '\\StructType\\RESERVATIONPACKAGES',
            'RESERVATIONPACKAGE' => '\\StructType\\RESERVATIONPACKAGE_1',
            'GUEST-ID' => '\\StructType\\GUEST_ID',
            'REGISTRATIONCARD' => '\\StructType\\REGISTRATIONCARD_1',
            'PERSONPACKAGES' => '\\StructType\\PERSONPACKAGES',
            'PERSONPACKAGE' => '\\StructType\\PERSONPACKAGE_1',
            'S_RESERVATION_GET_V002Request' => '\\StructType\\S_RESERVATION_GET_V002Request',
            'S_RESERVATION_GET_V002Response' => '\\StructType\\S_RESERVATION_GET_V002Response',
            'S_RESERVATION_GET_V003Request' => '\\StructType\\S_RESERVATION_GET_V003Request',
            'S_RESERVATION_GET_V003Response' => '\\StructType\\S_RESERVATION_GET_V003Response',
            'S_RESERVATION_GET_V004Request' => '\\StructType\\S_RESERVATION_GET_V004Request',
            'S_RESERVATION_GET_V004Response' => '\\StructType\\S_RESERVATION_GET_V004Response',
            'S_RESERVATION_GET_V005Request' => '\\StructType\\S_RESERVATION_GET_V005Request',
            'S_RESERVATION_GET_V005Response' => '\\StructType\\S_RESERVATION_GET_V005Response',
            'S_RESERVATION_GET_V006Request' => '\\StructType\\S_RESERVATION_GET_V006Request',
            'S_RESERVATION_GET_V006Response' => '\\StructType\\S_RESERVATION_GET_V006Response',
            'S_RESERVATION_GET_V007Request' => '\\StructType\\S_RESERVATION_GET_V007Request',
            'S_RESERVATION_GET_V007Response' => '\\StructType\\S_RESERVATION_GET_V007Response',
            'S_RESERVATION_GET_V008Request' => '\\StructType\\S_RESERVATION_GET_V008Request',
            'S_RESERVATION_GET_V008Response' => '\\StructType\\S_RESERVATION_GET_V008Response',
            'S_RESERVATION_GET_V009Request' => '\\StructType\\S_RESERVATION_GET_V009Request',
            'S_RESERVATION_GET_V009Response' => '\\StructType\\S_RESERVATION_GET_V009Response',
            'S_RESERVATION_GET_V010Request' => '\\StructType\\S_RESERVATION_GET_V010Request',
            'S_RESERVATION_GET_V010Response' => '\\StructType\\S_RESERVATION_GET_V010Response',
            'S_RESERVATION_GROUP_CREATE_V001Request' => '\\StructType\\S_RESERVATION_GROUP_CREATE_V001Request',
            'S_RESERVATION_GROUP_CREATE_V001Response' => '\\StructType\\S_RESERVATION_GROUP_CREATE_V001Response',
            'S_RESERVATION_GROUP_CREATE_V002Request' => '\\StructType\\S_RESERVATION_GROUP_CREATE_V002Request',
            'S_RESERVATION_GROUP_CREATE_V002Response' => '\\StructType\\S_RESERVATION_GROUP_CREATE_V002Response',
            'S_RESERVATION_GROUP_CREATE_V003Request' => '\\StructType\\S_RESERVATION_GROUP_CREATE_V003Request',
            'S_RESERVATION_GROUP_CREATE_V003Response' => '\\StructType\\S_RESERVATION_GROUP_CREATE_V003Response',
            'S_RESERVATION_GROUP_CREATE_V004Request' => '\\StructType\\S_RESERVATION_GROUP_CREATE_V004Request',
            'S_RESERVATION_GROUP_CREATE_V004Response' => '\\StructType\\S_RESERVATION_GROUP_CREATE_V004Response',
            'S_RESERVATION_GROUP_HANDLING_ACTIVATE_V001Request' => '\\StructType\\S_RESERVATION_GROUP_HANDLING_ACTIVATE_V001Request',
            'S_RESERVATION_GROUP_HANDLING_ACTIVATE_V001Response' => '\\StructType\\S_RESERVATION_GROUP_HANDLING_ACTIVATE_V001Response',
            'S_RESERVATION_GROUP_RESERVATION_ADD_V001Request' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_ADD_V001Request',
            'S_RESERVATION_GROUP_RESERVATION_ADD_V001Response' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_ADD_V001Response',
            'ResNewGroupReservation' => '\\StructType\\ResNewGroupReservation',
            'S_RESERVATION_GROUP_RESERVATION_ADD_V002Request' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_ADD_V002Request',
            'ResGroup' => '\\StructType\\ResGroup',
            'ResNewGroupReservationDummy' => '\\StructType\\ResNewGroupReservationDummy',
            'S_RESERVATION_GROUP_RESERVATION_ADD_V002Response' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_ADD_V002Response',
            'RecentCreated' => '\\StructType\\RecentCreated',
            'S_RESERVATION_GROUP_RESERVATION_ADD_V003Request' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_ADD_V003Request',
            'RESERVATION-GROUP' => '\\StructType\\RESERVATION_GROUP',
            'S_RESERVATION_GROUP_RESERVATION_ADD_V003Response' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_ADD_V003Response',
            'S_RESERVATION_GROUP_RESERVATION_GET_V001Request' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_GET_V001Request',
            'S_RESERVATION_GROUP_RESERVATION_GET_V001Response' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_GET_V001Response',
            'ResGroupReservations' => '\\StructType\\ResGroupReservations',
            'ResGroupReservation' => '\\StructType\\ResGroupReservation',
            'S_RESERVATION_GROUP_RESERVATION_SET_CANCEL_V001Request' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_SET_CANCEL_V001Request',
            'S_RESERVATION_GROUP_RESERVATION_SET_CANCEL_V001Response' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_SET_CANCEL_V001Response',
            'S_RESERVATION_GROUP_RESERVATION_SET_NOSHOW_V001Request' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_SET_NOSHOW_V001Request',
            'S_RESERVATION_GROUP_RESERVATION_SET_NOSHOW_V001Response' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_SET_NOSHOW_V001Response',
            'S_RESERVATION_GROUP_RESERVATION_SET_RELEASE_V001Request' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_SET_RELEASE_V001Request',
            'S_RESERVATION_GROUP_RESERVATION_SET_RELEASE_V001Response' => '\\StructType\\S_RESERVATION_GROUP_RESERVATION_SET_RELEASE_V001Response',
            'S_RESERVATION_MODIFY_V001Request' => '\\StructType\\S_RESERVATION_MODIFY_V001Request',
            'S_RESERVATION_MODIFY_V001Response' => '\\StructType\\S_RESERVATION_MODIFY_V001Response',
            'S_RESERVATION_MODIFY_V002Request' => '\\StructType\\S_RESERVATION_MODIFY_V002Request',
            'S_RESERVATION_MODIFY_V002Response' => '\\StructType\\S_RESERVATION_MODIFY_V002Response',
            'S_RESERVATION_MODIFY_V003Request' => '\\StructType\\S_RESERVATION_MODIFY_V003Request',
            'S_RESERVATION_MODIFY_V003Response' => '\\StructType\\S_RESERVATION_MODIFY_V003Response',
            'S_RESERVATION_MODIFY_V004Request' => '\\StructType\\S_RESERVATION_MODIFY_V004Request',
            'S_RESERVATION_MODIFY_V004Response' => '\\StructType\\S_RESERVATION_MODIFY_V004Response',
            'S_RESERVATION_MODIFY_V005Request' => '\\StructType\\S_RESERVATION_MODIFY_V005Request',
            'S_RESERVATION_MODIFY_V005Response' => '\\StructType\\S_RESERVATION_MODIFY_V005Response',
            'S_RESERVATION_MODIFY_V006Request' => '\\StructType\\S_RESERVATION_MODIFY_V006Request',
            'S_RESERVATION_MODIFY_V006Response' => '\\StructType\\S_RESERVATION_MODIFY_V006Response',
            'S_RESERVATION_MODIFY_V007Request' => '\\StructType\\S_RESERVATION_MODIFY_V007Request',
            'S_RESERVATION_MODIFY_V007Response' => '\\StructType\\S_RESERVATION_MODIFY_V007Response',
            'S_RESERVATION_PAYMENTINSTRUCTION_SET_V001Request' => '\\StructType\\S_RESERVATION_PAYMENTINSTRUCTION_SET_V001Request',
            'reservation' => '\\StructType\\Reservation_2',
            'guestPaymentInstruction' => '\\StructType\\GuestPaymentInstruction',
            'clientPaymentInstruction' => '\\StructType\\ClientPaymentInstruction',
            'groupPaymentInstruction' => '\\StructType\\GroupPaymentInstruction',
            'S_RESERVATION_PAYMENTINSTRUCTION_SET_V001Response' => '\\StructType\\S_RESERVATION_PAYMENTINSTRUCTION_SET_V001Response',
            'S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V001Request' => '\\StructType\\S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V001Request',
            'S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V001Response' => '\\StructType\\S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V001Response',
            'INVOICE-ADDRESS' => '\\StructType\\INVOICE_ADDRESS',
            'GROUP' => '\\StructType\\GROUP',
            'S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V002Request' => '\\StructType\\S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V002Request',
            'S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V002Response' => '\\StructType\\S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V002Response',
            'S_RESERVATION_PAYMENT_INSTRUCTIONS_SET_V002Request' => '\\StructType\\S_RESERVATION_PAYMENT_INSTRUCTIONS_SET_V002Request',
            'S_RESERVATION_PAYMENT_INSTRUCTIONS_SET_V002Response' => '\\StructType\\S_RESERVATION_PAYMENT_INSTRUCTIONS_SET_V002Response',
            'S_RESERVATION_PREVIEW_POSTINGS_V001Request' => '\\StructType\\S_RESERVATION_PREVIEW_POSTINGS_V001Request',
            'PAYMENT-INSTRUCTION' => '\\StructType\\PAYMENT_INSTRUCTION',
            'S_RESERVATION_PREVIEW_POSTINGS_V001Response' => '\\StructType\\S_RESERVATION_PREVIEW_POSTINGS_V001Response',
            'RESERVATION-PREVIEW' => '\\StructType\\RESERVATION_PREVIEW',
            'SERVICE-POSTINGS' => '\\StructType\\SERVICE_POSTINGS',
            'SERVICE-POSTING' => '\\StructType\\SERVICE_POSTING',
            'S_RESERVATION_RATE_FREEZE_V001Request' => '\\StructType\\S_RESERVATION_RATE_FREEZE_V001Request',
            'S_RESERVATION_RATE_FREEZE_V001Response' => '\\StructType\\S_RESERVATION_RATE_FREEZE_V001Response',
            'S_RESERVATION_RATE_UNFREEZE_V001Request' => '\\StructType\\S_RESERVATION_RATE_UNFREEZE_V001Request',
            'S_RESERVATION_RATE_UNFREEZE_V001Response' => '\\StructType\\S_RESERVATION_RATE_UNFREEZE_V001Response',
            'S_RESERVATION_RELEASE_ROOM_V001Request' => '\\StructType\\S_RESERVATION_RELEASE_ROOM_V001Request',
            'S_RESERVATION_RELEASE_ROOM_V001Response' => '\\StructType\\S_RESERVATION_RELEASE_ROOM_V001Response',
            'S_RESERVATION_REMOVE_SERVICE_V001Request' => '\\StructType\\S_RESERVATION_REMOVE_SERVICE_V001Request',
            'S_RESERVATION_REMOVE_SERVICE_V001Response' => '\\StructType\\S_RESERVATION_REMOVE_SERVICE_V001Response',
            'S_RESERVATION_ROOM_ADD_V001Request' => '\\StructType\\S_RESERVATION_ROOM_ADD_V001Request',
            'S_RESERVATION_ROOM_ADD_V001Response' => '\\StructType\\S_RESERVATION_ROOM_ADD_V001Response',
            'S_RESERVATION_ROOM_AUTO_ASSIGN_V001Request' => '\\StructType\\S_RESERVATION_ROOM_AUTO_ASSIGN_V001Request',
            'S_RESERVATION_ROOM_AUTO_ASSIGN_V001Response' => '\\StructType\\S_RESERVATION_ROOM_AUTO_ASSIGN_V001Response',
            'S_RESERVATION_ROOM_AUTO_ASSIGN_V002Request' => '\\StructType\\S_RESERVATION_ROOM_AUTO_ASSIGN_V002Request',
            'S_RESERVATION_ROOM_AUTO_ASSIGN_V002Response' => '\\StructType\\S_RESERVATION_ROOM_AUTO_ASSIGN_V002Response',
            'S_RESERVATION_ROOM_RELEASE_V001Request' => '\\StructType\\S_RESERVATION_ROOM_RELEASE_V001Request',
            'S_RESERVATION_ROOM_RELEASE_V001Response' => '\\StructType\\S_RESERVATION_ROOM_RELEASE_V001Response',
            'S_RESERVATION_SEARCH_V001Request' => '\\StructType\\S_RESERVATION_SEARCH_V001Request',
            'S_RESERVATION_SEARCH_V001Response' => '\\StructType\\S_RESERVATION_SEARCH_V001Response',
            'S_RESERVATION_SEARCH_V002Request' => '\\StructType\\S_RESERVATION_SEARCH_V002Request',
            'RESERVATIONSEARCH' => '\\StructType\\RESERVATIONSEARCH_1',
            'S_RESERVATION_SEARCH_V002Response' => '\\StructType\\S_RESERVATION_SEARCH_V002Response',
            'S_RESERVATION_SEARCH_V003Request' => '\\StructType\\S_RESERVATION_SEARCH_V003Request',
            'S_RESERVATION_SEARCH_V003Response' => '\\StructType\\S_RESERVATION_SEARCH_V003Response',
            'S_RESERVATION_SEARCH_V004Request' => '\\StructType\\S_RESERVATION_SEARCH_V004Request',
            'S_RESERVATION_SEARCH_V004Response' => '\\StructType\\S_RESERVATION_SEARCH_V004Response',
            'S_RESERVATION_SEARCH_V005Request' => '\\StructType\\S_RESERVATION_SEARCH_V005Request',
            'S_RESERVATION_SEARCH_V005Response' => '\\StructType\\S_RESERVATION_SEARCH_V005Response',
            'S_RESERVATION_SERVICE_ADD_V001Request' => '\\StructType\\S_RESERVATION_SERVICE_ADD_V001Request',
            'S_RESERVATION_SERVICE_ADD_V001Response' => '\\StructType\\S_RESERVATION_SERVICE_ADD_V001Response',
            'S_RESERVATION_SERVICE_FORCE_MODIFY_V001Request' => '\\StructType\\S_RESERVATION_SERVICE_FORCE_MODIFY_V001Request',
            'RESERVATION-SERVICE' => '\\StructType\\RESERVATION_SERVICE',
            'S_RESERVATION_SERVICE_FORCE_MODIFY_V001Response' => '\\StructType\\S_RESERVATION_SERVICE_FORCE_MODIFY_V001Response',
            'S_RESERVATION_SERVICE_GET_V001Request' => '\\StructType\\S_RESERVATION_SERVICE_GET_V001Request',
            'S_RESERVATION_SERVICE_GET_V001Response' => '\\StructType\\S_RESERVATION_SERVICE_GET_V001Response',
            'S_RESERVATION_SERVICE_GET_V002Request' => '\\StructType\\S_RESERVATION_SERVICE_GET_V002Request',
            'S_RESERVATION_SERVICE_GET_V002Response' => '\\StructType\\S_RESERVATION_SERVICE_GET_V002Response',
            'S_RESERVATION_SERVICE_MANUAL_RATE_ADD_V001Request' => '\\StructType\\S_RESERVATION_SERVICE_MANUAL_RATE_ADD_V001Request',
            'S_RESERVATION_SERVICE_MANUAL_RATE_ADD_V001Response' => '\\StructType\\S_RESERVATION_SERVICE_MANUAL_RATE_ADD_V001Response',
            'S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Request' => '\\StructType\\S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Request',
            'S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Response' => '\\StructType\\S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Response',
            'S_RESERVATION_SERVICE_MANUAL_RATE_MODIFY_V001Request' => '\\StructType\\S_RESERVATION_SERVICE_MANUAL_RATE_MODIFY_V001Request',
            'S_RESERVATION_SERVICE_MANUAL_RATE_MODIFY_V001Response' => '\\StructType\\S_RESERVATION_SERVICE_MANUAL_RATE_MODIFY_V001Response',
            'S_RESERVATION_SERVICE_MODIFY_V001Request' => '\\StructType\\S_RESERVATION_SERVICE_MODIFY_V001Request',
            'S_RESERVATION_SERVICE_MODIFY_V001Response' => '\\StructType\\S_RESERVATION_SERVICE_MODIFY_V001Response',
            'S_RESERVATION_SERVICE_REMOVE_V001Request' => '\\StructType\\S_RESERVATION_SERVICE_REMOVE_V001Request',
            'S_RESERVATION_SERVICE_REMOVE_V001Response' => '\\StructType\\S_RESERVATION_SERVICE_REMOVE_V001Response',
            'S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request' => '\\StructType\\S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request',
            'S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Response' => '\\StructType\\S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Response',
            'S_RESERVATION_TOKEN_ADD_V001Request' => '\\StructType\\S_RESERVATION_TOKEN_ADD_V001Request',
            'S_RESERVATION_TOKEN_ADD_V001Response' => '\\StructType\\S_RESERVATION_TOKEN_ADD_V001Response',
            'S_RESERVATION_V001Request' => '\\StructType\\S_RESERVATION_V001Request',
            'S_RESERVATION_V001Response' => '\\StructType\\S_RESERVATION_V001Response',
            'TravelAgency' => '\\StructType\\TravelAgency_1',
            'TravelPoint' => '\\StructType\\TravelPoint_1',
            'S_RESERVATION_V002Request' => '\\StructType\\S_RESERVATION_V002Request',
            'S_RESERVATION_V002Response' => '\\StructType\\S_RESERVATION_V002Response',
            'S_RESERVATION_V003Request' => '\\StructType\\S_RESERVATION_V003Request',
            'S_RESERVATION_V003Response' => '\\StructType\\S_RESERVATION_V003Response',
            'S_ROOMINGLIST_ASSIGN_ROOM_V001Request' => '\\StructType\\S_ROOMINGLIST_ASSIGN_ROOM_V001Request',
            'RoominglistSearch' => '\\StructType\\RoominglistSearch',
            'S_ROOMINGLIST_ASSIGN_ROOM_V001Response' => '\\StructType\\S_ROOMINGLIST_ASSIGN_ROOM_V001Response',
            'S_ROOMINGLIST_AUTO_ASSIGN_ROOM_V001Request' => '\\StructType\\S_ROOMINGLIST_AUTO_ASSIGN_ROOM_V001Request',
            'S_ROOMINGLIST_AUTO_ASSIGN_ROOM_V001Response' => '\\StructType\\S_ROOMINGLIST_AUTO_ASSIGN_ROOM_V001Response',
            'S_ROOMINGLIST_CHECK_IN_V001Request' => '\\StructType\\S_ROOMINGLIST_CHECK_IN_V001Request',
            'S_ROOMINGLIST_CHECK_IN_V001Response' => '\\StructType\\S_ROOMINGLIST_CHECK_IN_V001Response',
            'S_ROOMINGLIST_CHECK_IN_V002Request' => '\\StructType\\S_ROOMINGLIST_CHECK_IN_V002Request',
            'S_ROOMINGLIST_CHECK_IN_V002Response' => '\\StructType\\S_ROOMINGLIST_CHECK_IN_V002Response',
            'S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001Request' => '\\StructType\\S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001Request',
            'S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001Response' => '\\StructType\\S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001Response',
            'S_ROOMINGLIST_PRE_CHECK_IN_V001Request' => '\\StructType\\S_ROOMINGLIST_PRE_CHECK_IN_V001Request',
            'S_ROOMINGLIST_PRE_CHECK_IN_V001Response' => '\\StructType\\S_ROOMINGLIST_PRE_CHECK_IN_V001Response',
            'S_ROOMINGLIST_PRE_CHECK_OUT_V001Request' => '\\StructType\\S_ROOMINGLIST_PRE_CHECK_OUT_V001Request',
            'S_ROOMINGLIST_PRE_CHECK_OUT_V001Response' => '\\StructType\\S_ROOMINGLIST_PRE_CHECK_OUT_V001Response',
            'S_ROOMINGLIST_RELEASE_ROOM_V001Request' => '\\StructType\\S_ROOMINGLIST_RELEASE_ROOM_V001Request',
            'S_ROOMINGLIST_RELEASE_ROOM_V001Response' => '\\StructType\\S_ROOMINGLIST_RELEASE_ROOM_V001Response',
            'S_ROOMINGLIST_ROOM_ASSIGN_V001Request' => '\\StructType\\S_ROOMINGLIST_ROOM_ASSIGN_V001Request',
            'S_ROOMINGLIST_ROOM_ASSIGN_V001Response' => '\\StructType\\S_ROOMINGLIST_ROOM_ASSIGN_V001Response',
            'S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V001Request' => '\\StructType\\S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V001Request',
            'S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V001Response' => '\\StructType\\S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V001Response',
            'S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V002Request' => '\\StructType\\S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V002Request',
            'S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V002Response' => '\\StructType\\S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V002Response',
            'S_ROOMINGLIST_ROOM_DELETE_V001Request' => '\\StructType\\S_ROOMINGLIST_ROOM_DELETE_V001Request',
            'S_ROOMINGLIST_ROOM_DELETE_V001Response' => '\\StructType\\S_ROOMINGLIST_ROOM_DELETE_V001Response',
            'S_ROOMINGLIST_ROOM_FORECAST_GET_V001Request' => '\\StructType\\S_ROOMINGLIST_ROOM_FORECAST_GET_V001Request',
            'ROOMINGLISTSEARCH' => '\\StructType\\ROOMINGLISTSEARCH_1',
            'S_ROOMINGLIST_ROOM_FORECAST_GET_V001Response' => '\\StructType\\S_ROOMINGLIST_ROOM_FORECAST_GET_V001Response',
            'S_ROOMINGLIST_ROOM_RELEASE_V001Request' => '\\StructType\\S_ROOMINGLIST_ROOM_RELEASE_V001Request',
            'S_ROOMINGLIST_ROOM_RELEASE_V001Response' => '\\StructType\\S_ROOMINGLIST_ROOM_RELEASE_V001Response',
            'S_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001Request' => '\\StructType\\S_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001Request',
            'S_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001Response' => '\\StructType\\S_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001Response',
            'S_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Request' => '\\StructType\\S_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Request',
            'S_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Response' => '\\StructType\\S_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Response',
            'S_ROOM_BOOKING_OOI_LOCK_V001Request' => '\\StructType\\S_ROOM_BOOKING_OOI_LOCK_V001Request',
            'RoomBookingFree' => '\\StructType\\RoomBookingFree',
            'RoomBookingStateModifyOOI' => '\\StructType\\RoomBookingStateModifyOOI',
            'S_ROOM_BOOKING_OOI_LOCK_V001Response' => '\\StructType\\S_ROOM_BOOKING_OOI_LOCK_V001Response',
            'S_ROOM_BOOKING_OOI_UNLOCK_V001Request' => '\\StructType\\S_ROOM_BOOKING_OOI_UNLOCK_V001Request',
            'RoomBookingOOI' => '\\StructType\\RoomBookingOOI',
            'S_ROOM_BOOKING_OOI_UNLOCK_V001Response' => '\\StructType\\S_ROOM_BOOKING_OOI_UNLOCK_V001Response',
            'S_ROOM_BOOKING_OOI_UNLOCK_V002Request' => '\\StructType\\S_ROOM_BOOKING_OOI_UNLOCK_V002Request',
            'S_ROOM_BOOKING_OOI_UNLOCK_V002Response' => '\\StructType\\S_ROOM_BOOKING_OOI_UNLOCK_V002Response',
            'S_ROOM_BOOKING_OOO_LOCK_V001Request' => '\\StructType\\S_ROOM_BOOKING_OOO_LOCK_V001Request',
            'RoomBookingStateModifyOOO' => '\\StructType\\RoomBookingStateModifyOOO',
            'S_ROOM_BOOKING_OOO_LOCK_V001Response' => '\\StructType\\S_ROOM_BOOKING_OOO_LOCK_V001Response',
            'S_ROOM_BOOKING_OOO_UNLOCK_V001Request' => '\\StructType\\S_ROOM_BOOKING_OOO_UNLOCK_V001Request',
            'RoomBookingOOS' => '\\StructType\\RoomBookingOOS',
            'S_ROOM_BOOKING_OOO_UNLOCK_V001Response' => '\\StructType\\S_ROOM_BOOKING_OOO_UNLOCK_V001Response',
            'S_ROOM_BOOKING_OOO_UNLOCK_V002Request' => '\\StructType\\S_ROOM_BOOKING_OOO_UNLOCK_V002Request',
            'RoomBookingOOO' => '\\StructType\\RoomBookingOOO',
            'S_ROOM_BOOKING_OOO_UNLOCK_V002Response' => '\\StructType\\S_ROOM_BOOKING_OOO_UNLOCK_V002Response',
            'S_ROOM_BOOKING_OOS_LOCK_V001Request' => '\\StructType\\S_ROOM_BOOKING_OOS_LOCK_V001Request',
            'RoomBookingStateModifyOOS' => '\\StructType\\RoomBookingStateModifyOOS',
            'S_ROOM_BOOKING_OOS_LOCK_V001Response' => '\\StructType\\S_ROOM_BOOKING_OOS_LOCK_V001Response',
            'S_ROOM_BOOKING_OOS_UNLOCK_V001Request' => '\\StructType\\S_ROOM_BOOKING_OOS_UNLOCK_V001Request',
            'S_ROOM_BOOKING_OOS_UNLOCK_V001Response' => '\\StructType\\S_ROOM_BOOKING_OOS_UNLOCK_V001Response',
            'S_ROOM_BOOKING_OOS_UNLOCK_V002Request' => '\\StructType\\S_ROOM_BOOKING_OOS_UNLOCK_V002Request',
            'S_ROOM_BOOKING_OOS_UNLOCK_V002Response' => '\\StructType\\S_ROOM_BOOKING_OOS_UNLOCK_V002Response',
            'S_ROOM_BOOKING_STATE_V001Request' => '\\StructType\\S_ROOM_BOOKING_STATE_V001Request',
            'S_ROOM_BOOKING_STATE_V001Response' => '\\StructType\\S_ROOM_BOOKING_STATE_V001Response',
            'bookingstate' => '\\StructType\\Bookingstate',
            'S_ROOM_BOOKING_STATE_V002Request' => '\\StructType\\S_ROOM_BOOKING_STATE_V002Request',
            'S_ROOM_BOOKING_STATE_V002Response' => '\\StructType\\S_ROOM_BOOKING_STATE_V002Response',
            'S_ROOM_BOOKING_STATE_V01Request' => '\\StructType\\S_ROOM_BOOKING_STATE_V01Request',
            'S_ROOM_BOOKING_STATE_V01Response' => '\\StructType\\S_ROOM_BOOKING_STATE_V01Response',
            'S_ROOM_CATEGORY_MASTER_FILE_COMMENT_GET_V001Request' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_COMMENT_GET_V001Request',
            'S_ROOM_CATEGORY_MASTER_FILE_COMMENT_GET_V001Response' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_COMMENT_GET_V001Response',
            'S_ROOM_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Request' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Request',
            'S_ROOM_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Response' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Response',
            'S_ROOM_CATEGORY_MASTER_FILE_GET_V001Request' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_GET_V001Request',
            'S_ROOM_CATEGORY_MASTER_FILE_GET_V001Response' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_GET_V001Response',
            'S_ROOM_CATEGORY_MASTER_FILE_INTERNET_GET_V001Request' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_INTERNET_GET_V001Request',
            'S_ROOM_CATEGORY_MASTER_FILE_INTERNET_GET_V001Response' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_INTERNET_GET_V001Response',
            'S_ROOM_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Request' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Request',
            'S_ROOM_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Response' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Response',
            'S_ROOM_CATEGORY_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request',
            'RoomCategoryMasterFileSearch' => '\\StructType\\RoomCategoryMasterFileSearch',
            'S_ROOM_CATEGORY_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response',
            'RoomCategoryMasterFiles' => '\\StructType\\RoomCategoryMasterFiles',
            'RoomCategoryMasterFile' => '\\StructType\\RoomCategoryMasterFile',
            'MultiLangComments2' => '\\StructType\\MultiLangComments2',
            'MultiLangComment2' => '\\StructType\\MultiLangComment2',
            'S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Request' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Request',
            'S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Response' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Response',
            'S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Request' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Request',
            'S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Response' => '\\StructType\\S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Response',
            'S_ROOM_CHANGE_CLEANING_STATUS_V01Request' => '\\StructType\\S_ROOM_CHANGE_CLEANING_STATUS_V01Request',
            'S_ROOM_CHANGE_CLEANING_STATUS_V01Response' => '\\StructType\\S_ROOM_CHANGE_CLEANING_STATUS_V01Response',
            'S_ROOM_CHANGE_CLEANUNG_STATUS_V01Request' => '\\StructType\\S_ROOM_CHANGE_CLEANUNG_STATUS_V01Request',
            'RoomOject' => '\\StructType\\RoomOject',
            'S_ROOM_CHANGE_CLEANUNG_STATUS_V01Response' => '\\StructType\\S_ROOM_CHANGE_CLEANUNG_STATUS_V01Response',
            'S_ROOM_CHANGE_MAINTENANCE_STATUS_V01Request' => '\\StructType\\S_ROOM_CHANGE_MAINTENANCE_STATUS_V01Request',
            'S_ROOM_CHANGE_MAINTENANCE_STATUS_V01Response' => '\\StructType\\S_ROOM_CHANGE_MAINTENANCE_STATUS_V01Response',
            'S_ROOM_CHANGE_STATE_V01Request' => '\\StructType\\S_ROOM_CHANGE_STATE_V01Request',
            'S_ROOM_CHANGE_STATE_V01Response' => '\\StructType\\S_ROOM_CHANGE_STATE_V01Response',
            'S_ROOM_CLEANING_STATUS_CHANGE_V001Request' => '\\StructType\\S_ROOM_CLEANING_STATUS_CHANGE_V001Request',
            'S_ROOM_CLEANING_STATUS_CHANGE_V001Response' => '\\StructType\\S_ROOM_CLEANING_STATUS_CHANGE_V001Response',
            'S_ROOM_FREE_ROOM_SEARCH_V001Request' => '\\StructType\\S_ROOM_FREE_ROOM_SEARCH_V001Request',
            'S_ROOM_FREE_ROOM_SEARCH_V001Response' => '\\StructType\\S_ROOM_FREE_ROOM_SEARCH_V001Response',
            'S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Request' => '\\StructType\\S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Request',
            'S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Response' => '\\StructType\\S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Response',
            'S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Request' => '\\StructType\\S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Request',
            'S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Response' => '\\StructType\\S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Response',
            'S_ROOM_GET_HOUSKEEPING_STATE_MOBILE_V001Request' => '\\StructType\\S_ROOM_GET_HOUSKEEPING_STATE_MOBILE_V001Request',
            'S_ROOM_GET_HOUSKEEPING_STATE_MOBILE_V001Response' => '\\StructType\\S_ROOM_GET_HOUSKEEPING_STATE_MOBILE_V001Response',
            'S_ROOM_GET_HOUSKEEPING_STATE_V001Request' => '\\StructType\\S_ROOM_GET_HOUSKEEPING_STATE_V001Request',
            'S_ROOM_GET_HOUSKEEPING_STATE_V001Response' => '\\StructType\\S_ROOM_GET_HOUSKEEPING_STATE_V001Response',
            'RoomHousekeepingStatus' => '\\StructType\\RoomHousekeepingStatus',
            'S_ROOM_GET_MAINENANCE_STATE_V001Request' => '\\StructType\\S_ROOM_GET_MAINENANCE_STATE_V001Request',
            'S_ROOM_GET_MAINENANCE_STATE_V001Response' => '\\StructType\\S_ROOM_GET_MAINENANCE_STATE_V001Response',
            'RoomMaintenanceStatus' => '\\StructType\\RoomMaintenanceStatus',
            'S_ROOM_GET_MAINTENANCE_STATE_MOBILE_V001Request' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_MOBILE_V001Request',
            'S_ROOM_GET_MAINTENANCE_STATE_MOBILE_V001Response' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_MOBILE_V001Response',
            'S_ROOM_GET_MAINTENANCE_STATE_V002Request' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_V002Request',
            'S_ROOM_GET_MAINTENANCE_STATE_V002Response' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_V002Response',
            'S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V001Request' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V001Request',
            'S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V001Response' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V001Response',
            'S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V002Request' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V002Request',
            'S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V002Response' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V002Response',
            'S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Request' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Request',
            'S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Response' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Response',
            'S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V002Request' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V002Request',
            'S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V002Response' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V002Response',
            'S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Request' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Request',
            'S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Response' => '\\StructType\\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Response',
            'S_ROOM_HOUSKEEPING_STATE_GET_V001Request' => '\\StructType\\S_ROOM_HOUSKEEPING_STATE_GET_V001Request',
            'S_ROOM_HOUSKEEPING_STATE_GET_V001Response' => '\\StructType\\S_ROOM_HOUSKEEPING_STATE_GET_V001Response',
            'S_ROOM_HOUSKEEPING_STATE_MOBILE_GET_V001Request' => '\\StructType\\S_ROOM_HOUSKEEPING_STATE_MOBILE_GET_V001Request',
            'S_ROOM_HOUSKEEPING_STATE_MOBILE_GET_V001Response' => '\\StructType\\S_ROOM_HOUSKEEPING_STATE_MOBILE_GET_V001Response',
            'S_ROOM_LOCK_STATE_SEARCH_V001Request' => '\\StructType\\S_ROOM_LOCK_STATE_SEARCH_V001Request',
            'S_ROOM_LOCK_STATE_SEARCH_V001Response' => '\\StructType\\S_ROOM_LOCK_STATE_SEARCH_V001Response',
            'RoomFree' => '\\StructType\\RoomFree',
            'RoomOOS' => '\\StructType\\RoomOOS',
            'RoomOOO' => '\\StructType\\RoomOOO',
            'RoomOOI' => '\\StructType\\RoomOOI',
            'S_ROOM_MAINTENANCE_STATE_GET_V001Request' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_GET_V001Request',
            'S_ROOM_MAINTENANCE_STATE_GET_V001Response' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_GET_V001Response',
            'S_ROOM_MAINTENANCE_STATE_GET_V002Request' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_GET_V002Request',
            'S_ROOM_MAINTENANCE_STATE_GET_V002Response' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_GET_V002Response',
            'S_ROOM_MAINTENANCE_STATE_GET_V003Request' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_GET_V003Request',
            'S_ROOM_MAINTENANCE_STATE_GET_V003Response' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_GET_V003Response',
            'S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V001Request' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V001Request',
            'S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V001Response' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V001Response',
            'S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V002Request' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V002Request',
            'S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V002Response' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V002Response',
            'S_ROOM_MAINTENANCE_STATE_RESET_V001Request' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_RESET_V001Request',
            'S_ROOM_MAINTENANCE_STATE_RESET_V001Response' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_RESET_V001Response',
            'S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Request' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Request',
            'S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Response' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Response',
            'S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V002Request' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V002Request',
            'S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V002Response' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V002Response',
            'S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Request' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Request',
            'S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Response' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Response',
            'S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V001Request' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V001Request',
            'S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V001Response' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V001Response',
            'S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V002Request' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V002Request',
            'S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V002Response' => '\\StructType\\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V002Response',
            'S_ROOM_MAINTENANCE_STATUS_CHANGE_V001Request' => '\\StructType\\S_ROOM_MAINTENANCE_STATUS_CHANGE_V001Request',
            'S_ROOM_MAINTENANCE_STATUS_CHANGE_V001Response' => '\\StructType\\S_ROOM_MAINTENANCE_STATUS_CHANGE_V001Response',
            'S_ROOM_RESET_MAINTENANCE_STATE_V001Request' => '\\StructType\\S_ROOM_RESET_MAINTENANCE_STATE_V001Request',
            'S_ROOM_RESET_MAINTENANCE_STATE_V001Response' => '\\StructType\\S_ROOM_RESET_MAINTENANCE_STATE_V001Response',
            'S_ROOM_STATE_CHANGE_V001Request' => '\\StructType\\S_ROOM_STATE_CHANGE_V001Request',
            'S_ROOM_STATE_CHANGE_V001Response' => '\\StructType\\S_ROOM_STATE_CHANGE_V001Response',
            'S_ROOM_STATE_SEARCH_V002Request' => '\\StructType\\S_ROOM_STATE_SEARCH_V002Request',
            'S_ROOM_STATE_SEARCH_V002Response' => '\\StructType\\S_ROOM_STATE_SEARCH_V002Response',
            'S_ROOM_STATE_SEARCH_V003Request' => '\\StructType\\S_ROOM_STATE_SEARCH_V003Request',
            'S_ROOM_STATE_SEARCH_V003Response' => '\\StructType\\S_ROOM_STATE_SEARCH_V003Response',
            'S_ROOM_STATE_SEARCH_V01Request' => '\\StructType\\S_ROOM_STATE_SEARCH_V01Request',
            'S_ROOM_STATE_SEARCH_V01Response' => '\\StructType\\S_ROOM_STATE_SEARCH_V01Response',
            'S_SALESPOTENTIAL_CREATE_V001Request' => '\\StructType\\S_SALESPOTENTIAL_CREATE_V001Request',
            'SALESPOTENTIAL' => '\\StructType\\SALESPOTENTIAL',
            'S_SALESPOTENTIAL_CREATE_V001Response' => '\\StructType\\S_SALESPOTENTIAL_CREATE_V001Response',
            'S_SALESPOTENTIAL_GET_V001Request' => '\\StructType\\S_SALESPOTENTIAL_GET_V001Request',
            'S_SALESPOTENTIAL_GET_V001Response' => '\\StructType\\S_SALESPOTENTIAL_GET_V001Response',
            'S_SALESPOTENTIAL_GUEST_CREATE_V001Request' => '\\StructType\\S_SALESPOTENTIAL_GUEST_CREATE_V001Request',
            'S_SALESPOTENTIAL_GUEST_CREATE_V001Response' => '\\StructType\\S_SALESPOTENTIAL_GUEST_CREATE_V001Response',
            'S_SALESPOTENTIAL_MODIFY_V001Request' => '\\StructType\\S_SALESPOTENTIAL_MODIFY_V001Request',
            'S_SALESPOTENTIAL_MODIFY_V001Response' => '\\StructType\\S_SALESPOTENTIAL_MODIFY_V001Response',
            'S_SALESPOTENTIAL_SEARCH_V001Request' => '\\StructType\\S_SALESPOTENTIAL_SEARCH_V001Request',
            'SALESPOTENTIAL-SEARCH' => '\\StructType\\SALESPOTENTIAL_SEARCH',
            'S_SALESPOTENTIAL_SEARCH_V001Response' => '\\StructType\\S_SALESPOTENTIAL_SEARCH_V001Response',
            'S_SERVICES_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request' => '\\StructType\\S_SERVICES_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request',
            'ServiceMasterFileSearch' => '\\StructType\\ServiceMasterFileSearch',
            'S_SERVICES_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response' => '\\StructType\\S_SERVICES_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response',
            'ServiceMasterFiles' => '\\StructType\\ServiceMasterFiles',
            'ServiceMasterFile' => '\\StructType\\ServiceMasterFile',
            'S_SERVICES_SEARCH_V001Request' => '\\StructType\\S_SERVICES_SEARCH_V001Request',
            'S_SERVICES_SEARCH_V001Response' => '\\StructType\\S_SERVICES_SEARCH_V001Response',
            'S_SERVICES_SEARCH_V002Request' => '\\StructType\\S_SERVICES_SEARCH_V002Request',
            'S_SERVICES_SEARCH_V002Response' => '\\StructType\\S_SERVICES_SEARCH_V002Response',
            'S_SERVICE_MAPPING_GET_V001Request' => '\\StructType\\S_SERVICE_MAPPING_GET_V001Request',
            'S_SERVICE_MAPPING_GET_V001Response' => '\\StructType\\S_SERVICE_MAPPING_GET_V001Response',
            'S_SERVICE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request' => '\\StructType\\S_SERVICE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request',
            'S_SERVICE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response' => '\\StructType\\S_SERVICE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response',
            'S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V001Request' => '\\StructType\\S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V001Request',
            'SERVICERESTRICTION-SEARCH' => '\\StructType\\SERVICERESTRICTION_SEARCH',
            'S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V001Response' => '\\StructType\\S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V001Response',
            'SERVICERESTRICTIONS' => '\\StructType\\SERVICERESTRICTIONS',
            'SERVICERESTRICTION' => '\\StructType\\SERVICERESTRICTION',
            'S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V002Request' => '\\StructType\\S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V002Request',
            'S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V002Response' => '\\StructType\\S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V002Response',
            'S_SERVICE_SEARCH_V001Request' => '\\StructType\\S_SERVICE_SEARCH_V001Request',
            'S_SERVICE_SEARCH_V001Response' => '\\StructType\\S_SERVICE_SEARCH_V001Response',
            'S_SERVICE_SEARCH_V002Request' => '\\StructType\\S_SERVICE_SEARCH_V002Request',
            'S_SERVICE_SEARCH_V002Response' => '\\StructType\\S_SERVICE_SEARCH_V002Response',
            'S_SUITE_CATEGORY_MASTER_FILE_COMMENT_GET_V001Request' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_COMMENT_GET_V001Request',
            'S_SUITE_CATEGORY_MASTER_FILE_COMMENT_GET_V001Response' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_COMMENT_GET_V001Response',
            'S_SUITE_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Request' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Request',
            'S_SUITE_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Response' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Response',
            'S_SUITE_CATEGORY_MASTER_FILE_GET_V001Request' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_GET_V001Request',
            'S_SUITE_CATEGORY_MASTER_FILE_GET_V001Response' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_GET_V001Response',
            'S_SUITE_CATEGORY_MASTER_FILE_INTERNET_GET_V001Request' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_INTERNET_GET_V001Request',
            'S_SUITE_CATEGORY_MASTER_FILE_INTERNET_GET_V001Response' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_INTERNET_GET_V001Response',
            'S_SUITE_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Request' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Request',
            'S_SUITE_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Response' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Response',
            'S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Request' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Request',
            'S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Response' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Response',
            'S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Request' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Request',
            'S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Response' => '\\StructType\\S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Response',
            'S_SYSMESSAGE_ADD_V001Request' => '\\StructType\\S_SYSMESSAGE_ADD_V001Request',
            'SysMessage' => '\\StructType\\SysMessage',
            'S_SYSMESSAGE_ADD_V001Response' => '\\StructType\\S_SYSMESSAGE_ADD_V001Response',
            'S_SYSMESSAGE_ADD_V002Request' => '\\StructType\\S_SYSMESSAGE_ADD_V002Request',
            'TextParameter' => '\\StructType\\TextParameter',
            'S_SYSMESSAGE_ADD_V002Response' => '\\StructType\\S_SYSMESSAGE_ADD_V002Response',
            'S_TOKENISATION_NOTIFICATION_V01Request' => '\\StructType\\S_TOKENISATION_NOTIFICATION_V01Request',
            'CardSearchAndModify' => '\\StructType\\CardSearchAndModify',
            'CardModifyData' => '\\StructType\\CardModifyData',
            'S_TOKENISATION_NOTIFICATION_V01Response' => '\\StructType\\S_TOKENISATION_NOTIFICATION_V01Response',
            'S_TOKENISATION_NOTIFICATION_V02Request' => '\\StructType\\S_TOKENISATION_NOTIFICATION_V02Request',
            'S_TOKENISATION_NOTIFICATION_V02Response' => '\\StructType\\S_TOKENISATION_NOTIFICATION_V02Response',
            'S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Request' => '\\StructType\\S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Request',
            'ExternalAttachment' => '\\StructType\\ExternalAttachment',
            'S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Response' => '\\StructType\\S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Response',
            'S_TRAIL_EXTERNAL_DOCUMENT_ADD_V001Request' => '\\StructType\\S_TRAIL_EXTERNAL_DOCUMENT_ADD_V001Request',
            'S_TRAIL_EXTERNAL_DOCUMENT_ADD_V001Response' => '\\StructType\\S_TRAIL_EXTERNAL_DOCUMENT_ADD_V001Response',
            'S_USER_GET_CURRENT_V001Request' => '\\StructType\\S_USER_GET_CURRENT_V001Request',
            'User' => '\\StructType\\User',
            'S_USER_GET_CURRENT_V001Response' => '\\StructType\\S_USER_GET_CURRENT_V001Response',
            'S_USER_INFO_GET_V001Request' => '\\StructType\\S_USER_INFO_GET_V001Request',
            'S_USER_INFO_GET_V001Response' => '\\StructType\\S_USER_INFO_GET_V001Response',
            'S_USER_INFO_GET_V002Request' => '\\StructType\\S_USER_INFO_GET_V002Request',
            'S_USER_INFO_GET_V002Response' => '\\StructType\\S_USER_INFO_GET_V002Response',
            'AllowedHotels' => '\\StructType\\AllowedHotels',
            'AllowedHotel' => '\\StructType\\AllowedHotel',
            'PreferredHotels' => '\\StructType\\PreferredHotels',
            'PreferredHotel' => '\\StructType\\PreferredHotel',
            'S_USER_INFO_GET_V003Request' => '\\StructType\\S_USER_INFO_GET_V003Request',
            'S_USER_INFO_GET_V003Response' => '\\StructType\\S_USER_INFO_GET_V003Response',
            'S_USER_SEARCH_V001Request' => '\\StructType\\S_USER_SEARCH_V001Request',
            'UserSearch' => '\\StructType\\UserSearch',
            'S_USER_SEARCH_V001Response' => '\\StructType\\S_USER_SEARCH_V001Response',
            'Users' => '\\StructType\\Users',
            'S_USER_SEARCH_V002Request' => '\\StructType\\S_USER_SEARCH_V002Request',
            'S_USER_SEARCH_V002Response' => '\\StructType\\S_USER_SEARCH_V002Response',
            'S_YIELD_HURDLE_PRODUCTION_SEARCH_V001Request' => '\\StructType\\S_YIELD_HURDLE_PRODUCTION_SEARCH_V001Request',
            'YieldHurdleProductionSearch' => '\\StructType\\YieldHurdleProductionSearch',
            'S_YIELD_HURDLE_PRODUCTION_SEARCH_V001Response' => '\\StructType\\S_YIELD_HURDLE_PRODUCTION_SEARCH_V001Response',
            'YieldHurdleProduction' => '\\StructType\\YieldHurdleProduction',
        );
    }
}
