<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for YieldHurdleProductionSearch StructType
 * @subpackage Structs
 */
class YieldHurdleProductionSearch extends AbstractStructBase
{
    /**
     * The from
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $from;
    /**
     * The to
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $to;
    /**
     * The onlychanges
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $onlychanges;
    /**
     * Constructor method for YieldHurdleProductionSearch
     * @uses YieldHurdleProductionSearch::setFrom()
     * @uses YieldHurdleProductionSearch::setTo()
     * @uses YieldHurdleProductionSearch::setOnlychanges()
     * @param string $from
     * @param string $to
     * @param string $onlychanges
     */
    public function __construct($from = null, $to = null, $onlychanges = null)
    {
        $this
            ->setFrom($from)
            ->setTo($to)
            ->setOnlychanges($onlychanges);
    }
    /**
     * Get from value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param string $from
     * @return \StructType\YieldHurdleProductionSearch
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($from) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($from, true)), __LINE__);
        }
        $this->from = $from;
        return $this;
    }
    /**
     * Get to value
     * @return string|null
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param string $to
     * @return \StructType\YieldHurdleProductionSearch
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($to) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($to, true)), __LINE__);
        }
        $this->to = $to;
        return $this;
    }
    /**
     * Get onlychanges value
     * @return string|null
     */
    public function getOnlychanges()
    {
        return $this->onlychanges;
    }
    /**
     * Set onlychanges value
     * @param string $onlychanges
     * @return \StructType\YieldHurdleProductionSearch
     */
    public function setOnlychanges($onlychanges = null)
    {
        // validation for constraint: string
        if (!is_null($onlychanges) && !is_string($onlychanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlychanges, true), gettype($onlychanges)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($onlychanges) && !preg_match('/([-+]){0,1}([0-9])*/', $onlychanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($onlychanges, true)), __LINE__);
        }
        $this->onlychanges = $onlychanges;
        return $this;
    }
}
