<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VAT StructType
 * @subpackage Structs
 */
class VAT extends AbstractStructBase
{
    /**
     * The vat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $vat;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The percent
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $percent;
    /**
     * The amountvat
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amountvat;
    /**
     * The amountnet
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amountnet;
    /**
     * The amountgross
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amountgross;
    /**
     * The revenueaccount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $revenueaccount;
    /**
     * Constructor method for VAT
     * @uses VAT::setVat()
     * @uses VAT::setDescription()
     * @uses VAT::setPercent()
     * @uses VAT::setAmountvat()
     * @uses VAT::setAmountnet()
     * @uses VAT::setAmountgross()
     * @uses VAT::setRevenueaccount()
     * @param string $vat
     * @param string $description
     * @param string $percent
     * @param string $amountvat
     * @param string $amountnet
     * @param string $amountgross
     * @param string $revenueaccount
     */
    public function __construct($vat = null, $description = null, $percent = null, $amountvat = null, $amountnet = null, $amountgross = null, $revenueaccount = null)
    {
        $this
            ->setVat($vat)
            ->setDescription($description)
            ->setPercent($percent)
            ->setAmountvat($amountvat)
            ->setAmountnet($amountnet)
            ->setAmountgross($amountgross)
            ->setRevenueaccount($revenueaccount);
    }
    /**
     * Get vat value
     * @return string
     */
    public function getVat()
    {
        return $this->vat;
    }
    /**
     * Set vat value
     * @param string $vat
     * @return \StructType\VAT
     */
    public function setVat($vat = null)
    {
        // validation for constraint: string
        if (!is_null($vat) && !is_string($vat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vat, true), gettype($vat)), __LINE__);
        }
        $this->vat = $vat;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\VAT
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get percent value
     * @return string
     */
    public function getPercent()
    {
        return $this->percent;
    }
    /**
     * Set percent value
     * @param string $percent
     * @return \StructType\VAT
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: string
        if (!is_null($percent) && !is_string($percent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($percent) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $percent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($percent, true)), __LINE__);
        }
        $this->percent = $percent;
        return $this;
    }
    /**
     * Get amountvat value
     * @return string
     */
    public function getAmountvat()
    {
        return $this->amountvat;
    }
    /**
     * Set amountvat value
     * @param string $amountvat
     * @return \StructType\VAT
     */
    public function setAmountvat($amountvat = null)
    {
        // validation for constraint: string
        if (!is_null($amountvat) && !is_string($amountvat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountvat, true), gettype($amountvat)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amountvat) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amountvat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amountvat, true)), __LINE__);
        }
        $this->amountvat = $amountvat;
        return $this;
    }
    /**
     * Get amountnet value
     * @return string
     */
    public function getAmountnet()
    {
        return $this->amountnet;
    }
    /**
     * Set amountnet value
     * @param string $amountnet
     * @return \StructType\VAT
     */
    public function setAmountnet($amountnet = null)
    {
        // validation for constraint: string
        if (!is_null($amountnet) && !is_string($amountnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountnet, true), gettype($amountnet)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amountnet) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amountnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amountnet, true)), __LINE__);
        }
        $this->amountnet = $amountnet;
        return $this;
    }
    /**
     * Get amountgross value
     * @return string
     */
    public function getAmountgross()
    {
        return $this->amountgross;
    }
    /**
     * Set amountgross value
     * @param string $amountgross
     * @return \StructType\VAT
     */
    public function setAmountgross($amountgross = null)
    {
        // validation for constraint: string
        if (!is_null($amountgross) && !is_string($amountgross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountgross, true), gettype($amountgross)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amountgross) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amountgross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amountgross, true)), __LINE__);
        }
        $this->amountgross = $amountgross;
        return $this;
    }
    /**
     * Get revenueaccount value
     * @return string
     */
    public function getRevenueaccount()
    {
        return $this->revenueaccount;
    }
    /**
     * Set revenueaccount value
     * @param string $revenueaccount
     * @return \StructType\VAT
     */
    public function setRevenueaccount($revenueaccount = null)
    {
        // validation for constraint: string
        if (!is_null($revenueaccount) && !is_string($revenueaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenueaccount, true), gettype($revenueaccount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($revenueaccount) && !preg_match('/([-+]){0,1}([0-9])*/', $revenueaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($revenueaccount, true)), __LINE__);
        }
        $this->revenueaccount = $revenueaccount;
        return $this;
    }
}
