<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserSearch StructType
 * @subpackage Structs
 */
class UserSearch extends AbstractStructBase
{
    /**
     * The operator
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $operator;
    /**
     * The salesperson
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $salesperson;
    /**
     * Constructor method for UserSearch
     * @uses UserSearch::setOperator()
     * @uses UserSearch::setSalesperson()
     * @param string $operator
     * @param string $salesperson
     */
    public function __construct($operator = null, $salesperson = null)
    {
        $this
            ->setOperator($operator)
            ->setSalesperson($salesperson);
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @param string $operator
     * @return \StructType\UserSearch
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: string
        if (!is_null($operator) && !is_string($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operator, true), gettype($operator)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($operator) && mb_strlen($operator) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($operator)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($operator) && mb_strlen($operator) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($operator)), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Get salesperson value
     * @return string|null
     */
    public function getSalesperson()
    {
        return $this->salesperson;
    }
    /**
     * Set salesperson value
     * @param string $salesperson
     * @return \StructType\UserSearch
     */
    public function setSalesperson($salesperson = null)
    {
        // validation for constraint: string
        if (!is_null($salesperson) && !is_string($salesperson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesperson, true), gettype($salesperson)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($salesperson) && mb_strlen($salesperson) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($salesperson)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($salesperson) && mb_strlen($salesperson) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($salesperson)), __LINE__);
        }
        $this->salesperson = $salesperson;
        return $this;
    }
}
