<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserInfo StructType
 * @subpackage Structs
 */
class UserInfo extends AbstractStructBase
{
    /**
     * The userID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $userID;
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $userName;
    /**
     * The userGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $userGroup;
    /**
     * The accessGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $accessGroup;
    /**
     * The hotelNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotelNo;
    /**
     * The hotelName
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $hotelName;
    /**
     * The hotelDate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $hotelDate;
    /**
     * The systemDate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $systemDate;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $language;
    /**
     * The AllowedHotels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AllowedHotels
     */
    public $AllowedHotels;
    /**
     * The PreferredHotels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PreferredHotels
     */
    public $PreferredHotels;
    /**
     * Constructor method for UserInfo
     * @uses UserInfo::setUserID()
     * @uses UserInfo::setUserName()
     * @uses UserInfo::setUserGroup()
     * @uses UserInfo::setAccessGroup()
     * @uses UserInfo::setHotelNo()
     * @uses UserInfo::setHotelName()
     * @uses UserInfo::setHotelDate()
     * @uses UserInfo::setSystemDate()
     * @uses UserInfo::setLanguage()
     * @uses UserInfo::setAllowedHotels()
     * @uses UserInfo::setPreferredHotels()
     * @param string $userID
     * @param string $userName
     * @param string $userGroup
     * @param string $accessGroup
     * @param string $hotelNo
     * @param string $hotelName
     * @param string $hotelDate
     * @param string $systemDate
     * @param string $language
     * @param \StructType\AllowedHotels $allowedHotels
     * @param \StructType\PreferredHotels $preferredHotels
     */
    public function __construct($userID = null, $userName = null, $userGroup = null, $accessGroup = null, $hotelNo = null, $hotelName = null, $hotelDate = null, $systemDate = null, $language = null, \StructType\AllowedHotels $allowedHotels = null, \StructType\PreferredHotels $preferredHotels = null)
    {
        $this
            ->setUserID($userID)
            ->setUserName($userName)
            ->setUserGroup($userGroup)
            ->setAccessGroup($accessGroup)
            ->setHotelNo($hotelNo)
            ->setHotelName($hotelName)
            ->setHotelDate($hotelDate)
            ->setSystemDate($systemDate)
            ->setLanguage($language)
            ->setAllowedHotels($allowedHotels)
            ->setPreferredHotels($preferredHotels);
    }
    /**
     * Get userID value
     * @return string
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param string $userID
     * @return \StructType\UserInfo
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->userID = $userID;
        return $this;
    }
    /**
     * Get userName value
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\UserInfo
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get userGroup value
     * @return string
     */
    public function getUserGroup()
    {
        return $this->userGroup;
    }
    /**
     * Set userGroup value
     * @param string $userGroup
     * @return \StructType\UserInfo
     */
    public function setUserGroup($userGroup = null)
    {
        // validation for constraint: string
        if (!is_null($userGroup) && !is_string($userGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userGroup, true), gettype($userGroup)), __LINE__);
        }
        $this->userGroup = $userGroup;
        return $this;
    }
    /**
     * Get accessGroup value
     * @return string
     */
    public function getAccessGroup()
    {
        return $this->accessGroup;
    }
    /**
     * Set accessGroup value
     * @param string $accessGroup
     * @return \StructType\UserInfo
     */
    public function setAccessGroup($accessGroup = null)
    {
        // validation for constraint: string
        if (!is_null($accessGroup) && !is_string($accessGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessGroup, true), gettype($accessGroup)), __LINE__);
        }
        $this->accessGroup = $accessGroup;
        return $this;
    }
    /**
     * Get hotelNo value
     * @return string
     */
    public function getHotelNo()
    {
        return $this->hotelNo;
    }
    /**
     * Set hotelNo value
     * @param string $hotelNo
     * @return \StructType\UserInfo
     */
    public function setHotelNo($hotelNo = null)
    {
        // validation for constraint: string
        if (!is_null($hotelNo) && !is_string($hotelNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelNo, true), gettype($hotelNo)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotelNo) && !preg_match('/([-+]){0,1}([0-9])*/', $hotelNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotelNo, true)), __LINE__);
        }
        $this->hotelNo = $hotelNo;
        return $this;
    }
    /**
     * Get hotelName value
     * @return string
     */
    public function getHotelName()
    {
        return $this->hotelName;
    }
    /**
     * Set hotelName value
     * @param string $hotelName
     * @return \StructType\UserInfo
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($hotelName) && mb_strlen($hotelName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($hotelName)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($hotelName) && mb_strlen($hotelName) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($hotelName)), __LINE__);
        }
        $this->hotelName = $hotelName;
        return $this;
    }
    /**
     * Get hotelDate value
     * @return string
     */
    public function getHotelDate()
    {
        return $this->hotelDate;
    }
    /**
     * Set hotelDate value
     * @param string $hotelDate
     * @return \StructType\UserInfo
     */
    public function setHotelDate($hotelDate = null)
    {
        // validation for constraint: string
        if (!is_null($hotelDate) && !is_string($hotelDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelDate, true), gettype($hotelDate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($hotelDate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $hotelDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($hotelDate, true)), __LINE__);
        }
        $this->hotelDate = $hotelDate;
        return $this;
    }
    /**
     * Get systemDate value
     * @return string
     */
    public function getSystemDate()
    {
        return $this->systemDate;
    }
    /**
     * Set systemDate value
     * @param string $systemDate
     * @return \StructType\UserInfo
     */
    public function setSystemDate($systemDate = null)
    {
        // validation for constraint: string
        if (!is_null($systemDate) && !is_string($systemDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemDate, true), gettype($systemDate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($systemDate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $systemDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($systemDate, true)), __LINE__);
        }
        $this->systemDate = $systemDate;
        return $this;
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\UserInfo
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get AllowedHotels value
     * @return \StructType\AllowedHotels
     */
    public function getAllowedHotels()
    {
        return $this->AllowedHotels;
    }
    /**
     * Set AllowedHotels value
     * @param \StructType\AllowedHotels $allowedHotels
     * @return \StructType\UserInfo
     */
    public function setAllowedHotels(\StructType\AllowedHotels $allowedHotels = null)
    {
        $this->AllowedHotels = $allowedHotels;
        return $this;
    }
    /**
     * Get PreferredHotels value
     * @return \StructType\PreferredHotels
     */
    public function getPreferredHotels()
    {
        return $this->PreferredHotels;
    }
    /**
     * Set PreferredHotels value
     * @param \StructType\PreferredHotels $preferredHotels
     * @return \StructType\UserInfo
     */
    public function setPreferredHotels(\StructType\PreferredHotels $preferredHotels = null)
    {
        $this->PreferredHotels = $preferredHotels;
        return $this;
    }
}
