<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Trails StructType
 * @subpackage Structs
 */
class Trails extends AbstractStructBase
{
    /**
     * The Trail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Trail[]
     */
    public $Trail;
    /**
     * Constructor method for Trails
     * @uses Trails::setTrail()
     * @param \StructType\Trail[] $trail
     */
    public function __construct(array $trail = array())
    {
        $this
            ->setTrail($trail);
    }
    /**
     * Get Trail value
     * @return \StructType\Trail[]|null
     */
    public function getTrail()
    {
        return $this->Trail;
    }
    /**
     * This method is responsible for validating the values passed to the setTrail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrailForArrayConstraintsFromSetTrail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trailsTrailItem) {
            // validation for constraint: itemType
            if (!$trailsTrailItem instanceof \StructType\Trail) {
                $invalidValues[] = is_object($trailsTrailItem) ? get_class($trailsTrailItem) : sprintf('%s(%s)', gettype($trailsTrailItem), var_export($trailsTrailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Trail property can only contain items of type \StructType\Trail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Trail value
     * @throws \InvalidArgumentException
     * @param \StructType\Trail[] $trail
     * @return \StructType\Trails
     */
    public function setTrail(array $trail = array())
    {
        // validation for constraint: array
        if ('' !== ($trailArrayErrorMessage = self::validateTrailForArrayConstraintsFromSetTrail($trail))) {
            throw new \InvalidArgumentException($trailArrayErrorMessage, __LINE__);
        }
        $this->Trail = $trail;
        return $this;
    }
    /**
     * Add item to Trail value
     * @throws \InvalidArgumentException
     * @param \StructType\Trail $item
     * @return \StructType\Trails
     */
    public function addToTrail(\StructType\Trail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Trail) {
            throw new \InvalidArgumentException(sprintf('The Trail property can only contain items of type \StructType\Trail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Trail[] = $item;
        return $this;
    }
}
