<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrailData StructType
 * @subpackage Structs
 */
class TrailData extends AbstractStructBase
{
    /**
     * The TRAIL_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $TRAIL_OBJID;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The beginDate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $beginDate;
    /**
     * The beginTime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $beginTime;
    /**
     * The enddate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $enddate;
    /**
     * The endtime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $endtime;
    /**
     * The contactperson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $contactperson;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $user;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The appointmentdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $appointmentdate;
    /**
     * The time
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $time;
    /**
     * The FollowUps
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FollowUps[]
     */
    public $FollowUps;
    /**
     * The followUps
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FollowUps_1[]
     */
    public $followUps;
    /**
     * The ExternalFileDatas
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExternalFileDatas[]
     */
    public $ExternalFileDatas;
    /**
     * Constructor method for TrailData
     * @uses TrailData::setTRAIL_OBJID()
     * @uses TrailData::setDescription()
     * @uses TrailData::setStatus()
     * @uses TrailData::setBeginDate()
     * @uses TrailData::setBeginTime()
     * @uses TrailData::setEnddate()
     * @uses TrailData::setEndtime()
     * @uses TrailData::setContactperson()
     * @uses TrailData::setUser()
     * @uses TrailData::setComment()
     * @uses TrailData::setAppointmentdate()
     * @uses TrailData::setTime()
     * @uses TrailData::setFollowUps()
     * @uses TrailData::setFollowUps_1()
     * @uses TrailData::setExternalFileDatas()
     * @param string $tRAIL_OBJID
     * @param string $description
     * @param string $status
     * @param string $beginDate
     * @param string $beginTime
     * @param string $enddate
     * @param string $endtime
     * @param string $contactperson
     * @param string $user
     * @param string $comment
     * @param string $appointmentdate
     * @param string $time
     * @param \StructType\FollowUps[] $followUps
     * @param \StructType\FollowUps_1[] $followUps
     * @param \StructType\ExternalFileDatas[] $externalFileDatas
     */
    public function __construct($tRAIL_OBJID = null, $description = null, $status = null, $beginDate = null, $beginTime = null, $enddate = null, $endtime = null, $contactperson = null, $user = null, $comment = null, $appointmentdate = null, $time = null, array $followUps = array(), array $followUps_1 = array(), array $externalFileDatas = array())
    {
        $this
            ->setTRAIL_OBJID($tRAIL_OBJID)
            ->setDescription($description)
            ->setStatus($status)
            ->setBeginDate($beginDate)
            ->setBeginTime($beginTime)
            ->setEnddate($enddate)
            ->setEndtime($endtime)
            ->setContactperson($contactperson)
            ->setUser($user)
            ->setComment($comment)
            ->setAppointmentdate($appointmentdate)
            ->setTime($time)
            ->setFollowUps($followUps)
            ->setFollowUps_1($followUps_1)
            ->setExternalFileDatas($externalFileDatas);
    }
    /**
     * Get TRAIL_OBJID value
     * @return string
     */
    public function getTRAIL_OBJID()
    {
        return $this->{'TRAIL-OBJID'};
    }
    /**
     * Set TRAIL_OBJID value
     * @param string $tRAIL_OBJID
     * @return \StructType\TrailData
     */
    public function setTRAIL_OBJID($tRAIL_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($tRAIL_OBJID) && !is_string($tRAIL_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tRAIL_OBJID, true), gettype($tRAIL_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($tRAIL_OBJID) && !preg_match('/([0-9])*/', $tRAIL_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($tRAIL_OBJID, true)), __LINE__);
        }
        $this->TRAIL_OBJID = $this->{'TRAIL-OBJID'} = $tRAIL_OBJID;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\TrailData
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\TrailData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($status) && mb_strlen($status) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($status)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($status) && mb_strlen($status) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get beginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->beginDate;
    }
    /**
     * Set beginDate value
     * @param string $beginDate
     * @return \StructType\TrailData
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($beginDate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($beginDate, true)), __LINE__);
        }
        $this->beginDate = $beginDate;
        return $this;
    }
    /**
     * Get beginTime value
     * @return string
     */
    public function getBeginTime()
    {
        return $this->beginTime;
    }
    /**
     * Set beginTime value
     * @param string $beginTime
     * @return \StructType\TrailData
     */
    public function setBeginTime($beginTime = null)
    {
        // validation for constraint: string
        if (!is_null($beginTime) && !is_string($beginTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginTime, true), gettype($beginTime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($beginTime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $beginTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($beginTime, true)), __LINE__);
        }
        $this->beginTime = $beginTime;
        return $this;
    }
    /**
     * Get enddate value
     * @return string
     */
    public function getEnddate()
    {
        return $this->enddate;
    }
    /**
     * Set enddate value
     * @param string $enddate
     * @return \StructType\TrailData
     */
    public function setEnddate($enddate = null)
    {
        // validation for constraint: string
        if (!is_null($enddate) && !is_string($enddate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enddate, true), gettype($enddate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($enddate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $enddate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($enddate, true)), __LINE__);
        }
        $this->enddate = $enddate;
        return $this;
    }
    /**
     * Get endtime value
     * @return string
     */
    public function getEndtime()
    {
        return $this->endtime;
    }
    /**
     * Set endtime value
     * @param string $endtime
     * @return \StructType\TrailData
     */
    public function setEndtime($endtime = null)
    {
        // validation for constraint: string
        if (!is_null($endtime) && !is_string($endtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endtime, true), gettype($endtime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($endtime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $endtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($endtime, true)), __LINE__);
        }
        $this->endtime = $endtime;
        return $this;
    }
    /**
     * Get contactperson value
     * @return string
     */
    public function getContactperson()
    {
        return $this->contactperson;
    }
    /**
     * Set contactperson value
     * @param string $contactperson
     * @return \StructType\TrailData
     */
    public function setContactperson($contactperson = null)
    {
        // validation for constraint: string
        if (!is_null($contactperson) && !is_string($contactperson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactperson, true), gettype($contactperson)), __LINE__);
        }
        $this->contactperson = $contactperson;
        return $this;
    }
    /**
     * Get user value
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\TrailData
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($user) && mb_strlen($user) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($user)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($user) && mb_strlen($user) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\TrailData
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get appointmentdate value
     * @return string
     */
    public function getAppointmentdate()
    {
        return $this->appointmentdate;
    }
    /**
     * Set appointmentdate value
     * @param string $appointmentdate
     * @return \StructType\TrailData
     */
    public function setAppointmentdate($appointmentdate = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentdate) && !is_string($appointmentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appointmentdate, true), gettype($appointmentdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($appointmentdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $appointmentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($appointmentdate, true)), __LINE__);
        }
        $this->appointmentdate = $appointmentdate;
        return $this;
    }
    /**
     * Get time value
     * @return string
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param string $time
     * @return \StructType\TrailData
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($time) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($time, true)), __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Get FollowUps value
     * @return \StructType\FollowUps[]|null
     */
    public function getFollowUps()
    {
        return $this->FollowUps;
    }
    /**
     * This method is responsible for validating the values passed to the setFollowUps method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFollowUps method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFollowUpsForArrayConstraintsFromSetFollowUps(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trailDataFollowUpsItem) {
            // validation for constraint: itemType
            if (!$trailDataFollowUpsItem instanceof \StructType\FollowUps) {
                $invalidValues[] = is_object($trailDataFollowUpsItem) ? get_class($trailDataFollowUpsItem) : sprintf('%s(%s)', gettype($trailDataFollowUpsItem), var_export($trailDataFollowUpsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FollowUps property can only contain items of type \StructType\FollowUps, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FollowUps value
     * @throws \InvalidArgumentException
     * @param \StructType\FollowUps[] $followUps
     * @return \StructType\TrailData
     */
    public function setFollowUps(array $followUps = array())
    {
        // validation for constraint: array
        if ('' !== ($followUpsArrayErrorMessage = self::validateFollowUpsForArrayConstraintsFromSetFollowUps($followUps))) {
            throw new \InvalidArgumentException($followUpsArrayErrorMessage, __LINE__);
        }
        $this->FollowUps = $followUps;
        return $this;
    }
    /**
     * Add item to followUps value
     * @throws \InvalidArgumentException
     * @param \StructType\FollowUps_1 $item
     * @return \StructType\TrailData
     */
    public function addToFollowUps(\StructType\FollowUps_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FollowUps_1) {
            throw new \InvalidArgumentException(sprintf('The followUps property can only contain items of type \StructType\FollowUps_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->followUps[] = $item;
        return $this;
    }
    /**
     * Get FollowUps value
     * @return \StructType\FollowUps[]|null
     */
    public function getFollowUps_1()
    {
        return $this->followUps;
    }
    /**
     * This method is responsible for validating the values passed to the setFollowUps_1 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFollowUps_1 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFollowUps_1ForArrayConstraintsFromSetFollowUps_1(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trailDataFollowUpsItem) {
            // validation for constraint: itemType
            if (!$trailDataFollowUpsItem instanceof \StructType\FollowUps_1) {
                $invalidValues[] = is_object($trailDataFollowUpsItem) ? get_class($trailDataFollowUpsItem) : sprintf('%s(%s)', gettype($trailDataFollowUpsItem), var_export($trailDataFollowUpsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The followUps property can only contain items of type \StructType\FollowUps_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FollowUps value
     * @throws \InvalidArgumentException
     * @param \StructType\FollowUps[] $followUps
     * @return \StructType\TrailData
     */
    public function setFollowUps_1(array $followUps_1 = array())
    {
        // validation for constraint: array
        if ('' !== ($followUps_1ArrayErrorMessage = self::validateFollowUps_1ForArrayConstraintsFromSetFollowUps_1($followUps_1))) {
            throw new \InvalidArgumentException($followUps_1ArrayErrorMessage, __LINE__);
        }
        $this->followUps = $followUps_1;
        return $this;
    }
    /**
     * Get ExternalFileDatas value
     * @return \StructType\ExternalFileDatas[]|null
     */
    public function getExternalFileDatas()
    {
        return $this->ExternalFileDatas;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalFileDatas method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalFileDatas method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalFileDatasForArrayConstraintsFromSetExternalFileDatas(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trailDataExternalFileDatasItem) {
            // validation for constraint: itemType
            if (!$trailDataExternalFileDatasItem instanceof \StructType\ExternalFileDatas) {
                $invalidValues[] = is_object($trailDataExternalFileDatasItem) ? get_class($trailDataExternalFileDatasItem) : sprintf('%s(%s)', gettype($trailDataExternalFileDatasItem), var_export($trailDataExternalFileDatasItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExternalFileDatas property can only contain items of type \StructType\ExternalFileDatas, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExternalFileDatas value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalFileDatas[] $externalFileDatas
     * @return \StructType\TrailData
     */
    public function setExternalFileDatas(array $externalFileDatas = array())
    {
        // validation for constraint: array
        if ('' !== ($externalFileDatasArrayErrorMessage = self::validateExternalFileDatasForArrayConstraintsFromSetExternalFileDatas($externalFileDatas))) {
            throw new \InvalidArgumentException($externalFileDatasArrayErrorMessage, __LINE__);
        }
        $this->ExternalFileDatas = $externalFileDatas;
        return $this;
    }
    /**
     * Add item to ExternalFileDatas value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalFileDatas $item
     * @return \StructType\TrailData
     */
    public function addToExternalFileDatas(\StructType\ExternalFileDatas $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalFileDatas) {
            throw new \InvalidArgumentException(sprintf('The ExternalFileDatas property can only contain items of type \StructType\ExternalFileDatas, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExternalFileDatas[] = $item;
        return $this;
    }
}
