<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceMasterFile StructType
 * @subpackage Structs
 */
class ServiceMasterFile extends AbstractStructBase
{
    /**
     * The SERVICE_MASTER_FILE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $SERVICE_MASTER_FILE_OBJID;
    /**
     * The servicecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $servicecode;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratesegment;
    /**
     * The MultiLangDescriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultiLangDescriptions[]
     */
    public $MultiLangDescriptions;
    /**
     * The MultiLangComments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultiLangComments[]
     */
    public $MultiLangComments;
    /**
     * Constructor method for ServiceMasterFile
     * @uses ServiceMasterFile::setSERVICE_MASTER_FILE_OBJID()
     * @uses ServiceMasterFile::setServicecode()
     * @uses ServiceMasterFile::setRatesegment()
     * @uses ServiceMasterFile::setMultiLangDescriptions()
     * @uses ServiceMasterFile::setMultiLangComments()
     * @param string $sERVICE_MASTER_FILE_OBJID
     * @param string $servicecode
     * @param string $ratesegment
     * @param \StructType\MultiLangDescriptions[] $multiLangDescriptions
     * @param \StructType\MultiLangComments[] $multiLangComments
     */
    public function __construct($sERVICE_MASTER_FILE_OBJID = null, $servicecode = null, $ratesegment = null, array $multiLangDescriptions = array(), array $multiLangComments = array())
    {
        $this
            ->setSERVICE_MASTER_FILE_OBJID($sERVICE_MASTER_FILE_OBJID)
            ->setServicecode($servicecode)
            ->setRatesegment($ratesegment)
            ->setMultiLangDescriptions($multiLangDescriptions)
            ->setMultiLangComments($multiLangComments);
    }
    /**
     * Get SERVICE_MASTER_FILE_OBJID value
     * @return string
     */
    public function getSERVICE_MASTER_FILE_OBJID()
    {
        return $this->{'SERVICE-MASTER-FILE-OBJID'};
    }
    /**
     * Set SERVICE_MASTER_FILE_OBJID value
     * @param string $sERVICE_MASTER_FILE_OBJID
     * @return \StructType\ServiceMasterFile
     */
    public function setSERVICE_MASTER_FILE_OBJID($sERVICE_MASTER_FILE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($sERVICE_MASTER_FILE_OBJID) && !is_string($sERVICE_MASTER_FILE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERVICE_MASTER_FILE_OBJID, true), gettype($sERVICE_MASTER_FILE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($sERVICE_MASTER_FILE_OBJID) && !preg_match('/([0-9])*/', $sERVICE_MASTER_FILE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($sERVICE_MASTER_FILE_OBJID, true)), __LINE__);
        }
        $this->SERVICE_MASTER_FILE_OBJID = $this->{'SERVICE-MASTER-FILE-OBJID'} = $sERVICE_MASTER_FILE_OBJID;
        return $this;
    }
    /**
     * Get servicecode value
     * @return string
     */
    public function getServicecode()
    {
        return $this->servicecode;
    }
    /**
     * Set servicecode value
     * @param string $servicecode
     * @return \StructType\ServiceMasterFile
     */
    public function setServicecode($servicecode = null)
    {
        // validation for constraint: string
        if (!is_null($servicecode) && !is_string($servicecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicecode, true), gettype($servicecode)), __LINE__);
        }
        $this->servicecode = $servicecode;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\ServiceMasterFile
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ratesegment) && mb_strlen($ratesegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ratesegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratesegment) && mb_strlen($ratesegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get MultiLangDescriptions value
     * @return \StructType\MultiLangDescriptions[]|null
     */
    public function getMultiLangDescriptions()
    {
        return $this->MultiLangDescriptions;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiLangDescriptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiLangDescriptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiLangDescriptionsForArrayConstraintsFromSetMultiLangDescriptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceMasterFileMultiLangDescriptionsItem) {
            // validation for constraint: itemType
            if (!$serviceMasterFileMultiLangDescriptionsItem instanceof \StructType\MultiLangDescriptions) {
                $invalidValues[] = is_object($serviceMasterFileMultiLangDescriptionsItem) ? get_class($serviceMasterFileMultiLangDescriptionsItem) : sprintf('%s(%s)', gettype($serviceMasterFileMultiLangDescriptionsItem), var_export($serviceMasterFileMultiLangDescriptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MultiLangDescriptions property can only contain items of type \StructType\MultiLangDescriptions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MultiLangDescriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangDescriptions[] $multiLangDescriptions
     * @return \StructType\ServiceMasterFile
     */
    public function setMultiLangDescriptions(array $multiLangDescriptions = array())
    {
        // validation for constraint: array
        if ('' !== ($multiLangDescriptionsArrayErrorMessage = self::validateMultiLangDescriptionsForArrayConstraintsFromSetMultiLangDescriptions($multiLangDescriptions))) {
            throw new \InvalidArgumentException($multiLangDescriptionsArrayErrorMessage, __LINE__);
        }
        $this->MultiLangDescriptions = $multiLangDescriptions;
        return $this;
    }
    /**
     * Add item to MultiLangDescriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangDescriptions $item
     * @return \StructType\ServiceMasterFile
     */
    public function addToMultiLangDescriptions(\StructType\MultiLangDescriptions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultiLangDescriptions) {
            throw new \InvalidArgumentException(sprintf('The MultiLangDescriptions property can only contain items of type \StructType\MultiLangDescriptions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MultiLangDescriptions[] = $item;
        return $this;
    }
    /**
     * Get MultiLangComments value
     * @return \StructType\MultiLangComments[]|null
     */
    public function getMultiLangComments()
    {
        return $this->MultiLangComments;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiLangComments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiLangComments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiLangCommentsForArrayConstraintsFromSetMultiLangComments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceMasterFileMultiLangCommentsItem) {
            // validation for constraint: itemType
            if (!$serviceMasterFileMultiLangCommentsItem instanceof \StructType\MultiLangComments) {
                $invalidValues[] = is_object($serviceMasterFileMultiLangCommentsItem) ? get_class($serviceMasterFileMultiLangCommentsItem) : sprintf('%s(%s)', gettype($serviceMasterFileMultiLangCommentsItem), var_export($serviceMasterFileMultiLangCommentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MultiLangComments property can only contain items of type \StructType\MultiLangComments, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MultiLangComments value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangComments[] $multiLangComments
     * @return \StructType\ServiceMasterFile
     */
    public function setMultiLangComments(array $multiLangComments = array())
    {
        // validation for constraint: array
        if ('' !== ($multiLangCommentsArrayErrorMessage = self::validateMultiLangCommentsForArrayConstraintsFromSetMultiLangComments($multiLangComments))) {
            throw new \InvalidArgumentException($multiLangCommentsArrayErrorMessage, __LINE__);
        }
        $this->MultiLangComments = $multiLangComments;
        return $this;
    }
    /**
     * Add item to MultiLangComments value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangComments $item
     * @return \StructType\ServiceMasterFile
     */
    public function addToMultiLangComments(\StructType\MultiLangComments $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultiLangComments) {
            throw new \InvalidArgumentException(sprintf('The MultiLangComments property can only contain items of type \StructType\MultiLangComments, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MultiLangComments[] = $item;
        return $this;
    }
}
