<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchCriteria StructType
 * @subpackage Structs
 */
class SearchCriteria extends AbstractStructBase
{
    /**
     * The area
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $area;
    /**
     * The refobjid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $refobjid;
    /**
     * The TRAILTYPE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TRAILTYPE;
    /**
     * The TYPE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TYPE;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $Type;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Key;
    /**
     * The Subkey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subkey;
    /**
     * The SUBTYPE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SUBTYPE;
    /**
     * Constructor method for SearchCriteria
     * @uses SearchCriteria::setArea()
     * @uses SearchCriteria::setRefobjid()
     * @uses SearchCriteria::setTRAILTYPE()
     * @uses SearchCriteria::setTYPE()
     * @uses SearchCriteria::setType_1()
     * @uses SearchCriteria::setKey()
     * @uses SearchCriteria::setSubkey()
     * @uses SearchCriteria::setSUBTYPE()
     * @param string $area
     * @param string $refobjid
     * @param string $tRAILTYPE
     * @param string $tYPE
     * @param string $type
     * @param string $key
     * @param string $subkey
     * @param string $sUBTYPE
     */
    public function __construct($area = null, $refobjid = null, $tRAILTYPE = null, $tYPE = null, $type_1 = null, $key = null, $subkey = null, $sUBTYPE = null)
    {
        $this
            ->setArea($area)
            ->setRefobjid($refobjid)
            ->setTRAILTYPE($tRAILTYPE)
            ->setTYPE($tYPE)
            ->setType_1($type_1)
            ->setKey($key)
            ->setSubkey($subkey)
            ->setSUBTYPE($sUBTYPE);
    }
    /**
     * Get area value
     * @return string
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @param string $area
     * @return \StructType\SearchCriteria
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($area, true), gettype($area)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($area) && !preg_match('/([-+]){0,1}([0-9])*/', $area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($area, true)), __LINE__);
        }
        $this->area = $area;
        return $this;
    }
    /**
     * Get refobjid value
     * @return string
     */
    public function getRefobjid()
    {
        return $this->refobjid;
    }
    /**
     * Set refobjid value
     * @param string $refobjid
     * @return \StructType\SearchCriteria
     */
    public function setRefobjid($refobjid = null)
    {
        // validation for constraint: string
        if (!is_null($refobjid) && !is_string($refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refobjid, true), gettype($refobjid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($refobjid) && !preg_match('/([0-9])*/', $refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($refobjid, true)), __LINE__);
        }
        $this->refobjid = $refobjid;
        return $this;
    }
    /**
     * Get TRAILTYPE value
     * @return string
     */
    public function getTRAILTYPE()
    {
        return $this->TRAILTYPE;
    }
    /**
     * Set TRAILTYPE value
     * @param string $tRAILTYPE
     * @return \StructType\SearchCriteria
     */
    public function setTRAILTYPE($tRAILTYPE = null)
    {
        // validation for constraint: string
        if (!is_null($tRAILTYPE) && !is_string($tRAILTYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tRAILTYPE, true), gettype($tRAILTYPE)), __LINE__);
        }
        $this->TRAILTYPE = $tRAILTYPE;
        return $this;
    }
    /**
     * Get TYPE value
     * @return string
     */
    public function getTYPE()
    {
        return $this->TYPE;
    }
    /**
     * Set TYPE value
     * @param string $tYPE
     * @return \StructType\SearchCriteria
     */
    public function setTYPE($tYPE = null)
    {
        // validation for constraint: string
        if (!is_null($tYPE) && !is_string($tYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tYPE, true), gettype($tYPE)), __LINE__);
        }
        $this->TYPE = $tYPE;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType_1()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\SearchCriteria
     */
    public function setType_1($type_1 = null)
    {
        // validation for constraint: string
        if (!is_null($type_1) && !is_string($type_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type_1, true), gettype($type_1)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($type_1) && !preg_match('/([-+]){0,1}([0-9])*/', $type_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($type_1, true)), __LINE__);
        }
        $this->Type = $type_1;
        return $this;
    }
    /**
     * Get Key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param string $key
     * @return \StructType\SearchCriteria
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->Key = $key;
        return $this;
    }
    /**
     * Get Subkey value
     * @return string|null
     */
    public function getSubkey()
    {
        return $this->Subkey;
    }
    /**
     * Set Subkey value
     * @param string $subkey
     * @return \StructType\SearchCriteria
     */
    public function setSubkey($subkey = null)
    {
        // validation for constraint: string
        if (!is_null($subkey) && !is_string($subkey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subkey, true), gettype($subkey)), __LINE__);
        }
        $this->Subkey = $subkey;
        return $this;
    }
    /**
     * Get SUBTYPE value
     * @return string|null
     */
    public function getSUBTYPE()
    {
        return $this->SUBTYPE;
    }
    /**
     * Set SUBTYPE value
     * @param string $sUBTYPE
     * @return \StructType\SearchCriteria
     */
    public function setSUBTYPE($sUBTYPE = null)
    {
        // validation for constraint: string
        if (!is_null($sUBTYPE) && !is_string($sUBTYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUBTYPE, true), gettype($sUBTYPE)), __LINE__);
        }
        $this->SUBTYPE = $sUBTYPE;
        return $this;
    }
}
