<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_USER_SEARCH_V001Response StructType
 * @subpackage Structs
 */
class S_USER_SEARCH_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Users
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Users[]
     */
    public $Users;
    /**
     * Constructor method for S_USER_SEARCH_V001Response
     * @uses S_USER_SEARCH_V001Response::setResult()
     * @uses S_USER_SEARCH_V001Response::setTransactionID()
     * @uses S_USER_SEARCH_V001Response::setUsers()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Users[] $users
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $users = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setUsers($users);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_USER_SEARCH_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_USER_SEARCH_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Users value
     * @return \StructType\Users[]|null
     */
    public function getUsers()
    {
        return $this->Users;
    }
    /**
     * This method is responsible for validating the values passed to the setUsers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUsers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUsersForArrayConstraintsFromSetUsers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_USER_SEARCH_V001ResponseUsersItem) {
            // validation for constraint: itemType
            if (!$s_USER_SEARCH_V001ResponseUsersItem instanceof \StructType\Users) {
                $invalidValues[] = is_object($s_USER_SEARCH_V001ResponseUsersItem) ? get_class($s_USER_SEARCH_V001ResponseUsersItem) : sprintf('%s(%s)', gettype($s_USER_SEARCH_V001ResponseUsersItem), var_export($s_USER_SEARCH_V001ResponseUsersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Users property can only contain items of type \StructType\Users, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Users value
     * @throws \InvalidArgumentException
     * @param \StructType\Users[] $users
     * @return \StructType\S_USER_SEARCH_V001Response
     */
    public function setUsers(array $users = array())
    {
        // validation for constraint: array
        if ('' !== ($usersArrayErrorMessage = self::validateUsersForArrayConstraintsFromSetUsers($users))) {
            throw new \InvalidArgumentException($usersArrayErrorMessage, __LINE__);
        }
        $this->Users = $users;
        return $this;
    }
    /**
     * Add item to Users value
     * @throws \InvalidArgumentException
     * @param \StructType\Users $item
     * @return \StructType\S_USER_SEARCH_V001Response
     */
    public function addToUsers(\StructType\Users $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Users) {
            throw new \InvalidArgumentException(sprintf('The Users property can only contain items of type \StructType\Users, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Users[] = $item;
        return $this;
    }
}
