<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_USER_GET_CURRENT_V001Response StructType
 * @subpackage Structs
 */
class S_USER_GET_CURRENT_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\User[]
     */
    public $User;
    /**
     * Constructor method for S_USER_GET_CURRENT_V001Response
     * @uses S_USER_GET_CURRENT_V001Response::setResult()
     * @uses S_USER_GET_CURRENT_V001Response::setTransactionID()
     * @uses S_USER_GET_CURRENT_V001Response::setUser()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\User[] $user
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $user = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setUser($user);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_USER_GET_CURRENT_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_USER_GET_CURRENT_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get User value
     * @return \StructType\User[]|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * This method is responsible for validating the values passed to the setUser method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUser method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserForArrayConstraintsFromSetUser(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_USER_GET_CURRENT_V001ResponseUserItem) {
            // validation for constraint: itemType
            if (!$s_USER_GET_CURRENT_V001ResponseUserItem instanceof \StructType\User) {
                $invalidValues[] = is_object($s_USER_GET_CURRENT_V001ResponseUserItem) ? get_class($s_USER_GET_CURRENT_V001ResponseUserItem) : sprintf('%s(%s)', gettype($s_USER_GET_CURRENT_V001ResponseUserItem), var_export($s_USER_GET_CURRENT_V001ResponseUserItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The User property can only contain items of type \StructType\User, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set User value
     * @throws \InvalidArgumentException
     * @param \StructType\User[] $user
     * @return \StructType\S_USER_GET_CURRENT_V001Response
     */
    public function setUser(array $user = array())
    {
        // validation for constraint: array
        if ('' !== ($userArrayErrorMessage = self::validateUserForArrayConstraintsFromSetUser($user))) {
            throw new \InvalidArgumentException($userArrayErrorMessage, __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Add item to User value
     * @throws \InvalidArgumentException
     * @param \StructType\User $item
     * @return \StructType\S_USER_GET_CURRENT_V001Response
     */
    public function addToUser(\StructType\User $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\User) {
            throw new \InvalidArgumentException(sprintf('The User property can only contain items of type \StructType\User, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->User[] = $item;
        return $this;
    }
}
