<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_SERVICE_MAPPING_GET_V001Response StructType
 * @subpackage Structs
 */
class S_SERVICE_MAPPING_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The ServiceSearchEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceSearchEntry[]
     */
    public $ServiceSearchEntry;
    /**
     * Constructor method for S_SERVICE_MAPPING_GET_V001Response
     * @uses S_SERVICE_MAPPING_GET_V001Response::setResult()
     * @uses S_SERVICE_MAPPING_GET_V001Response::setTransactionID()
     * @uses S_SERVICE_MAPPING_GET_V001Response::setServiceSearchEntry()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\ServiceSearchEntry[] $serviceSearchEntry
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $serviceSearchEntry = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setServiceSearchEntry($serviceSearchEntry);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_SERVICE_MAPPING_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_SERVICE_MAPPING_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get ServiceSearchEntry value
     * @return \StructType\ServiceSearchEntry[]|null
     */
    public function getServiceSearchEntry()
    {
        return $this->ServiceSearchEntry;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceSearchEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceSearchEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceSearchEntryForArrayConstraintsFromSetServiceSearchEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_SERVICE_MAPPING_GET_V001ResponseServiceSearchEntryItem) {
            // validation for constraint: itemType
            if (!$s_SERVICE_MAPPING_GET_V001ResponseServiceSearchEntryItem instanceof \StructType\ServiceSearchEntry) {
                $invalidValues[] = is_object($s_SERVICE_MAPPING_GET_V001ResponseServiceSearchEntryItem) ? get_class($s_SERVICE_MAPPING_GET_V001ResponseServiceSearchEntryItem) : sprintf('%s(%s)', gettype($s_SERVICE_MAPPING_GET_V001ResponseServiceSearchEntryItem), var_export($s_SERVICE_MAPPING_GET_V001ResponseServiceSearchEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceSearchEntry property can only contain items of type \StructType\ServiceSearchEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceSearchEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceSearchEntry[] $serviceSearchEntry
     * @return \StructType\S_SERVICE_MAPPING_GET_V001Response
     */
    public function setServiceSearchEntry(array $serviceSearchEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceSearchEntryArrayErrorMessage = self::validateServiceSearchEntryForArrayConstraintsFromSetServiceSearchEntry($serviceSearchEntry))) {
            throw new \InvalidArgumentException($serviceSearchEntryArrayErrorMessage, __LINE__);
        }
        $this->ServiceSearchEntry = $serviceSearchEntry;
        return $this;
    }
    /**
     * Add item to ServiceSearchEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceSearchEntry $item
     * @return \StructType\S_SERVICE_MAPPING_GET_V001Response
     */
    public function addToServiceSearchEntry(\StructType\ServiceSearchEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceSearchEntry) {
            throw new \InvalidArgumentException(sprintf('The ServiceSearchEntry property can only contain items of type \StructType\ServiceSearchEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceSearchEntry[] = $item;
        return $this;
    }
}
