<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ROOM_STATE_SEARCH_V003Response StructType
 * @subpackage Structs
 */
class S_ROOM_STATE_SEARCH_V003Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The roomState
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomState[]
     */
    public $roomState;
    /**
     * Constructor method for S_ROOM_STATE_SEARCH_V003Response
     * @uses S_ROOM_STATE_SEARCH_V003Response::setResult()
     * @uses S_ROOM_STATE_SEARCH_V003Response::setTransactionID()
     * @uses S_ROOM_STATE_SEARCH_V003Response::setRoomState()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\RoomState[] $roomState
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $roomState = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setRoomState($roomState);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ROOM_STATE_SEARCH_V003Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ROOM_STATE_SEARCH_V003Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get roomState value
     * @return \StructType\RoomState[]|null
     */
    public function getRoomState()
    {
        return $this->roomState;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomState method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomState method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomStateForArrayConstraintsFromSetRoomState(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ROOM_STATE_SEARCH_V003ResponseRoomStateItem) {
            // validation for constraint: itemType
            if (!$s_ROOM_STATE_SEARCH_V003ResponseRoomStateItem instanceof \StructType\RoomState) {
                $invalidValues[] = is_object($s_ROOM_STATE_SEARCH_V003ResponseRoomStateItem) ? get_class($s_ROOM_STATE_SEARCH_V003ResponseRoomStateItem) : sprintf('%s(%s)', gettype($s_ROOM_STATE_SEARCH_V003ResponseRoomStateItem), var_export($s_ROOM_STATE_SEARCH_V003ResponseRoomStateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The roomState property can only contain items of type \StructType\RoomState, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set roomState value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomState[] $roomState
     * @return \StructType\S_ROOM_STATE_SEARCH_V003Response
     */
    public function setRoomState(array $roomState = array())
    {
        // validation for constraint: array
        if ('' !== ($roomStateArrayErrorMessage = self::validateRoomStateForArrayConstraintsFromSetRoomState($roomState))) {
            throw new \InvalidArgumentException($roomStateArrayErrorMessage, __LINE__);
        }
        $this->roomState = $roomState;
        return $this;
    }
    /**
     * Add item to roomState value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomState $item
     * @return \StructType\S_ROOM_STATE_SEARCH_V003Response
     */
    public function addToRoomState(\StructType\RoomState $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomState) {
            throw new \InvalidArgumentException(sprintf('The roomState property can only contain items of type \StructType\RoomState, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->roomState[] = $item;
        return $this;
    }
}
