<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ROOM_FREE_ROOM_SEARCH_V001Response StructType
 * @subpackage Structs
 */
class S_ROOM_FREE_ROOM_SEARCH_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The FreeRoomSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FreeRoomSearch[]
     */
    public $FreeRoomSearch;
    /**
     * Constructor method for S_ROOM_FREE_ROOM_SEARCH_V001Response
     * @uses S_ROOM_FREE_ROOM_SEARCH_V001Response::setResult()
     * @uses S_ROOM_FREE_ROOM_SEARCH_V001Response::setTransactionID()
     * @uses S_ROOM_FREE_ROOM_SEARCH_V001Response::setFreeRoomSearch()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\FreeRoomSearch[] $freeRoomSearch
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $freeRoomSearch = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setFreeRoomSearch($freeRoomSearch);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ROOM_FREE_ROOM_SEARCH_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ROOM_FREE_ROOM_SEARCH_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get FreeRoomSearch value
     * @return \StructType\FreeRoomSearch[]|null
     */
    public function getFreeRoomSearch()
    {
        return $this->FreeRoomSearch;
    }
    /**
     * This method is responsible for validating the values passed to the setFreeRoomSearch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFreeRoomSearch method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFreeRoomSearchForArrayConstraintsFromSetFreeRoomSearch(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ROOM_FREE_ROOM_SEARCH_V001ResponseFreeRoomSearchItem) {
            // validation for constraint: itemType
            if (!$s_ROOM_FREE_ROOM_SEARCH_V001ResponseFreeRoomSearchItem instanceof \StructType\FreeRoomSearch) {
                $invalidValues[] = is_object($s_ROOM_FREE_ROOM_SEARCH_V001ResponseFreeRoomSearchItem) ? get_class($s_ROOM_FREE_ROOM_SEARCH_V001ResponseFreeRoomSearchItem) : sprintf('%s(%s)', gettype($s_ROOM_FREE_ROOM_SEARCH_V001ResponseFreeRoomSearchItem), var_export($s_ROOM_FREE_ROOM_SEARCH_V001ResponseFreeRoomSearchItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FreeRoomSearch property can only contain items of type \StructType\FreeRoomSearch, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FreeRoomSearch value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeRoomSearch[] $freeRoomSearch
     * @return \StructType\S_ROOM_FREE_ROOM_SEARCH_V001Response
     */
    public function setFreeRoomSearch(array $freeRoomSearch = array())
    {
        // validation for constraint: array
        if ('' !== ($freeRoomSearchArrayErrorMessage = self::validateFreeRoomSearchForArrayConstraintsFromSetFreeRoomSearch($freeRoomSearch))) {
            throw new \InvalidArgumentException($freeRoomSearchArrayErrorMessage, __LINE__);
        }
        $this->FreeRoomSearch = $freeRoomSearch;
        return $this;
    }
    /**
     * Add item to FreeRoomSearch value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeRoomSearch $item
     * @return \StructType\S_ROOM_FREE_ROOM_SEARCH_V001Response
     */
    public function addToFreeRoomSearch(\StructType\FreeRoomSearch $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FreeRoomSearch) {
            throw new \InvalidArgumentException(sprintf('The FreeRoomSearch property can only contain items of type \StructType\FreeRoomSearch, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FreeRoomSearch[] = $item;
        return $this;
    }
}
