<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ROOM_CHANGE_STATE_V01Request StructType
 * @subpackage Structs
 */
class S_ROOM_CHANGE_STATE_V01Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The RoomStateSearchAndModify
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RoomStateSearchAndModify
     */
    public $RoomStateSearchAndModify;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_ROOM_CHANGE_STATE_V01Request
     * @uses S_ROOM_CHANGE_STATE_V01Request::setAuthentication()
     * @uses S_ROOM_CHANGE_STATE_V01Request::setRoomStateSearchAndModify()
     * @uses S_ROOM_CHANGE_STATE_V01Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\RoomStateSearchAndModify $roomStateSearchAndModify
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\RoomStateSearchAndModify $roomStateSearchAndModify = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setRoomStateSearchAndModify($roomStateSearchAndModify)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_ROOM_CHANGE_STATE_V01Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get RoomStateSearchAndModify value
     * @return \StructType\RoomStateSearchAndModify
     */
    public function getRoomStateSearchAndModify()
    {
        return $this->RoomStateSearchAndModify;
    }
    /**
     * Set RoomStateSearchAndModify value
     * @param \StructType\RoomStateSearchAndModify $roomStateSearchAndModify
     * @return \StructType\S_ROOM_CHANGE_STATE_V01Request
     */
    public function setRoomStateSearchAndModify(\StructType\RoomStateSearchAndModify $roomStateSearchAndModify = null)
    {
        $this->RoomStateSearchAndModify = $roomStateSearchAndModify;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ROOM_CHANGE_STATE_V01Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
