<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request
 * StructType
 * @subpackage Structs
 */
class S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The reservation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Reservation_2
     */
    public $reservation;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The guestPaymentInstruction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GuestPaymentInstruction
     */
    public $guestPaymentInstruction;
    /**
     * The clientPaymentInstruction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ClientPaymentInstruction
     */
    public $clientPaymentInstruction;
    /**
     * The groupPaymentInstruction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GroupPaymentInstruction
     */
    public $groupPaymentInstruction;
    /**
     * Constructor method for S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request
     * @uses S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request::setAuthentication()
     * @uses S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request::setReservation()
     * @uses S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request::setTransactionID()
     * @uses S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request::setGuestPaymentInstruction()
     * @uses S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request::setClientPaymentInstruction()
     * @uses S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request::setGroupPaymentInstruction()
     * @param \StructType\Authentication $authentication
     * @param \StructType\Reservation_2 $reservation
     * @param string $transactionID
     * @param \StructType\GuestPaymentInstruction $guestPaymentInstruction
     * @param \StructType\ClientPaymentInstruction $clientPaymentInstruction
     * @param \StructType\GroupPaymentInstruction $groupPaymentInstruction
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\Reservation_2 $reservation = null, $transactionID = null, \StructType\GuestPaymentInstruction $guestPaymentInstruction = null, \StructType\ClientPaymentInstruction $clientPaymentInstruction = null, \StructType\GroupPaymentInstruction $groupPaymentInstruction = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setReservation($reservation)
            ->setTransactionID($transactionID)
            ->setGuestPaymentInstruction($guestPaymentInstruction)
            ->setClientPaymentInstruction($clientPaymentInstruction)
            ->setGroupPaymentInstruction($groupPaymentInstruction);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get reservation value
     * @return \StructType\Reservation_2
     */
    public function getReservation()
    {
        return $this->reservation;
    }
    /**
     * Set reservation value
     * @param \StructType\Reservation_2 $reservation
     * @return \StructType\S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request
     */
    public function setReservation(\StructType\Reservation_2 $reservation = null)
    {
        $this->reservation = $reservation;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get guestPaymentInstruction value
     * @return \StructType\GuestPaymentInstruction|null
     */
    public function getGuestPaymentInstruction()
    {
        return $this->guestPaymentInstruction;
    }
    /**
     * Set guestPaymentInstruction value
     * @param \StructType\GuestPaymentInstruction $guestPaymentInstruction
     * @return \StructType\S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request
     */
    public function setGuestPaymentInstruction(\StructType\GuestPaymentInstruction $guestPaymentInstruction = null)
    {
        $this->guestPaymentInstruction = $guestPaymentInstruction;
        return $this;
    }
    /**
     * Get clientPaymentInstruction value
     * @return \StructType\ClientPaymentInstruction|null
     */
    public function getClientPaymentInstruction()
    {
        return $this->clientPaymentInstruction;
    }
    /**
     * Set clientPaymentInstruction value
     * @param \StructType\ClientPaymentInstruction $clientPaymentInstruction
     * @return \StructType\S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request
     */
    public function setClientPaymentInstruction(\StructType\ClientPaymentInstruction $clientPaymentInstruction = null)
    {
        $this->clientPaymentInstruction = $clientPaymentInstruction;
        return $this;
    }
    /**
     * Get groupPaymentInstruction value
     * @return \StructType\GroupPaymentInstruction|null
     */
    public function getGroupPaymentInstruction()
    {
        return $this->groupPaymentInstruction;
    }
    /**
     * Set groupPaymentInstruction value
     * @param \StructType\GroupPaymentInstruction $groupPaymentInstruction
     * @return \StructType\S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request
     */
    public function setGroupPaymentInstruction(\StructType\GroupPaymentInstruction $groupPaymentInstruction = null)
    {
        $this->groupPaymentInstruction = $groupPaymentInstruction;
        return $this;
    }
}
