<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_RESERVATION_GROUP_RESERVATION_ADD_V002Response
 * StructType
 * @subpackage Structs
 */
class S_RESERVATION_GROUP_RESERVATION_ADD_V002Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The RecentCreated
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RecentCreated[]
     */
    public $RecentCreated;
    /**
     * Constructor method for S_RESERVATION_GROUP_RESERVATION_ADD_V002Response
     * @uses S_RESERVATION_GROUP_RESERVATION_ADD_V002Response::setResult()
     * @uses S_RESERVATION_GROUP_RESERVATION_ADD_V002Response::setTransactionID()
     * @uses S_RESERVATION_GROUP_RESERVATION_ADD_V002Response::setRecentCreated()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\RecentCreated[] $recentCreated
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $recentCreated = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setRecentCreated($recentCreated);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_RESERVATION_GROUP_RESERVATION_ADD_V002Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_RESERVATION_GROUP_RESERVATION_ADD_V002Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get RecentCreated value
     * @return \StructType\RecentCreated[]|null
     */
    public function getRecentCreated()
    {
        return $this->RecentCreated;
    }
    /**
     * This method is responsible for validating the values passed to the setRecentCreated method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecentCreated method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecentCreatedForArrayConstraintsFromSetRecentCreated(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_RESERVATION_GROUP_RESERVATION_ADD_V002ResponseRecentCreatedItem) {
            // validation for constraint: itemType
            if (!$s_RESERVATION_GROUP_RESERVATION_ADD_V002ResponseRecentCreatedItem instanceof \StructType\RecentCreated) {
                $invalidValues[] = is_object($s_RESERVATION_GROUP_RESERVATION_ADD_V002ResponseRecentCreatedItem) ? get_class($s_RESERVATION_GROUP_RESERVATION_ADD_V002ResponseRecentCreatedItem) : sprintf('%s(%s)', gettype($s_RESERVATION_GROUP_RESERVATION_ADD_V002ResponseRecentCreatedItem), var_export($s_RESERVATION_GROUP_RESERVATION_ADD_V002ResponseRecentCreatedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RecentCreated property can only contain items of type \StructType\RecentCreated, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RecentCreated value
     * @throws \InvalidArgumentException
     * @param \StructType\RecentCreated[] $recentCreated
     * @return \StructType\S_RESERVATION_GROUP_RESERVATION_ADD_V002Response
     */
    public function setRecentCreated(array $recentCreated = array())
    {
        // validation for constraint: array
        if ('' !== ($recentCreatedArrayErrorMessage = self::validateRecentCreatedForArrayConstraintsFromSetRecentCreated($recentCreated))) {
            throw new \InvalidArgumentException($recentCreatedArrayErrorMessage, __LINE__);
        }
        $this->RecentCreated = $recentCreated;
        return $this;
    }
    /**
     * Add item to RecentCreated value
     * @throws \InvalidArgumentException
     * @param \StructType\RecentCreated $item
     * @return \StructType\S_RESERVATION_GROUP_RESERVATION_ADD_V002Response
     */
    public function addToRecentCreated(\StructType\RecentCreated $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecentCreated) {
            throw new \InvalidArgumentException(sprintf('The RecentCreated property can only contain items of type \StructType\RecentCreated, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RecentCreated[] = $item;
        return $this;
    }
}
