<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_RESERVATION_CREATE_V006Response StructType
 * @subpackage Structs
 */
class S_RESERVATION_CREATE_V006Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The RESERVATION
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RESERVATION[]
     */
    public $RESERVATION;
    /**
     * Constructor method for S_RESERVATION_CREATE_V006Response
     * @uses S_RESERVATION_CREATE_V006Response::setResult()
     * @uses S_RESERVATION_CREATE_V006Response::setTransactionID()
     * @uses S_RESERVATION_CREATE_V006Response::setRESERVATION()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\RESERVATION[] $rESERVATION
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $rESERVATION = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setRESERVATION($rESERVATION);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_RESERVATION_CREATE_V006Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_RESERVATION_CREATE_V006Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get RESERVATION value
     * @return \StructType\RESERVATION[]|null
     */
    public function getRESERVATION()
    {
        return $this->RESERVATION;
    }
    /**
     * This method is responsible for validating the values passed to the setRESERVATION method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRESERVATION method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRESERVATIONForArrayConstraintsFromSetRESERVATION(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_RESERVATION_CREATE_V006ResponseRESERVATIONItem) {
            // validation for constraint: itemType
            if (!$s_RESERVATION_CREATE_V006ResponseRESERVATIONItem instanceof \StructType\RESERVATION) {
                $invalidValues[] = is_object($s_RESERVATION_CREATE_V006ResponseRESERVATIONItem) ? get_class($s_RESERVATION_CREATE_V006ResponseRESERVATIONItem) : sprintf('%s(%s)', gettype($s_RESERVATION_CREATE_V006ResponseRESERVATIONItem), var_export($s_RESERVATION_CREATE_V006ResponseRESERVATIONItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RESERVATION property can only contain items of type \StructType\RESERVATION, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RESERVATION value
     * @throws \InvalidArgumentException
     * @param \StructType\RESERVATION[] $rESERVATION
     * @return \StructType\S_RESERVATION_CREATE_V006Response
     */
    public function setRESERVATION(array $rESERVATION = array())
    {
        // validation for constraint: array
        if ('' !== ($rESERVATIONArrayErrorMessage = self::validateRESERVATIONForArrayConstraintsFromSetRESERVATION($rESERVATION))) {
            throw new \InvalidArgumentException($rESERVATIONArrayErrorMessage, __LINE__);
        }
        $this->RESERVATION = $rESERVATION;
        return $this;
    }
    /**
     * Add item to RESERVATION value
     * @throws \InvalidArgumentException
     * @param \StructType\RESERVATION $item
     * @return \StructType\S_RESERVATION_CREATE_V006Response
     */
    public function addToRESERVATION(\StructType\RESERVATION $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RESERVATION) {
            throw new \InvalidArgumentException(sprintf('The RESERVATION property can only contain items of type \StructType\RESERVATION, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RESERVATION[] = $item;
        return $this;
    }
}
