<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_REGISTRATIONCARD_MODIFY_V001Request StructType
 * @subpackage Structs
 */
class S_REGISTRATIONCARD_MODIFY_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The RegistrationCardSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RegistrationCardSearch
     */
    public $RegistrationCardSearch;
    /**
     * The RegistrationCard
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RegistrationCard
     */
    public $RegistrationCard;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_REGISTRATIONCARD_MODIFY_V001Request
     * @uses S_REGISTRATIONCARD_MODIFY_V001Request::setAuthentication()
     * @uses S_REGISTRATIONCARD_MODIFY_V001Request::setRegistrationCardSearch()
     * @uses S_REGISTRATIONCARD_MODIFY_V001Request::setRegistrationCard()
     * @uses S_REGISTRATIONCARD_MODIFY_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\RegistrationCardSearch $registrationCardSearch
     * @param \StructType\RegistrationCard $registrationCard
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\RegistrationCardSearch $registrationCardSearch = null, \StructType\RegistrationCard $registrationCard = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setRegistrationCardSearch($registrationCardSearch)
            ->setRegistrationCard($registrationCard)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_REGISTRATIONCARD_MODIFY_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get RegistrationCardSearch value
     * @return \StructType\RegistrationCardSearch
     */
    public function getRegistrationCardSearch()
    {
        return $this->RegistrationCardSearch;
    }
    /**
     * Set RegistrationCardSearch value
     * @param \StructType\RegistrationCardSearch $registrationCardSearch
     * @return \StructType\S_REGISTRATIONCARD_MODIFY_V001Request
     */
    public function setRegistrationCardSearch(\StructType\RegistrationCardSearch $registrationCardSearch = null)
    {
        $this->RegistrationCardSearch = $registrationCardSearch;
        return $this;
    }
    /**
     * Get RegistrationCard value
     * @return \StructType\RegistrationCard
     */
    public function getRegistrationCard()
    {
        return $this->RegistrationCard;
    }
    /**
     * Set RegistrationCard value
     * @param \StructType\RegistrationCard $registrationCard
     * @return \StructType\S_REGISTRATIONCARD_MODIFY_V001Request
     */
    public function setRegistrationCard(\StructType\RegistrationCard $registrationCard = null)
    {
        $this->RegistrationCard = $registrationCard;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_REGISTRATIONCARD_MODIFY_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
