<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_POLICELIST_ADD_V001Request StructType
 * @subpackage Structs
 */
class S_POLICELIST_ADD_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Person
     */
    public $Person;
    /**
     * The PoliceList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PoliceList
     */
    public $PoliceList;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_POLICELIST_ADD_V001Request
     * @uses S_POLICELIST_ADD_V001Request::setAuthentication()
     * @uses S_POLICELIST_ADD_V001Request::setPerson()
     * @uses S_POLICELIST_ADD_V001Request::setPoliceList()
     * @uses S_POLICELIST_ADD_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\Person $person
     * @param \StructType\PoliceList $policeList
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\Person $person = null, \StructType\PoliceList $policeList = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setPerson($person)
            ->setPoliceList($policeList)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_POLICELIST_ADD_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get Person value
     * @return \StructType\Person
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \StructType\Person $person
     * @return \StructType\S_POLICELIST_ADD_V001Request
     */
    public function setPerson(\StructType\Person $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Get PoliceList value
     * @return \StructType\PoliceList
     */
    public function getPoliceList()
    {
        return $this->PoliceList;
    }
    /**
     * Set PoliceList value
     * @param \StructType\PoliceList $policeList
     * @return \StructType\S_POLICELIST_ADD_V001Request
     */
    public function setPoliceList(\StructType\PoliceList $policeList = null)
    {
        $this->PoliceList = $policeList;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_POLICELIST_ADD_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
