<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_PERSON_SERVICE_GET_V001Response StructType
 * @subpackage Structs
 */
class S_PERSON_SERVICE_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Service[]
     */
    public $Service;
    /**
     * Constructor method for S_PERSON_SERVICE_GET_V001Response
     * @uses S_PERSON_SERVICE_GET_V001Response::setResult()
     * @uses S_PERSON_SERVICE_GET_V001Response::setTransactionID()
     * @uses S_PERSON_SERVICE_GET_V001Response::setService()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Service[] $service
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $service = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setService($service);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_PERSON_SERVICE_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_PERSON_SERVICE_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\Service[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_PERSON_SERVICE_GET_V001ResponseServiceItem) {
            // validation for constraint: itemType
            if (!$s_PERSON_SERVICE_GET_V001ResponseServiceItem instanceof \StructType\Service) {
                $invalidValues[] = is_object($s_PERSON_SERVICE_GET_V001ResponseServiceItem) ? get_class($s_PERSON_SERVICE_GET_V001ResponseServiceItem) : sprintf('%s(%s)', gettype($s_PERSON_SERVICE_GET_V001ResponseServiceItem), var_export($s_PERSON_SERVICE_GET_V001ResponseServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\Service, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\Service[] $service
     * @return \StructType\S_PERSON_SERVICE_GET_V001Response
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\Service $item
     * @return \StructType\S_PERSON_SERVICE_GET_V001Response
     */
    public function addToService(\StructType\Service $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Service) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\Service, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
}
