<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_PACKAGE_SEARCH_V001Response StructType
 * @subpackage Structs
 */
class S_PACKAGE_SEARCH_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The SearchEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchEntry[]
     */
    public $SearchEntry;
    /**
     * Constructor method for S_PACKAGE_SEARCH_V001Response
     * @uses S_PACKAGE_SEARCH_V001Response::setResult()
     * @uses S_PACKAGE_SEARCH_V001Response::setTransactionID()
     * @uses S_PACKAGE_SEARCH_V001Response::setSearchEntry()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\SearchEntry[] $searchEntry
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $searchEntry = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setSearchEntry($searchEntry);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_PACKAGE_SEARCH_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_PACKAGE_SEARCH_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get SearchEntry value
     * @return \StructType\SearchEntry[]|null
     */
    public function getSearchEntry()
    {
        return $this->SearchEntry;
    }
    /**
     * This method is responsible for validating the values passed to the setSearchEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSearchEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSearchEntryForArrayConstraintsFromSetSearchEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_PACKAGE_SEARCH_V001ResponseSearchEntryItem) {
            // validation for constraint: itemType
            if (!$s_PACKAGE_SEARCH_V001ResponseSearchEntryItem instanceof \StructType\SearchEntry) {
                $invalidValues[] = is_object($s_PACKAGE_SEARCH_V001ResponseSearchEntryItem) ? get_class($s_PACKAGE_SEARCH_V001ResponseSearchEntryItem) : sprintf('%s(%s)', gettype($s_PACKAGE_SEARCH_V001ResponseSearchEntryItem), var_export($s_PACKAGE_SEARCH_V001ResponseSearchEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SearchEntry property can only contain items of type \StructType\SearchEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SearchEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchEntry[] $searchEntry
     * @return \StructType\S_PACKAGE_SEARCH_V001Response
     */
    public function setSearchEntry(array $searchEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($searchEntryArrayErrorMessage = self::validateSearchEntryForArrayConstraintsFromSetSearchEntry($searchEntry))) {
            throw new \InvalidArgumentException($searchEntryArrayErrorMessage, __LINE__);
        }
        $this->SearchEntry = $searchEntry;
        return $this;
    }
    /**
     * Add item to SearchEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchEntry $item
     * @return \StructType\S_PACKAGE_SEARCH_V001Response
     */
    public function addToSearchEntry(\StructType\SearchEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchEntry) {
            throw new \InvalidArgumentException(sprintf('The SearchEntry property can only contain items of type \StructType\SearchEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SearchEntry[] = $item;
        return $this;
    }
}
