<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_SEARCH_V002Request StructType
 * @subpackage Structs
 */
class S_GUEST_SEARCH_V002Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The GuestSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GuestSearch
     */
    public $GuestSearch;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_GUEST_SEARCH_V002Request
     * @uses S_GUEST_SEARCH_V002Request::setAuthentication()
     * @uses S_GUEST_SEARCH_V002Request::setGuestSearch()
     * @uses S_GUEST_SEARCH_V002Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\GuestSearch $guestSearch
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\GuestSearch $guestSearch = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setGuestSearch($guestSearch)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_GUEST_SEARCH_V002Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get GuestSearch value
     * @return \StructType\GuestSearch
     */
    public function getGuestSearch()
    {
        return $this->GuestSearch;
    }
    /**
     * Set GuestSearch value
     * @param \StructType\GuestSearch $guestSearch
     * @return \StructType\S_GUEST_SEARCH_V002Request
     */
    public function setGuestSearch(\StructType\GuestSearch $guestSearch = null)
    {
        $this->GuestSearch = $guestSearch;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_SEARCH_V002Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
