<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_MODIFY_V002Request StructType
 * @subpackage Structs
 */
class S_GUEST_MODIFY_V002Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The GuestSearchAndModify
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GuestSearchAndModify
     */
    public $GuestSearchAndModify;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_GUEST_MODIFY_V002Request
     * @uses S_GUEST_MODIFY_V002Request::setAuthentication()
     * @uses S_GUEST_MODIFY_V002Request::setGuestSearchAndModify()
     * @uses S_GUEST_MODIFY_V002Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\GuestSearchAndModify $guestSearchAndModify
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\GuestSearchAndModify $guestSearchAndModify = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setGuestSearchAndModify($guestSearchAndModify)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_GUEST_MODIFY_V002Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get GuestSearchAndModify value
     * @return \StructType\GuestSearchAndModify
     */
    public function getGuestSearchAndModify()
    {
        return $this->GuestSearchAndModify;
    }
    /**
     * Set GuestSearchAndModify value
     * @param \StructType\GuestSearchAndModify $guestSearchAndModify
     * @return \StructType\S_GUEST_MODIFY_V002Request
     */
    public function setGuestSearchAndModify(\StructType\GuestSearchAndModify $guestSearchAndModify = null)
    {
        $this->GuestSearchAndModify = $guestSearchAndModify;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_MODIFY_V002Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
