<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_MERGE_V001Request StructType
 * @subpackage Structs
 */
class S_GUEST_MERGE_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The GUEST_MERGE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GUEST_MERGE
     */
    public $GUEST_MERGE;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_GUEST_MERGE_V001Request
     * @uses S_GUEST_MERGE_V001Request::setAuthentication()
     * @uses S_GUEST_MERGE_V001Request::setGUEST_MERGE()
     * @uses S_GUEST_MERGE_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\GUEST_MERGE $gUEST_MERGE
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\GUEST_MERGE $gUEST_MERGE = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setGUEST_MERGE($gUEST_MERGE)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_GUEST_MERGE_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get GUEST_MERGE value
     * @return \StructType\GUEST_MERGE
     */
    public function getGUEST_MERGE()
    {
        return $this->{'GUEST-MERGE'};
    }
    /**
     * Set GUEST_MERGE value
     * @param \StructType\GUEST_MERGE $gUEST_MERGE
     * @return \StructType\S_GUEST_MERGE_V001Request
     */
    public function setGUEST_MERGE(\StructType\GUEST_MERGE $gUEST_MERGE = null)
    {
        $this->GUEST_MERGE = $this->{'GUEST-MERGE'} = $gUEST_MERGE;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_MERGE_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
